/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.AlreadyBoundException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFDatagramChannel;
import org.newsclub.net.unix.AFDatagramSocketImpl;
import org.newsclub.net.unix.AFInetAddress;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketExtensions;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.DatagramSocketShim;
import org.newsclub.net.unix.SentinelSocketAddress;

public abstract class AFDatagramSocket<A extends AFSocketAddress>
extends DatagramSocketShim
implements AFSocketExtensions,
AFSomeSocket {
    private static final InetSocketAddress WILDCARD_ADDRESS = new InetSocketAddress(0);
    private final AFDatagramSocketImpl<A> impl;
    private final AncillaryDataSupport ancillaryDataSupport;
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AtomicBoolean deleteOnClose = new AtomicBoolean(true);
    private final AFDatagramChannel<A> channel = this.newChannel();

    /*
     * WARNING - void declaration
     */
    protected AFDatagramSocket(AFDatagramSocketImpl<A> impl) {
        super(impl);
        void var1_1;
        this.impl = impl;
        this.ancillaryDataSupport = var1_1.ancillaryDataSupport;
    }

    protected abstract AFDatagramChannel<A> newChannel();

    private Class<? extends AFSocketAddress> socketAddressClass() {
        return this.impl.getAddressFamily().getSocketAddressClass();
    }

    @Override
    public final void connect(InetAddress address, int port) {
        throw new IllegalArgumentException("Cannot connect to InetAddress");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void send(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            void var1_1;
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isBound()) {
                AFDatagramSocket aFDatagramSocket = this;
                aFDatagramSocket.bind(AFSocketAddress.INTERNAL_DUMMY_BIND);
            }
            this.getAFImpl().send((DatagramPacket)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void connect(SocketAddress addr) throws SocketException {
        AFDatagramSocket aFDatagramSocket;
        if (!this.isBound()) {
            aFDatagramSocket = this;
            aFDatagramSocket.bind(AFSocketAddress.INTERNAL_DUMMY_BIND);
        }
        aFDatagramSocket = this;
        super.connect(AFSocketAddress.INTERNAL_DUMMY_DONT_CONNECT);
        try {
            this.getAFImpl().connect(AFSocketAddress.preprocessSocketAddress(this.socketAddressClass(), addr, null));
            return;
        }
        catch (SocketException socketException) {
            addr = socketException;
            throw socketException;
        }
        catch (IOException e) {
            void var1_2;
            throw (SocketException)new SocketException(e.getMessage()).initCause((Throwable)var1_2);
        }
    }

    public final synchronized @Nullable A getRemoteSocketAddress() {
        return this.getAFImpl().getRemoteSocketAddress();
    }

    @Override
    public final boolean isConnected() {
        return super.isConnected() || this.impl.isConnected();
    }

    @Override
    public final boolean isBound() {
        return super.isBound() || this.impl.isBound();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() {
        AFDatagramSocket aFDatagramSocket;
        InetAddress addr;
        if (this.isClosed()) {
            return;
        }
        this.getAFImpl().close();
        boolean bl = this.isBound();
        if (bl && this.deleteOnClose.get() && AFInetAddress.isSupportedAddress(addr = this.getLocalAddress(), (aFDatagramSocket = this).getAFImpl().getAddressFamily())) {
            try {
                aFDatagramSocket = this;
                A socketAddress = AFSocketAddress.unwrap(addr, 0, aFDatagramSocket.getAFImpl().getAddressFamily());
                if (socketAddress != null && ((AFSocketAddress)socketAddress).hasFilename()) {
                    void var1_2;
                    var1_2.getFile().delete();
                }
            }
            catch (IOException iOException) {}
        }
        super.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void bind(SocketAddress addr) throws SocketException {
        block10: {
            boolean isBound = this.isBound();
            if (isBound && addr == AFSocketAddress.INTERNAL_DUMMY_BIND) {
                return;
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!isBound) {
                try {
                    super.bind(AFSocketAddress.INTERNAL_DUMMY_BIND);
                }
                catch (AlreadyBoundException alreadyBoundException) {
                }
                catch (SocketException socketException) {
                    SocketException e = socketException;
                    String message = socketException.getMessage();
                    if (message != null && message.contains("already bound")) break block10;
                    throw e;
                }
            }
        }
        boolean isWildcardBind = WILDCARD_ADDRESS.equals(addr);
        AFSocketAddress epoint = addr == null || isWildcardBind ? null : AFSocketAddress.preprocessSocketAddress(this.socketAddressClass(), addr, null);
        if (epoint instanceof SentinelSocketAddress) {
            return;
        }
        try {
            void var3_5;
            this.getAFImpl().bind((AFSocketAddress)var3_5);
            return;
        }
        catch (SocketException e) {
            void var2_3;
            if (var2_3 == false) {
                void var1_2;
                this.getAFImpl().close();
                throw var1_2;
            }
            return;
        }
    }

    public final @Nullable A getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        return this.getAFImpl().getLocalSocketAddress();
    }

    final AFDatagramSocketImpl<A> getAFImpl() {
        if (this.created.compareAndSet(false, true)) {
            try {
                this.getSoTimeout();
            }
            catch (SocketException socketException) {}
        }
        return this.impl;
    }

    @Override
    public final boolean isClosed() {
        return super.isClosed() || this.getAFImpl().isClosed();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFDatagramChannel<A> getChannel() {
        return this.channel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void receive(DatagramPacket p) throws IOException {
        void var1_1;
        this.getAFImpl().receive((DatagramPacket)var1_1);
    }

    @FunctionalInterface
    public static interface Constructor<A extends AFSocketAddress> {
        public AFDatagramSocket<A> newSocket(FileDescriptor var1) throws IOException;
    }
}

