/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFAddressFamilyConfig;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketAddressConfig;
import org.newsclub.net.unix.FileDescriptorCast;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFAddressFamily<A extends AFSocketAddress> {
    private static final Map<String, AFAddressFamily<?>> AF_MAP = Collections.synchronizedMap(new HashMap());
    private static final Map<String, AFAddressFamily<?>> URI_SCHEMES = Collections.synchronizedMap(new HashMap());
    private static final AtomicBoolean DEFERRED_INIT_DONE = new AtomicBoolean(false);
    private final int domain;
    private AFSocketAddress.AFSocketAddressConstructor<A> addressConstructor;
    private @Nullable Class<A> addressClass;
    private final String juxString;
    private final String juxInetAddressSuffix;
    private final String addressClassname;
    private String selectorProviderClassname;
    private AFSocket.Constructor<A> socketConstructor;
    private AFServerSocket.Constructor<A> serverSocketConstructor;
    private AFSocketAddressConfig<A> addressConfig;
    private SelectorProvider selectorProvider = null;

    /*
     * WARNING - void declaration
     */
    private AFAddressFamily(String juxString, int domain, String addressClassname) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.juxString = juxString;
        this.domain = var2_2;
        this.addressClassname = var3_3;
        this.juxInetAddressSuffix = "." + (String)var1_1 + ".junixsocket";
    }

    /*
     * WARNING - void declaration
     */
    static synchronized <A extends AFSocketAddress> @NonNull AFAddressFamily<A> registerAddressFamily(String juxString, int domain, String addressClassname) {
        void var3_3;
        String string;
        void var2_2;
        void var1_1;
        AFAddressFamily<Object> af = AF_MAP.get(juxString);
        if (af != null) {
            addressClassname = af;
            if (addressClassname.domain != domain) {
                addressClassname = af;
                throw new IllegalStateException("Wrong domain for address family " + juxString + ": " + addressClassname.domain + " vs. " + domain);
            }
            return af;
        }
        af = new AFAddressFamily<A>(juxString, (int)var1_1, (String)var2_2);
        AF_MAP.put(string, af);
        return var3_3;
    }

    static synchronized AFAddressFamily<?> getAddressFamily(String juxString) {
        String string;
        return AF_MAP.get(string);
    }

    final int getDomain() {
        return this.domain;
    }

    final String getJuxString() {
        return this.juxString;
    }

    final AFSocketAddress.AFSocketAddressConstructor<A> getAddressConstructor() {
        if (this.addressConstructor == null) {
            throw new UnsupportedAddressTypeException();
        }
        return this.addressConstructor;
    }

    private synchronized void checkProvider() {
        if (this.socketConstructor == null && this.selectorProvider == null) {
            try {
                this.getSelectorProvider();
                return;
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    final Class<A> getSocketAddressClass() {
        if (this.addressClass == null) {
            throw new UnsupportedAddressTypeException();
        }
        return this.addressClass;
    }

    final String getJuxInetAddressSuffix() {
        return this.juxInetAddressSuffix;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized <A extends AFSocketAddress> AFAddressFamily<A> registerAddressFamily(String juxString, Class<A> addressClass, AFSocketAddressConfig<A> config) {
        void var3_4;
        AFAddressFamily<?> aFAddressFamily;
        AFAddressFamily<?> af = AFAddressFamily.getAddressFamily(juxString);
        if (af == null) {
            throw new IllegalStateException("Address family not supported by native code: " + juxString);
        }
        if (af.addressClassname != null && !addressClass.getName().equals(af.addressClassname)) {
            throw new IllegalStateException("Unexpected classname for address family " + juxString + ": " + addressClass.getName() + "; expected: " + af.addressClassname);
        }
        if (af.addressConstructor != null || af.addressClass != null) {
            throw new IllegalStateException("Already registered: " + juxString);
        }
        af.addressConfig = config;
        af.addressConstructor = config.addressConstructor();
        af.addressClass = aFAddressFamily;
        aFAddressFamily = af;
        synchronized (aFAddressFamily) {
            af.selectorProviderClassname = config.selectorProviderClassname();
        }
        for (String scheme : config.uriSchemes()) {
            void var2_2;
            if (scheme.isEmpty()) {
                throw new IllegalStateException("Invalid URI scheme; cannot register " + scheme + " for " + juxString);
            }
            if (URI_SCHEMES.containsKey(scheme)) {
                throw new IllegalStateException("URI scheme already registered; cannot register " + scheme + " for " + juxString);
            }
            URI_SCHEMES.put((String)var2_2, af);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized <A extends AFSocketAddress> AFAddressFamily<A> registerAddressFamilyImpl(String juxString, AFAddressFamily<A> addressFamily, AFAddressFamilyConfig<A> config) {
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(addressFamily);
        Objects.requireNonNull(config);
        AFAddressFamily<?> af = AFAddressFamily.getAddressFamily(juxString);
        if (af == null) {
            throw new IllegalStateException("Unknown address family: " + juxString);
        }
        if (var1_1 != af) {
            throw new IllegalStateException("Address family inconsistency: " + juxString);
        }
        if (af.socketConstructor != null) {
            String string;
            throw new IllegalStateException("Already registered: " + string);
        }
        af.socketConstructor = config.socketConstructor();
        af.serverSocketConstructor = config.serverSocketConstructor();
        FileDescriptorCast.registerCastingProviders(var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final AFSocket<?> newSocket() throws IOException {
        try {
            AFAddressFamily aFAddressFamily = this;
            aFAddressFamily.checkProvider();
            if (aFAddressFamily.socketConstructor == null) {
                throw new UnsupportedAddressTypeException();
            }
            return aFAddressFamily.socketConstructor.newInstance(null, null);
        }
        catch (UnsupportedOperationException e) {
            void var1_2;
            throw (SocketException)new SocketException().initCause((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized SelectorProvider getSelectorProvider() {
        if (this.selectorProvider != null) {
            return this.selectorProvider;
        }
        if (this.selectorProviderClassname == null) {
            return null;
        }
        try {
            this.selectorProvider = (SelectorProvider)Class.forName(this.selectorProviderClassname).getMethod("provider", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            void var1_1;
            throw new IllegalStateException("Cannot instantiate selector provider for " + this.addressClassname, (Throwable)var1_1);
        }
        return this.selectorProvider;
    }

    public final SocketAddress nullBindAddress() throws IOException {
        return this.addressConfig.nullBindAddress$71c1176e();
    }

    static {
        NativeUnixSocket.isLoaded();
    }
}

