/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.MutableVectorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.IntRange;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b2\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0006\u0088\u0001\u0089\u0001\u008a\u0001B!\b\u0001\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\f\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\f\u0010\u0010J\u001e\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0014J#\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0015J#\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0017J#\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\u0004\b\u0012\u0010\u0019J\u001b\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b\u0012\u0010\u001aJ\u001e\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0086\b\u00a2\u0006\u0004\b\u0012\u0010\u001bJ2\u0010\u001e\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u000f\u00a2\u0006\u0004\b#\u0010$J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b%\u0010\rJ\u001b\u0010&\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b&\u0010\u0013J\u001b\u0010&\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b&\u0010\u001aJ\u001b\u0010&\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\u0004\b&\u0010\u001bJ\u001b\u0010(\u001a\u00020\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b(\u0010\u0013J\u0015\u0010*\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0006\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00028\u0000\u00a2\u0006\u0004\b,\u0010-J2\u0010,\u001a\u00028\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\b,\u0010.J\u0012\u0010/\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0004\b/\u0010-J4\u0010/\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\b/\u0010.JU\u00107\u001a\u00028\u0001\"\u0004\b\u0001\u001002\u0006\u00101\u001a\u00028\u00012'\u00106\u001a#\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000102H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0004\b7\u00108Jj\u0010:\u001a\u00028\u0001\"\u0004\b\u0001\u001002\u0006\u00101\u001a\u00028\u00012<\u00106\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000109H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0004\b:\u0010;JU\u0010<\u001a\u00028\u0001\"\u0004\b\u0001\u001002\u0006\u00101\u001a\u00028\u00012'\u00106\u001a#\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00028\u000102H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0004\b<\u00108Jj\u0010=\u001a\u00028\u0001\"\u0004\b\u0001\u001002\u0006\u00101\u001a\u00028\u00012<\u00106\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00028\u000109H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0004\b=\u0010;J2\u0010?\u001a\u00020\u000f2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\b?\u0010@J8\u0010A\u001a\u00020\u000f2\u0018\u0010>\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f02H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bA\u0010BJ2\u0010C\u001a\u00020\u000f2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bC\u0010@J8\u0010D\u001a\u00020\u000f2\u0018\u0010>\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f02H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bD\u0010BJ\u0018\u0010E\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0086\n\u00a2\u0006\u0004\bE\u0010FJ\u0015\u0010G\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\bG\u0010HJ2\u0010I\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bI\u0010JJ2\u0010K\u001a\u00020\u00062\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bK\u0010JJ\r\u0010L\u001a\u00020\u000b\u00a2\u0006\u0004\bL\u0010MJ\r\u0010N\u001a\u00020\u000b\u00a2\u0006\u0004\bN\u0010MJ\r\u0010O\u001a\u00028\u0000\u00a2\u0006\u0004\bO\u0010-J2\u0010O\u001a\u00028\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bO\u0010.J\u0015\u0010P\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\bP\u0010HJ\u0012\u0010Q\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0004\bQ\u0010-J4\u0010Q\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bQ\u0010.J@\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\"\u0006\b\u0001\u00100\u0018\u00012\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bS\u0010TJU\u0010U\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\"\u0006\b\u0001\u00100\u0018\u00012'\u0010R\u001a#\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000102H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bU\u0010VJW\u0010W\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000\"\u0006\b\u0001\u00100\u0018\u00012)\u0010R\u001a%\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u000102H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bW\u0010XJB\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000\"\u0006\b\u0001\u00100\u0018\u00012\u0014\u0010R\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bY\u0010ZJ\u0018\u0010[\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0004\b[\u0010\\J\u0018\u0010]\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0004\b]\u0010\\J\u0015\u0010^\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b^\u0010\rJ\u001b\u0010_\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b_\u0010\u0013J\u001b\u0010_\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b_\u0010\u001aJ\u001b\u0010_\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\u0004\b_\u0010\u001bJ\u0015\u0010`\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b`\u0010FJ'\u0010a\u001a\u00020\u000f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\ba\u0010@J\u001d\u0010d\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u0006\u00a2\u0006\u0004\bd\u0010eJ\u001b\u0010f\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\bf\u0010\u001aJ2\u0010g\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\bg\u0010\u001fJ \u0010h\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\bh\u0010iJ\u0017\u0010k\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020\u0006H\u0001\u00a2\u0006\u0004\bk\u0010+J%\u0010o\u001a\u00020\u000f2\u0016\u0010n\u001a\u0012\u0012\u0004\u0012\u00028\u00000lj\b\u0012\u0004\u0012\u00028\u0000`m\u00a2\u0006\u0004\bo\u0010pJ2\u0010r\u001a\u00020\u00062\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u001cH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0004\br\u0010JJ\u000f\u0010t\u001a\u00020sH\u0001\u00a2\u0006\u0004\bt\u0010uR0\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0018\n\u0004\b\u0005\u0010v\u0012\u0004\b{\u0010$\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u0012\u0010\u007f\u001a\u00020|8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b}\u0010~R\u0015\u0010\u0082\u0001\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\b\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R!\u0010\u0083\u0001\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0083\u0001\u0010\u0084\u0001R(\u0010\u0007\u001a\u00020\u00062\u0007\u0010\u0085\u0001\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u0007\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0081\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Landroidx/compose/runtime/collection/MutableVector;", "T", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "", "content", "", "size", "<init>", "([Ljava/lang/Object;I)V", "element", "", "add", "(Ljava/lang/Object;)Z", "index", "", "(ILjava/lang/Object;)V", "elements", "addAll", "(Landroidx/compose/runtime/collection/MutableVector;)Z", "([Ljava/lang/Object;)Z", "(ILandroidx/compose/runtime/collection/MutableVector;)Z", "", "(ILjava/util/Collection;)Z", "", "(ILjava/util/List;)Z", "(Ljava/util/Collection;)Z", "(Ljava/util/List;)Z", "Lkotlin/Function1;", "predicate", "any", "(Lkotlin/jvm/functions/Function1;)Z", "", "asMutableList", "()Ljava/util/List;", "clear", "()V", "contains", "containsAll", "other", "contentEquals", "capacity", "ensureCapacity", "(I)V", "first", "()Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "firstOrNull", "R", "initial", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "operation", "fold", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lkotlin/Function3;", "foldIndexed", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "foldRight", "foldRightIndexed", "block", "forEach", "(Lkotlin/jvm/functions/Function1;)V", "forEachIndexed", "(Lkotlin/jvm/functions/Function2;)V", "forEachReversed", "forEachReversedIndexed", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "indexOfFirst", "(Lkotlin/jvm/functions/Function1;)I", "indexOfLast", "isEmpty", "()Z", "isNotEmpty", "last", "lastIndexOf", "lastOrNull", "transform", "map", "(Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "mapIndexed", "(Lkotlin/jvm/functions/Function2;)[Ljava/lang/Object;", "mapIndexedNotNull", "(Lkotlin/jvm/functions/Function2;)Landroidx/compose/runtime/collection/MutableVector;", "mapNotNull", "(Lkotlin/jvm/functions/Function1;)Landroidx/compose/runtime/collection/MutableVector;", "minusAssign", "(Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "removeIf", "start", "end", "removeRange", "(II)V", "retainAll", "reversedAny", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "newSize", "setSize", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "comparator", "sortWith", "(Ljava/util/Comparator;)V", "selector", "sumBy", "", "throwNoSuchElementException", "()Ljava/lang/Void;", "[Ljava/lang/Object;", "getContent", "()[Ljava/lang/Object;", "setContent", "([Ljava/lang/Object;)V", "getContent$annotations", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "indices", "getLastIndex", "()I", "lastIndex", "list", "Ljava/util/List;", "<set-?>", "I", "getSize", "MutableVectorList", "SubList", "VectorListIterator"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1220:1\n48#1:1224\n48#1:1225\n523#1:1226\n53#1:1229\n523#1:1230\n48#1:1231\n523#1:1232\n523#1:1233\n523#1:1234\n48#1:1235\n523#1:1236\n48#1:1237\n523#1:1238\n523#1:1239\n523#1:1240\n48#1:1241\n523#1:1242\n48#1:1245\n48#1:1246\n48#1:1247\n523#1:1248\n1864#2,3:1221\n1855#2,2:1227\n1855#2,2:1243\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n249#1:1224\n259#1:1225\n260#1:1226\n292#1:1229\n293#1:1230\n307#1:1231\n308#1:1232\n334#1:1233\n359#1:1234\n595#1:1235\n595#1:1236\n637#1:1237\n637#1:1238\n665#1:1239\n675#1:1240\n768#1:1241\n769#1:1242\n794#1:1245\n821#1:1246\n859#1:1247\n860#1:1248\n185#1:1221,3\n281#1:1227,2\n782#1:1243,2\n*E\n"})
public final class MutableVector<T>
implements RandomAccess {
    private T[] content;
    private List<T> list;
    private int size;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public MutableVector(T[] content, int size) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = var1_1;
        this.size = var2_2;
    }

    public final T[] getContent() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public final void setContent(T[] TArray) {
        void var1_1;
        Intrinsics.checkNotNullParameter(TArray, (String)"<set-?>");
        this.content = var1_1;
    }

    @PublishedApi
    public static /* synthetic */ void getContent$annotations() {
    }

    public final int getSize() {
        return this.size;
    }

    public final int getLastIndex() {
        return this.getSize() - 1;
    }

    public final IntRange getIndices() {
        return new IntRange(0, this.getSize() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(T element) {
        void var1_1;
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + 1);
        this.content[this.size] = var1_1;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, T element) {
        void var2_2;
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + 1);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + 1), (int)index, (int)this.size);
        }
        var3_3[n] = var2_2;
        int n = this.size;
        this.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, List<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.size());
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this.size);
        }
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            content[index + i] = elements.get(i);
        }
        this.size += var2_2.size();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, MutableVector<T> elements) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.size);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size), (int)index, (int)this.size);
        }
        ArraysKt.copyInto((Object[])elements.content, (Object[])var3_3, (int)var1_1, (int)0, (int)elements.size);
        this.size += var2_2.size;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(List<? extends T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector mutableVector = this;
        return mutableVector.addAll(mutableVector.getSize(), (List<? extends T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(MutableVector<T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector mutableVector = this;
        return mutableVector.addAll(mutableVector.getSize(), (MutableVector<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(T[] elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.length == 0) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.length);
        ArraysKt.copyInto$default((Object[])elements, (Object[])this.content, (int)this.size, (int)0, (int)0, (int)12, null);
        this.size += ((void)var1_1).length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, Collection<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.size());
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this.size);
        }
        Iterable $this$forEachIndexed$iv = elements;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int i = n;
            content[index + i] = item;
        }
        this.size += var2_2.size();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(Collection<? extends T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector mutableVector = this;
        return mutableVector.addAll(mutableVector.size, (Collection<? extends T>)var1_1);
    }

    public final boolean any(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return true;
            } while (++i < size);
        }
        return false;
    }

    public final boolean reversedAny(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return true;
            } while (--i >= 0);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final List<T> asMutableList() {
        List list = this.list;
        if (list == null) {
            void var2_2;
            MutableVectorList mutableVectorList;
            MutableVectorList it = mutableVectorList = new MutableVectorList(this);
            this.list = (List)var2_2;
            list = mutableVectorList;
        }
        return list;
    }

    public final void clear() {
        T[] content = this.content;
        MutableVector mutableVector = this;
        for (int i = mutableVector.getSize() - 1; i >= 0; --i) {
            content[i] = null;
        }
        this.size = 0;
    }

    public final boolean contains(T element) {
        int i = 0;
        MutableVector mutableVector = this;
        int n = mutableVector.getSize() - 1;
        if (n >= 0) {
            while (true) {
                if (Intrinsics.areEqual((mutableVector = this).getContent()[i], element)) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean containsAll(List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(elements.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsAll(Collection<? extends T> elements) {
        Object object;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Object it = object.next();
            if (this.contains(var2_2)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector<T> this_$iv = elements;
        IntRange intRange = new IntRange(0, this_$iv.getSize() - 1);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                MutableVector<T> mutableVector;
                if (!this.contains((mutableVector = elements).getContent()[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public final boolean contentEquals(MutableVector<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.size != this.size) {
            return false;
        }
        int i = 0;
        MutableVector<T> mutableVector = this;
        int n = mutableVector.getSize() - 1;
        if (n >= 0) {
            while (true) {
                MutableVector<T> mutableVector2 = other;
                mutableVector = mutableVector2;
                mutableVector = this;
                if (!Intrinsics.areEqual(mutableVector2.getContent()[i], mutableVector.getContent()[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int capacity) {
        T[] oldContent = this.content;
        if (this.content.length < capacity) {
            void var1_1;
            void var2_2;
            int newSize = Math.max(capacity, oldContent.length * 2);
            T[] TArray = Arrays.copyOf(var2_2, (int)var1_1);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            this.content = TArray;
        }
    }

    public final T first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("MutableVector is empty.");
        }
        MutableVector mutableVector = this;
        return mutableVector.getContent()[0];
    }

    public final T first(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (++i < size);
        }
        this.throwNoSuchElementException();
        throw new KotlinNothingValueException();
    }

    public final T firstOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        MutableVector mutableVector = this;
        return mutableVector.getContent()[0];
    }

    public final T firstOrNull(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (++i < size);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R fold(R initial, Function2<? super R, ? super T, ? extends R> operation) {
        void var1_1;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                Object acc;
                acc = operation.invoke(acc, content[i]);
            } while (++i < size);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R foldIndexed(R initial, Function3<? super Integer, ? super R, ? super T, ? extends R> operation) {
        void var1_1;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                Object acc;
                acc = operation.invoke((Object)i, acc, content[i]);
            } while (++i < size);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R foldRight(R initial, Function2<? super T, ? super R, ? extends R> operation) {
        void var1_1;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                Object acc;
                acc = operation.invoke(content[i], acc);
            } while (--i >= 0);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R foldRightIndexed(R initial, Function3<? super Integer, ? super T, ? super R, ? extends R> operation) {
        void var1_1;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                Object acc;
                acc = operation.invoke((Object)i, content[i], acc);
            } while (--i >= 0);
        }
        return var1_1;
    }

    public final void forEach(Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                block.invoke(content[i]);
            } while (++i < size);
        }
    }

    public final void forEachIndexed(Function2<? super Integer, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                block.invoke((Object)i, content[i]);
            } while (++i < size);
        }
    }

    public final void forEachReversed(Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                block.invoke(content[i]);
            } while (--i >= 0);
        }
    }

    public final void forEachReversedIndexed(Function2<? super Integer, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.getSize() > 0) {
            int i = this.getSize() - 1;
            T[] content = this.getContent();
            do {
                block.invoke((Object)i, content[i]);
            } while (--i >= 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final T get(int index) {
        void var1_1;
        return this.getContent()[var1_1];
    }

    public final int indexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = 0;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (++i < size);
        }
        return -1;
    }

    public final int indexOfFirst(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return i;
            } while (++i < size);
        }
        return -1;
    }

    public final int indexOfLast(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return i;
            } while (--i >= 0);
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final T last() {
        void var2_3;
        if (this.isEmpty()) {
            throw new NoSuchElementException("MutableVector is empty.");
        }
        MutableVector mutableVector = this;
        MutableVector mutableVector2 = this;
        int index$iv = mutableVector2.getSize() - 1;
        return mutableVector.getContent()[var2_3];
    }

    public final T last(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (--i >= 0);
        }
        this.throwNoSuchElementException();
        throw new KotlinNothingValueException();
    }

    public final int lastIndexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = size - 1;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (--i >= 0);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final T lastOrNull() {
        void var2_3;
        if (this.isEmpty()) {
            return null;
        }
        MutableVector mutableVector = this;
        MutableVector mutableVector2 = this;
        int index$iv = mutableVector2.getSize() - 1;
        return mutableVector.getContent()[var2_3];
    }

    public final T lastOrNull(Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (--i >= 0);
        }
        return null;
    }

    public final /* synthetic */ <R> R[] map(Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector mutableVector = this;
            objectArray[n3] = transform.invoke(mutableVector.getContent()[n3]);
        }
        return objectArray;
    }

    public final /* synthetic */ <R> R[] mapIndexed(Function2<? super Integer, ? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector mutableVector = this;
            objectArray[n3] = transform.invoke((Object)n3, mutableVector.getContent()[n3]);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <R> MutableVector<R> mapIndexedNotNull(Function2<? super Integer, ? super T, ? extends R> transform) {
        void var3_3;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        int size = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size];
        int targetSize = 0;
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                Object target;
                if ((target = transform.invoke((Object)i, content[i])) == null) continue;
                arr[targetSize++] = target;
            } while (++i < size);
        }
        return new MutableVector<T>((T[])var3_3, targetSize);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <R> MutableVector<R> mapNotNull(Function1<? super T, ? extends R> transform) {
        void var3_3;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        int size = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size];
        int targetSize = 0;
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                Object target;
                if ((target = transform.invoke(content[i])) == null) continue;
                arr[targetSize++] = target;
            } while (++i < size);
        }
        return new MutableVector<T>((T[])var3_3, targetSize);
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(T element) {
        void var1_1;
        this.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void minusAssign(T element) {
        void var1_1;
        this.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(T element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            void var1_2;
            this.removeAt((int)var1_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeAll(List<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            this.remove(elements.get(i));
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeAll(MutableVector<T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int i = 0;
        MutableVector<T> mutableVector = elements;
        int n = mutableVector.getSize() - 1;
        if (n >= 0) {
            while (true) {
                mutableVector = elements;
                this.remove(mutableVector.getContent()[i]);
                if (i == n) break;
                ++i;
            }
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeAll(Collection<? extends T> elements) {
        void var2_2;
        Object object;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int initialSize = this.size;
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object it = object.next();
            this.remove(var3_3);
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T removeAt(int index) {
        void var3_3;
        Object[] content = this.content;
        T item = this.content[index];
        MutableVector mutableVector = this;
        if (index != mutableVector.getSize() - 1) {
            void var1_1;
            void v0 = var1_1;
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)v0, (int)(v0 + true), (int)this.size);
        }
        int n = this.size;
        this.size = n + -1;
        var2_2[this.size] = null;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start, int end2) {
        if (end2 > start) {
            void var1_1;
            int newSize;
            if (end2 < this.size) {
                ArraysKt.copyInto((Object[])this.content, (Object[])this.content, (int)start, (int)end2, (int)this.size);
            }
            int i = newSize = this.size - (end2 - start);
            MutableVector mutableVector = this;
            int n = mutableVector.getSize() - 1;
            if (newSize <= n) {
                while (true) {
                    this.content[i] = null;
                    if (i == n) break;
                    ++i;
                }
            }
            this.size = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void setSize(int newSize) {
        void var1_1;
        this.size = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeIf(Function1<? super T, Boolean> predicate) {
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int gap = 0;
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            if (((Boolean)predicate.invoke(this.getContent()[i])).booleanValue()) {
                ++gap;
                continue;
            }
            if (gap <= 0) continue;
            this.getContent()[i - gap] = this.getContent()[i];
        }
        ArraysKt.fill((Object[])this.getContent(), null, (int)(size - gap), (int)size);
        this.setSize((int)(var3_3 - var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean retainAll(Collection<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        MutableVector mutableVector = this;
        for (int i = mutableVector.getSize() - 1; i >= 0; --i) {
            mutableVector = this;
            T item = mutableVector.getContent()[i];
            if (elements.contains(item)) continue;
            this.removeAt(i);
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T set(int index, T element) {
        void var2_2;
        T[] content = this.content;
        T old = this.content[index];
        var3_3[var1_1] = var2_2;
        return old;
    }

    /*
     * WARNING - void declaration
     */
    public final void sortWith(Comparator<T> comparator) {
        void var1_1;
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.content, (Comparator)var1_1, (int)0, (int)this.size);
    }

    /*
     * WARNING - void declaration
     */
    public final int sumBy(Function1<? super T, Integer> selector) {
        void var2_2;
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        int sum = 0;
        int size = this.getSize();
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                sum += ((Number)selector.invoke(content[i])).intValue();
            } while (++i < size);
        }
        return (int)var2_2;
    }

    @PublishedApi
    public final Void throwNoSuchElementException() {
        throw new NoSuchElementException("MutableVector contains no element matching the predicate.");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010+\n\u0002\b\u0011\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\t\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\t\u0010\u000eJ%\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0011\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\nJ\u001d\u0010\u0017\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0018\u0010\u0018\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b!\u0010\u001bJ\u0015\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b#\u0010%J\u0017\u0010&\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b&\u0010\nJ\u001d\u0010'\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b'\u0010\u0013J\u0017\u0010(\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b(\u0010\u0019J\u001d\u0010)\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016\u00a2\u0006\u0004\b)\u0010\u0013J \u0010*\u001a\u00028\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J%\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b.\u0010/R\u0014\u00102\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00103"}, d2={"Landroidx/compose/runtime/collection/MutableVector$MutableVectorList;", "T", "", "Landroidx/compose/runtime/collection/MutableVector;", "vector", "<init>", "(Landroidx/compose/runtime/collection/MutableVector;)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(ILjava/util/Collection;)Z", "(Ljava/util/Collection;)Z", "clear", "()V", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "lastIndexOf", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "getSize", "()I", "size", "Landroidx/compose/runtime/collection/MutableVector;"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,1220:1\n523#2:1221\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n*L\n967#1:1221\n*E\n"})
    private static final class MutableVectorList<T>
    implements List<T>,
    KMutableList {
        private final MutableVector<T> vector;

        /*
         * WARNING - void declaration
         */
        public MutableVectorList(MutableVector<T> vector) {
            void var1_1;
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            this.vector = var1_1;
        }

        public final int getSize() {
            return this.vector.getSize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object element) {
            void var1_1;
            return this.vector.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.containsAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(int index) {
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            MutableVector<T> mutableVector = this.vector;
            return mutableVector.getContent()[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexOf(Object element) {
            void var1_1;
            return this.vector.indexOf(var1_1);
        }

        @Override
        public final boolean isEmpty() {
            return this.vector.isEmpty();
        }

        @Override
        public final Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int lastIndexOf(Object element) {
            void var1_1;
            return this.vector.lastIndexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean add(T element) {
            void var1_1;
            return this.vector.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(int index, T element) {
            void var2_2;
            void var1_1;
            this.vector.add((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(int index, Collection<? extends T> elements) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll((int)var1_1, (Collection<T>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(Collection<? extends T> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll((Collection<T>)var1_1);
        }

        @Override
        public final void clear() {
            this.vector.clear();
        }

        @Override
        public final ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            return new VectorListIterator(this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object element) {
            void var1_1;
            return this.vector.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.removeAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final T removeAt(int index) {
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.vector.removeAt((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.retainAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T set(int index, T element) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.vector.set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<T> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010+\n\u0002\b\u0012\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u000fJ%\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\fJ\u001d\u0010\u0018\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0018\u0010\u0019\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\"\u0010\u001cJ\u0015\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010#2\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010&J\u0017\u0010'\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b'\u0010\fJ\u001d\u0010(\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00a2\u0006\u0004\b(\u0010\u0014J\u0017\u0010)\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b)\u0010\u001aJ\u001d\u0010*\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016\u00a2\u0006\u0004\b*\u0010\u0014J \u0010+\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b+\u0010,J%\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b/\u00100R\u0016\u0010\u0006\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u00101R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u0014\u00105\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101"}, d2={"Landroidx/compose/runtime/collection/MutableVector$SubList;", "T", "", "list", "", "start", "end", "<init>", "(Ljava/util/List;II)V", "element", "", "add", "(Ljava/lang/Object;)Z", "index", "", "(ILjava/lang/Object;)V", "", "elements", "addAll", "(ILjava/util/Collection;)Z", "(Ljava/util/Collection;)Z", "clear", "()V", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "lastIndexOf", "", "listIterator", "()Ljava/util/ListIterator;", "(I)Ljava/util/ListIterator;", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "fromIndex", "toIndex", "subList", "(II)Ljava/util/List;", "I", "Ljava/util/List;", "getSize", "()I", "size"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1220:1\n1855#2,2:1221\n1855#2,2:1223\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n*L\n1039#1:1221,2\n1121#1:1223,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        private final List<T> list;
        private final int start;
        private int end;

        /*
         * WARNING - void declaration
         */
        public SubList(List<T> list, int start, int end2) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        public final int getSize() {
            return this.end - this.start;
        }

        @Override
        public final boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsAll(Collection<? extends Object> elements) {
            Object object;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                Object it = object.next();
                if (this.contains(var2_2)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(int index) {
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.get((int)(var1_1 + this.start));
        }

        @Override
        public final int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        public final Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public final int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), (Object)element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean add(T element) {
            void var1_1;
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(int index, T element) {
            void var2_2;
            int n;
            this.list.add((int)(n + this.start), var2_2);
            n = this.end;
            this.end = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(int index, Collection<? extends T> elements) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll((int)(var1_1 + this.start), elements);
            this.end += elements.size();
            return var2_2.size() > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(Collection<? extends T> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            this.end += elements.size();
            return var1_1.size() > 0;
        }

        @Override
        public final void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        public final ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            return new VectorListIterator(this, (int)var1_1);
        }

        @Override
        public final boolean remove(Object element2) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element2)) continue;
                this.list.remove(i);
                int element2 = this.end;
                this.end = element2 + -1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<? extends Object> elements) {
            void var2_2;
            Object object;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                Object it = object.next();
                this.remove(var3_3);
            }
            return var2_2 != this.end;
        }

        /*
         * WARNING - void declaration
         */
        public final T removeAt(int index) {
            void var1_2;
            MutableVectorKt.access$checkIndex(this, index);
            T item = this.list.remove(index + this.start);
            int n = this.end;
            this.end = n + -1;
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<? extends Object> elements) {
            void var2_2;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T item;
                    if (!elements.contains(item = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return var2_2 != this.end;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T set(int index, T element) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.set((int)(var1_1 + this.start), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<T> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000e\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u000f\u0010\u0016\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u000f\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0019\u0010\fR\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001aR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001b"}, d2={"Landroidx/compose/runtime/collection/MutableVector$VectorListIterator;", "T", "", "", "list", "", "index", "<init>", "(Ljava/util/List;I)V", "element", "", "add", "(Ljava/lang/Object;)V", "", "hasNext", "()Z", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "()I", "previous", "previousIndex", "remove", "()V", "set", "I", "Ljava/util/List;"})
    private static final class VectorListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        private final List<T> list;
        private int index;

        /*
         * WARNING - void declaration
         */
        public VectorListIterator(List<T> list, int index) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = var1_1;
            this.index = var2_2;
        }

        @Override
        public final boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public final T next() {
            int n = this.index;
            this.index = n + 1;
            return this.list.get(n);
        }

        @Override
        public final void remove() {
            int n = this.index;
            this.index = n + -1;
            this.list.remove(this.index);
        }

        @Override
        public final boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public final int nextIndex() {
            return this.index;
        }

        @Override
        public final T previous() {
            int n = this.index;
            this.index = n + -1;
            return this.list.get(this.index);
        }

        @Override
        public final int previousIndex() {
            return this.index - 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(T element) {
            void var1_1;
            this.list.add(this.index, var1_1);
            int n = this.index;
            this.index = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void set(T element) {
            void var1_1;
            this.list.set(this.index, var1_1);
        }
    }
}

