/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.AnchoredGroupPath;
import androidx.compose.runtime.DataIterator;
import androidx.compose.runtime.GroupIterator;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.SourceInformationGroupDataIterator;
import androidx.compose.runtime.SourceInformationGroupIterator;
import androidx.compose.runtime.SourceInformationSlotTableGroupIdentity;
import androidx.compose.runtime.tooling.CompositionGroup;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010 \u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001fR\u0016\u0010'\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001fR\u0014\u0010)\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001bR\u0016\u0010-\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b1\u0010\u001b"}, d2={"Landroidx/compose/runtime/SlotTableGroup;", "Landroidx/compose/runtime/tooling/CompositionGroup;", "", "Landroidx/compose/runtime/SlotTable;", "table", "", "group", "version", "<init>", "(Landroidx/compose/runtime/SlotTable;II)V", "", "identityToFind", "find", "(Ljava/lang/Object;)Landroidx/compose/runtime/tooling/CompositionGroup;", "", "iterator", "()Ljava/util/Iterator;", "", "validateRead", "()V", "getCompositionGroups", "()Ljava/lang/Iterable;", "compositionGroups", "getData", "data", "I", "getGroup", "()I", "getGroupSize", "groupSize", "getIdentity", "()Ljava/lang/Object;", "identity", "", "isEmpty", "()Z", "getKey", "key", "getNode", "node", "getSlotsSize", "slotsSize", "", "getSourceInfo", "()Ljava/lang/String;", "sourceInfo", "Landroidx/compose/runtime/SlotTable;", "getTable", "()Landroidx/compose/runtime/SlotTable;", "getVersion"})
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n+ 2 SlotTable.kt\nandroidx/compose/runtime/SlotTable\n*L\n1#1,4179:1\n161#2,8:4180\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotTableGroup\n*L\n3550#1:4180,8\n*E\n"})
final class SlotTableGroup
implements CompositionGroup,
Iterable<CompositionGroup>,
KMappedMarker {
    private final SlotTable table;
    private final int group;
    private final int version;

    /*
     * WARNING - void declaration
     */
    public SlotTableGroup(SlotTable table, int group, int version) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = var1_1;
        this.group = var2_2;
        this.version = var3_3;
    }

    public /* synthetic */ SlotTableGroup(SlotTable slotTable, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = slotTable.getVersion$runtime();
        }
        this(slotTable, n, n2);
    }

    public final SlotTable getTable() {
        return this.table;
    }

    public final int getGroup() {
        return this.group;
    }

    public final int getVersion() {
        return this.version;
    }

    @Override
    public final boolean isEmpty() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group) == 0;
    }

    @Override
    public final Object getKey() {
        if (SlotTableKt.access$hasObjectKey(this.table.getGroups(), this.group)) {
            Object object = this.table.getSlots()[SlotTableKt.access$objectKeyIndex(this.table.getGroups(), this.group)];
            Intrinsics.checkNotNull((Object)object);
            return object;
        }
        return SlotTableKt.access$key(this.table.getGroups(), this.group);
    }

    @Override
    public final String getSourceInfo() {
        if (SlotTableKt.access$hasAux(this.table.getGroups(), this.group)) {
            Object object = this.table.getSlots()[SlotTableKt.access$auxIndex(this.table.getGroups(), this.group)];
            if (object instanceof String) {
                return (String)object;
            }
            return null;
        }
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            return groupSourceInformation.getSourceInformation();
        }
        return null;
    }

    @Override
    public final Object getNode() {
        if (SlotTableKt.access$isNode(this.table.getGroups(), this.group)) {
            return this.table.getSlots()[SlotTableKt.access$nodeIndex(this.table.getGroups(), this.group)];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterable<Object> getData() {
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            void var1_1;
            GroupSourceInformation it = groupSourceInformation;
            return new SourceInformationGroupDataIterator(this.table, this.group, (GroupSourceInformation)var1_1);
        }
        return new DataIterator(this.table, this.group);
    }

    @Override
    public final Object getIdentity() {
        Object object;
        this.validateRead();
        SlotTable slotTable = this.table;
        SlotReader reader$iv = slotTable.openReader();
        try {
            object = reader$iv;
            object = ((SlotReader)object).anchor(this.group);
            reader$iv.close();
        }
        catch (Throwable throwable) {
            ((SlotReader)((Object)slotTable)).close();
            throw throwable;
        }
        return object;
    }

    @Override
    public final Iterable<CompositionGroup> getCompositionGroups() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<CompositionGroup> iterator() {
        this.validateRead();
        GroupSourceInformation groupSourceInformation = this.table.sourceInformationOf(this.group);
        if (groupSourceInformation != null) {
            void var1_1;
            GroupSourceInformation it = groupSourceInformation;
            return new SourceInformationGroupIterator(this.table, this.group, (GroupSourceInformation)var1_1, new AnchoredGroupPath(this.group));
        }
        return new GroupIterator(this.table, this.group + 1, this.group + SlotTableKt.access$groupSize(this.table.getGroups(), this.group));
    }

    @Override
    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.table.getGroups(), this.group);
    }

    @Override
    public final int getSlotsSize() {
        int n;
        int nextGroup = this.group + this.getGroupSize();
        n = nextGroup < this.table.getGroupsSize() ? SlotTableKt.access$dataAnchor(this.table.getGroups(), n) : this.table.getSlotsSize();
        return n - SlotTableKt.access$dataAnchor(this.table.getGroups(), this.group);
    }

    private final void validateRead() {
        if (this.table.getVersion$runtime() != this.version) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CompositionGroup find(Object identityToFind) {
        Intrinsics.checkNotNullParameter((Object)identityToFind, (String)"identityToFind");
        Object object = identityToFind;
        if (object instanceof Anchor) {
            return SlotTableGroup.find$findAnchoredGroup(this, (Anchor)identityToFind);
        }
        if (object instanceof SourceInformationSlotTableGroupIdentity) {
            CompositionGroup compositionGroup = this.find(((SourceInformationSlotTableGroupIdentity)identityToFind).getParentIdentity());
            if (compositionGroup != null) {
                void var1_1;
                object = compositionGroup;
                return SlotTableGroup.find$findRelativeGroup(compositionGroup, ((SourceInformationSlotTableGroupIdentity)var1_1).getIndex());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompositionGroup find$findAnchoredGroup(SlotTableGroup this$0, Anchor anchor) {
        int anchorGroup;
        if (this$0.table.ownsAnchor(anchor) && (anchorGroup = this$0.table.anchorIndex(anchor)) >= this$0.group && anchorGroup - this$0.group < SlotTableKt.access$groupSize(this$0.table.getGroups(), this$0.group)) {
            SlotTableGroup slotTableGroup;
            void var1_2;
            return new SlotTableGroup(this$0.table, (int)var1_2, slotTableGroup.version);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompositionGroup find$findRelativeGroup(CompositionGroup group, int index) {
        void var1_1;
        return (CompositionGroup)CollectionsKt.firstOrNull((List)CollectionsKt.drop(group.getCompositionGroups(), (int)var1_1));
    }
}

