/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ \u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019R\u0011\u0010 \u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f"}, d2={"Landroidx/compose/runtime/BitVector;", "", "<init>", "()V", "", "index", "", "get", "(I)Z", "nextClear", "(I)I", "nextSet", "value", "", "set", "(IZ)V", "start", "end", "setRange", "(II)V", "", "toString", "()Ljava/lang/String;", "", "first", "J", "", "others", "[J", "second", "getSize", "()I", "size"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/BitVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4179:1\n1#2:4180\n*E\n"})
public final class BitVector {
    private long first;
    private long second;
    private long[] others;
    public static final int $stable = 8;

    public final int getSize() {
        long[] lArray;
        long[] lArray2 = lArray = this.others;
        if (lArray2 != null) {
            return (lArray2.length + 2) * 64;
        }
        return 128;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean get(int index) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (index < 0 || index >= this.getSize()) {
            throw new IllegalStateException(("Index " + index + " out of bound").toString());
        }
        if (index < 64) {
            return (this.first & 1L << index) != 0L;
        }
        if (index < 128) {
            return (this.second & 1L << index - 64) != 0L;
        }
        if (this.others == null) {
            return false;
        }
        int address = index / 64 - 2;
        long[] others = this.others;
        if (address >= others.length) {
            return false;
        }
        int bit = index % 64;
        return (var2_2[var3_3] & 1L << var1_1) != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int index, boolean value) {
        void var2_3;
        long[] others;
        if (index < 64) {
            long mask = 1L << index;
            this.first = value ? this.first | mask : this.first & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        if (index < 128) {
            long mask = 1L << index - 64;
            this.second = value ? this.second | mask : this.second & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int address = index / 64 - 2;
        long mask = 1L << index % 64;
        long[] lArray = this.others;
        if (this.others == null) {
            BitVector $this$set_u24lambda_u241 = this;
            long[] others2 = new long[address + 1];
            $this$set_u24lambda_u241.others = others2;
            lArray = others2;
        }
        if (address >= (others = lArray).length) {
            long[] lArray2 = Arrays.copyOf(others, address + 1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
            this.others = others = lArray2;
        }
        long bits = others[address];
        var1_2[var3_6] = var2_3 != false ? bits | mask : bits & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    public final int nextSet(int index) {
        void bit;
        int size = this.getSize();
        while (bit < size) {
            if (this.get((int)bit)) {
                return (int)bit;
            }
            ++bit;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public final int nextClear(int index) {
        void bit;
        int size = this.getSize();
        while (bit < size) {
            if (!this.get((int)bit)) {
                return (int)bit;
            }
            ++bit;
        }
        return Integer.MAX_VALUE;
    }

    public final void setRange(int start, int end2) {
        for (int bit = start; bit < end2; ++bit) {
            this.set(bit, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean first = true;
        $this$toString_u24lambda_u242.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!first) {
                $this$toString_u24lambda_u242.append(", ");
            }
            first = false;
            $this$toString_u24lambda_u242.append(i);
        }
        var2_2.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

