/*
 * Decompiled with CFR 0.152.
 */
package application.shared.desktop.platform;

import application.core.system.linux.FreedesktopKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import shared.system.install.JvmInstallationKt;
import shared.system.process.DesktopSystemKt;

@SourceDebugExtension(value={"SMAP\nLinuxInstallation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxInstallation.kt\napplication/shared/desktop/platform/LinuxInstallationKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,36:1\n385#2,11:37\n*S KotlinDebug\n*F\n+ 1 LinuxInstallation.kt\napplication/shared/desktop/platform/LinuxInstallationKt\n*L\n16#1:37,11\n*E\n"})
public final class LinuxInstallationKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(LinuxInstallationKt::logger$lambda$0);
    private static final Lazy isLinuxDebInstall$delegate = LazyKt.lazy(LinuxInstallationKt::isLinuxDebInstall_delegate$lambda$7);

    /*
     * WARNING - void declaration
     */
    public static final File linuxFindOwnFreedesktopDesktopFile() {
        Object object;
        block3: {
            void var1_1;
            void var2_2;
            Iterator iterator;
            if (LinuxInstallationKt.isLinuxDebInstall()) {
                return new File("/usr/share/applications/app.flechette.application.desktop");
            }
            Sequence $this$singleOrNull$iv = FreedesktopKt.findFreedesktopDesktopFiles();
            Object single$iv = null;
            boolean found$iv = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element$iv = iterator.next();
                File file = (File)element$iv;
                if (!LinuxInstallationKt.linuxIsOwnFreedesktopDesktopFile(file)) continue;
                if (found$iv) {
                    object = null;
                    break block3;
                }
                single$iv = var3_3;
                found$iv = true;
            }
            object = var2_2 == false ? null : var1_1;
        }
        return (File)object;
    }

    public static final boolean linuxIsOwnFreedesktopDesktopFile(File desktopFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)desktopFile, (String)"desktopFile");
        Object object = (Map)FreedesktopKt.parseDesktopFile((File)file).get("Desktop Entry");
        if (object != null && (object = (String)object.get("Exec")) != null) {
            CharSequence charSequence = (CharSequence)object;
            String string = JvmInstallationKt.getOwnExecutable().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null);
        }
        return false;
    }

    public static final boolean isLinuxDebInstall() {
        Lazy lazy = isLinuxDebInstall$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object isLinuxDebInstall_delegate$lambda$7$lambda$5$lambda$4$lambda$2() {
        return "Installed as a DEB package on Linux";
    }

    private static final Object isLinuxDebInstall_delegate$lambda$7$lambda$5$lambda$4$lambda$3() {
        return "Not installed as a DEB package on Linux";
    }

    private static final boolean isLinuxDebInstall_delegate$lambda$7$lambda$5(String output) {
        String string;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        CharSequence charSequence = string;
        String string2 = JvmInstallationKt.getOwnExecutable().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        boolean bl = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null);
        if (bl) {
            logger.info(LinuxInstallationKt::isLinuxDebInstall_delegate$lambda$7$lambda$5$lambda$4$lambda$2);
        } else {
            logger.info(LinuxInstallationKt::isLinuxDebInstall_delegate$lambda$7$lambda$5$lambda$4$lambda$3);
        }
        return bl;
    }

    private static final Object isLinuxDebInstall_delegate$lambda$7$lambda$6() {
        return "Not installed as a DEB package on Linux";
    }

    private static final boolean isLinuxDebInstall_delegate$lambda$7() {
        boolean bl;
        try {
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            stringArray[0] = "dpkg-query";
            stringArray2[1] = "-L";
            Intrinsics.checkNotNullExpressionValue((Object)"Flechette".toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            bl = (Boolean)DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, LinuxInstallationKt::isLinuxDebInstall_delegate$lambda$7$lambda$5);
        }
        catch (Exception exception) {
            logger.info(LinuxInstallationKt::isLinuxDebInstall_delegate$lambda$7$lambda$6);
            bl = false;
        }
        return bl;
    }
}

