/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J'\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001e\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u0004\u0018\u00010\f2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u001cH\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u0004\u0018\u00010\fJ\b\u0010#\u001a\u0004\u0018\u00010\fJ\u0012\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0017H\u0002J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J)\u0010,\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u0005j\u0002`\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020+H\u0002J\n\u0010/\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u00100\u001a\u00020)*\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000eX\u0082\u0004R\t\u0010\u000f\u001a\u00020\u0010X\u0082\u0004R\t\u0010\u0011\u001a\u00020\u0010X\u0082\u0004R\t\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a8\u00061"}, d2={"Lkotlinx/coroutines/scheduling/WorkQueue;", "", "<init>", "()V", "bufferSize", "", "getBufferSize", "()I", "size", "getSize$kotlinx_coroutines_core", "buffer", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "Lkotlinx/coroutines/scheduling/Task;", "lastScheduledTask", "Lkotlinx/atomicfu/AtomicRef;", "producerIndex", "Lkotlinx/atomicfu/AtomicInt;", "consumerIndex", "blockingTasksInBuffer", "poll", "add", "task", "fair", "", "addLast", "trySteal", "", "stealingMode", "Lkotlinx/coroutines/scheduling/StealingMode;", "stolenTaskRef", "Lkotlin/jvm/internal/Ref$ObjectRef;", "(ILkotlin/jvm/internal/Ref$ObjectRef;)J", "stealWithExclusiveMode", "(I)Lkotlinx/coroutines/scheduling/Task;", "pollBlocking", "pollCpu", "pollWithExclusiveMode", "onlyBlocking", "tryExtractFromTheMiddle", "index", "offloadAllWorkTo", "", "globalQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "tryStealLastScheduled", "pollTo", "queue", "pollBuffer", "decrementIfBlocking", "kotlinx-coroutines-core"})
@SourceDebugExtension(value={"SMAP\nWorkQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkQueue.kt\nkotlinx/coroutines/scheduling/WorkQueue\n+ 2 Tasks.kt\nkotlinx/coroutines/scheduling/TasksKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WorkQueue.kt\nkotlinx/coroutines/scheduling/WorkQueueKt\n*L\n1#1,251:1\n77#2:252\n77#2:253\n77#2:254\n77#2:257\n77#2:258\n1#3:255\n21#4:256\n*S KotlinDebug\n*F\n+ 1 WorkQueue.kt\nkotlinx/coroutines/scheduling/WorkQueue\n*L\n91#1:252\n158#1:253\n181#1:254\n201#1:257\n245#1:258\n201#1:256\n*E\n"})
public final class WorkQueue {
    private final AtomicReferenceArray<Task> buffer = new AtomicReferenceArray(128);
    private volatile /* synthetic */ Object lastScheduledTask$volatile;
    private volatile /* synthetic */ int producerIndex$volatile;
    private volatile /* synthetic */ int consumerIndex$volatile;
    private volatile /* synthetic */ int blockingTasksInBuffer$volatile;
    private static final /* synthetic */ AtomicReferenceFieldUpdater lastScheduledTask$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater producerIndex$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater consumerIndex$volatile$FU;
    private static final /* synthetic */ AtomicIntegerFieldUpdater blockingTasksInBuffer$volatile$FU;

    private final int getBufferSize() {
        return producerIndex$volatile$FU.get(this) - consumerIndex$volatile$FU.get(this);
    }

    public final int getSize$kotlinx_coroutines_core() {
        if (lastScheduledTask$volatile$FU.get(this) != null) {
            return this.getBufferSize() + 1;
        }
        return this.getBufferSize();
    }

    public final Task poll() {
        Task task = lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task == null) {
            task = this.pollBuffer();
        }
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public final Task add(Task task, boolean fair) {
        void var1_1;
        if (fair) {
            return this.addLast(task);
        }
        Task task2 = lastScheduledTask$volatile$FU.getAndSet(this, task);
        if (task2 == null) {
            return null;
        }
        Task previous = task2;
        return this.addLast((Task)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final Task addLast(Task task) {
        void var1_1;
        void var2_3;
        if (this.getBufferSize() == 127) {
            return task;
        }
        Task task2 = task;
        if (task2.taskContext) {
            blockingTasksInBuffer$volatile$FU.incrementAndGet(this);
        }
        int nextIndex = producerIndex$volatile$FU.get(this) & 0x7F;
        while (this.buffer.get(nextIndex) != null) {
            Thread.yield();
        }
        this.buffer.lazySet((int)var2_3, (Task)var1_1);
        producerIndex$volatile$FU.incrementAndGet(this);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final long trySteal(int stealingMode, Ref.ObjectRef<Task> stolenTaskRef) {
        Task task;
        void var1_1;
        void var2_2;
        WorkQueue workQueue;
        int n;
        Task task2;
        block8: {
            if (stealingMode == 3) {
                task2 = this.pollBuffer();
            } else {
                Task task3;
                boolean bl;
                n = stealingMode;
                workQueue = this;
                int n2 = consumerIndex$volatile$FU.get(workQueue);
                int n3 = producerIndex$volatile$FU.get(workQueue);
                boolean bl2 = bl = n == 1;
                while (!(n2 == n3 || bl && blockingTasksInBuffer$volatile$FU.get(workQueue) == 0)) {
                    if ((task2 = workQueue.tryExtractFromTheMiddle(n2++, bl)) == null) {
                        continue;
                    }
                    break block8;
                }
                task2 = task3 = null;
            }
        }
        if (task2 != null) {
            stolenTaskRef.element = workQueue;
            return -1L;
        }
        void var5_6 = var2_2;
        n = var1_1;
        workQueue = this;
        do {
            if ((Task)lastScheduledTask$volatile$FU.get(workQueue) == null) {
                return -2L;
            }
            Task task4 = task;
            Task task5 = task;
            if (((task.taskContext ? 1 : 2) & n) == 0) {
                return -2L;
            }
            long l = TasksKt.schedulerTimeSource.nanoTime();
            long l2 = l - task.submissionTime;
            if (l2 >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS) continue;
            return TasksKt.WORK_STEALING_TIME_RESOLUTION_NS - l2;
        } while (!lastScheduledTask$volatile$FU.compareAndSet(workQueue, task, null));
        var5_6.element = task;
        return -1L;
    }

    public final Task pollBlocking() {
        boolean bl = true;
        WorkQueue workQueue = this;
        while ((Task)lastScheduledTask$volatile$FU.get(workQueue) != null) {
            Task task;
            Task task2 = task;
            if (!task.taskContext) break;
            if (!lastScheduledTask$volatile$FU.compareAndSet(workQueue, task, null)) continue;
            return task;
        }
        int n = consumerIndex$volatile$FU.get(workQueue);
        int n2 = producerIndex$volatile$FU.get(workQueue);
        while (n != n2 && blockingTasksInBuffer$volatile$FU.get(workQueue) != 0) {
            Task task;
            if ((task = workQueue.tryExtractFromTheMiddle(--n2, true)) == null) continue;
            return task;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Task tryExtractFromTheMiddle(int index, boolean onlyBlocking) {
        int arrayIndex = index & 0x7F;
        Task value = this.buffer.get(arrayIndex);
        if (value != null) {
            void var1_1;
            Task task = value;
            if (task.taskContext == onlyBlocking && this.buffer.compareAndSet((int)var1_1, value, null)) {
                void var3_3;
                void var2_2;
                if (var2_2 != false) {
                    blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
                }
                return var3_3;
            }
        }
        return null;
    }

    public final void offloadAllWorkTo(GlobalQueue globalQueue) {
        boolean bl;
        Object object;
        Task task = lastScheduledTask$volatile$FU.getAndSet(this, null);
        if (task != null) {
            Task it = task;
            globalQueue.addLast(object);
        }
        do {
            GlobalQueue globalQueue2 = globalQueue;
            object = this;
            Task task2 = ((WorkQueue)object).pollBuffer();
            if (task2 == null) {
                bl = false;
                continue;
            }
            object = task2;
            globalQueue2.addLast(object);
            bl = true;
        } while (bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Task pollBuffer() {
        void var1_2;
        Task task;
        while (true) {
            void var2_3;
            int tailLocal;
            if ((tailLocal = consumerIndex$volatile$FU.get(this)) - producerIndex$volatile$FU.get(this) == 0) {
                return null;
            }
            int index = tailLocal & 0x7F;
            int n = tailLocal;
            if (!consumerIndex$volatile$FU.compareAndSet(this, n, n + 1)) continue;
            task = this.buffer.getAndSet((int)var2_3, null);
            if (task != null) break;
        }
        Task value = task;
        this.decrementIfBlocking(value);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void decrementIfBlocking(Task $this$decrementIfBlocking) {
        if ($this$decrementIfBlocking != null && $this$decrementIfBlocking.taskContext) {
            void var1_2;
            int value = blockingTasksInBuffer$volatile$FU.decrementAndGet(this);
            if (DebugKt.getASSERTIONS_ENABLED() && !(var1_2 >= 0)) {
                throw new AssertionError();
            }
        }
    }

    static {
        lastScheduledTask$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask$volatile");
        producerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex$volatile");
        consumerIndex$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex$volatile");
        blockingTasksInBuffer$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "blockingTasksInBuffer$volatile");
    }
}

