/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.engine.okhttp.OkHttpCallback;
import io.ktor.client.engine.okhttp.StreamAdapterIOException;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.Headers;
import io.ktor.http.HttpProtocolVersion;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.Job;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a,\u0010\b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0080@\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\f\u001a\u00020\u000b*\u00020\nH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0013\u0010\f\u001a\u00020\u000f*\u00020\u000eH\u0000\u00a2\u0006\u0004\b\f\u0010\u0010\u001a\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0013\u0010\u0017\u001a\u00020\u0016*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018"}, d2={"Lokhttp3/OkHttpClient;", "Lokhttp3/Request;", "request", "Lio/ktor/client/request/HttpRequestData;", "requestData", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Lokhttp3/Response;", "execute", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lokhttp3/Headers;", "Lio/ktor/http/Headers;", "fromOkHttp", "(Lokhttp3/Headers;)Lio/ktor/http/Headers;", "Lokhttp3/Protocol;", "Lio/ktor/http/HttpProtocolVersion;", "(Lokhttp3/Protocol;)Lio/ktor/http/HttpProtocolVersion;", "Ljava/io/IOException;", "origin", "", "mapOkHttpException", "(Lio/ktor/client/request/HttpRequestData;Ljava/io/IOException;)Ljava/lang/Throwable;", "", "isConnectException", "(Ljava/io/IOException;)Z"})
@SourceDebugExtension(value={"SMAP\nOkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,89:1\n351#2,11:90\n*S KotlinDebug\n*F\n+ 1 OkUtils.kt\nio/ktor/client/engine/okhttp/OkUtilsKt\n*L\n22#1:90,11\n*E\n"})
public final class OkUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final Object execute(OkHttpClient $this$execute, Request request, HttpRequestData requestData, CoroutineContext callContext, Continuation<? super Response> $completion) {
        void var1_1;
        OkHttpClient okHttpClient;
        void var2_2;
        void var3_3;
        Continuation<? super Response> uCont$iv = $completion;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        OkHttpClient call = $this$execute.newCall(request);
        CoroutineContext.Element element = var3_3.get((CoroutineContext.Key)Job.Key);
        Intrinsics.checkNotNull((Object)element);
        Job.DefaultImpls.invokeOnCompletion$default((Job)((Job)element), (boolean)true, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>((Call)call){
            final /* synthetic */ Call $call;
            {
                void var1_1;
                this.$call = var1_1;
            }

            public final void invoke(Throwable it) {
                this.$call.cancel();
            }
        }), (int)2, null);
        OkHttpCallback callback = new OkHttpCallback((HttpRequestData)var2_2, (CancellableContinuation<? super Response>)continuation);
        okHttpClient.enqueue((Callback)var1_1);
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static final Headers fromOkHttp(okhttp3.Headers $this$fromOkHttp) {
        okhttp3.Headers headers;
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        return new Headers(headers){
            private final boolean caseInsensitiveName;
            final /* synthetic */ okhttp3.Headers $this_fromOkHttp;
            {
                void var1_1;
                this.$this_fromOkHttp = var1_1;
                this.caseInsensitiveName = true;
            }

            public final boolean getCaseInsensitiveName() {
                return this.caseInsensitiveName;
            }

            public final List<String> getAll(String name) {
                List list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List list2 = list = this.$this_fromOkHttp.values((String)((Object)list));
                if (!((Collection)list).isEmpty()) {
                    return list;
                }
                return null;
            }

            public final Set<String> names() {
                return this.$this_fromOkHttp.names();
            }

            public final Set<Map.Entry<String, List<String>>> entries() {
                return this.$this_fromOkHttp.toMultimap().entrySet();
            }

            public final boolean isEmpty() {
                return this.$this_fromOkHttp.size() == 0;
            }

            /*
             * WARNING - void declaration
             */
            public final String get(String name) {
                void var1_1;
                return Headers.DefaultImpls.get((Headers)this, (String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean contains(String name) {
                void var1_1;
                return Headers.DefaultImpls.contains((Headers)this, (String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean contains(String name, String value) {
                void var2_2;
                void var1_1;
                return Headers.DefaultImpls.contains((Headers)this, (String)var1_1, (String)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void forEach(Function2<? super String, ? super List<String>, Unit> body) {
                void var1_1;
                Headers.DefaultImpls.forEach((Headers)this, (Function2)var1_1);
            }
        };
    }

    public static final HttpProtocolVersion fromOkHttp(Protocol $this$fromOkHttp) {
        Protocol protocol;
        Intrinsics.checkNotNullParameter((Object)$this$fromOkHttp, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[protocol.ordinal()]) {
            case 1: {
                return HttpProtocolVersion.Companion.getHTTP_1_0();
            }
            case 2: {
                return HttpProtocolVersion.Companion.getHTTP_1_1();
            }
            case 3: {
                return HttpProtocolVersion.Companion.getSPDY_3();
            }
            case 4: {
                return HttpProtocolVersion.Companion.getHTTP_2_0();
            }
            case 5: {
                return HttpProtocolVersion.Companion.getHTTP_2_0();
            }
            case 6: {
                return HttpProtocolVersion.Companion.getQUIC();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private static final Throwable mapOkHttpException(HttpRequestData requestData, IOException origin) {
        Throwable throwable;
        block2: {
            void var1_1;
            block3: {
                IOException iOException;
                block1: {
                    iOException = origin;
                    if (!(iOException instanceof StreamAdapterIOException)) break block1;
                    throwable = origin.getCause();
                    if (throwable != null) break block2;
                    break block3;
                }
                if (iOException instanceof SocketTimeoutException) {
                    HttpRequestData httpRequestData;
                    return OkUtilsKt.isConnectException(origin) ? (IOException)HttpTimeoutKt.ConnectTimeoutException((HttpRequestData)requestData, (Throwable)origin) : (IOException)HttpTimeoutKt.SocketTimeoutException((HttpRequestData)httpRequestData, (Throwable)origin);
                }
            }
            throwable = (Throwable)var1_1;
        }
        return throwable;
    }

    private static final boolean isConnectException(IOException $this$isConnectException) {
        String string = $this$isConnectException.getMessage();
        if (string != null) {
            return StringsKt.contains((CharSequence)string, (CharSequence)"connect", (boolean)true);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Throwable access$mapOkHttpException(HttpRequestData requestData, IOException origin) {
        void var1_1;
        return OkUtilsKt.mapOkHttpException(requestData, (IOException)var1_1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Protocol.values().length];
            try {
                nArray[Protocol.HTTP_1_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Protocol.HTTP_1_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Protocol.SPDY_3.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Protocol.HTTP_2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Protocol.H2_PRIOR_KNOWLEDGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Protocol.QUIC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

