/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "<init>", "()V", "Ljava/awt/Window;", "window", "Ljava/awt/Point;", "getCascadeLocationFor", "(Ljava/awt/Window;)Ljava/awt/Point;", "", "onWindowCreated", "(Ljava/awt/Window;)V", "onWindowDisposed", "cascadeOffset", "Ljava/awt/Point;", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "focusListener", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "lastActiveGraphicsConfiguration", "", "lastFocusedWindows", "Ljava/util/Set;"})
@StabilityInferred(parameters=0)
public final class WindowLocationTracker {
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    private static final Point cascadeOffset = new Point(48, 48);
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        /*
         * WARNING - void declaration
         */
        public final void windowGainedFocus(WindowEvent e) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = var1_1.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
            set.add(window);
        }

        public final void windowLostFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };
    public static final int $stable = 8;

    private WindowLocationTracker() {
    }

    public static void onWindowCreated(Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window2.addWindowFocusListener(focusListener);
    }

    public static void onWindowDisposed(Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window2);
    }

    public static GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        if (window != null) {
            return window.getGraphicsConfiguration();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Point getCascadeLocationFor(Window window) {
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Serializable lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (lastWindow == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsConfiguration = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if (object != null) {
            void var1_1;
            void var2_2;
            Serializable serializable;
            void var3_3;
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Cloneable screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNull((Object)screenBounds);
            Cloneable cloneable = screenBounds;
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            Point screenLeftTop = Geometry_desktopKt.plus(new Point(cloneable.x, cloneable.y), new Point(screenInsets.left, screenInsets.top));
            cloneable = var3_3;
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            screenInsets = new Point(screenInsets.right, screenInsets.bottom);
            cloneable = new Point(cloneable.x + cloneable.width, cloneable.y + cloneable.height);
            Intrinsics.checkNotNullParameter((Object)cloneable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)screenInsets, (String)"other");
            Point screenRightBottom = new Point(((Point)cloneable).x - ((Point)screenInsets).x, ((Point)cloneable).y - ((Point)screenInsets).y);
            Window window2 = lastWindow;
            Point point = window2 != null ? window2.getLocation() : null;
            if (point == null) {
                point = screenLeftTop;
            }
            lastWindow = point;
            Point location = Geometry_desktopKt.plus(point, cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            cloneable = dimension;
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"<this>");
            Serializable rightBottom = Geometry_desktopKt.plus(location, new Point(((Dimension)cloneable).width, ((Dimension)cloneable).height));
            if (((Point)rightBottom).x > screenRightBottom.x || ((Point)serializable).y > var2_2.y) {
                location = Geometry_desktopKt.plus(screenLeftTop, cascadeOffset);
            }
            return var1_1;
        }
        return cascadeOffset;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

