/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSemanticsNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 5 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,486:1\n1#2:487\n82#3:488\n82#3:502\n82#3:513\n33#4,6:489\n33#4,6:507\n460#5,7:495\n467#5,4:503\n*S KotlinDebug\n*F\n+ 1 SemanticsNode.kt\nandroidx/compose/ui/semantics/SemanticsNode\n*L\n193#1:488\n277#1:502\n392#1:513\n235#1:489,6\n371#1:507,6\n272#1:495,7\n272#1:503,4\n*E\n"})
public final class SemanticsNode {
    private final Modifier.Node outerSemanticsNode;
    private final boolean mergingEnabled;
    private final LayoutNode layoutNode;
    private final SemanticsConfiguration unmergedConfig;
    private boolean isFake;
    private SemanticsNode fakeNodeParent;
    private final int id;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SemanticsNode(Modifier.Node outerSemanticsNode, boolean mergingEnabled, LayoutNode layoutNode, SemanticsConfiguration unmergedConfig) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)outerSemanticsNode, (String)"outerSemanticsNode");
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        Intrinsics.checkNotNullParameter((Object)unmergedConfig, (String)"unmergedConfig");
        this.outerSemanticsNode = var1_1;
        this.mergingEnabled = var2_2;
        this.layoutNode = var3_3;
        this.unmergedConfig = unmergedConfig;
        this.id = this.layoutNode.getSemanticsId();
    }

    public final Modifier.Node getOuterSemanticsNode$ui() {
        return this.outerSemanticsNode;
    }

    public final LayoutNode getLayoutNode$ui() {
        return this.layoutNode;
    }

    public final SemanticsConfiguration getUnmergedConfig$ui() {
        return this.unmergedConfig;
    }

    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public final SemanticsConfiguration getConfig() {
        if (this.isMergingSemanticsOfDescendants()) {
            void var1_1;
            SemanticsConfiguration mergedConfig = this.unmergedConfig.copy();
            this.mergeConfig(mergedConfig);
            return var1_1;
        }
        return this.unmergedConfig;
    }

    private final void mergeConfig(SemanticsConfiguration mergedConfig) {
        if (!this.unmergedConfig.isClearingSemantics()) {
            int n = 3;
            n = 0;
            n = 0;
            SemanticsNode semanticsNode = this;
            List<SemanticsNode> $this$fastForEach$iv = semanticsNode.unmergedChildren$ui(false, false);
            int n2 = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                SemanticsNode semanticsNode2;
                SemanticsNode child = semanticsNode2 = $this$fastForEach$iv.get(index$iv);
                if (semanticsNode2.isMergingSemanticsOfDescendants()) continue;
                mergedConfig.mergeChild$ui(child.unmergedConfig);
                child.mergeConfig(mergedConfig);
            }
        }
    }

    private final boolean isMergingSemanticsOfDescendants() {
        return this.mergingEnabled && this.unmergedConfig.isMergingSemanticsOfDescendants();
    }

    /*
     * WARNING - void declaration
     */
    private List<SemanticsNode> unmergedChildren$ui(boolean includeFakeNodes, boolean includeDeactivatedNodes) {
        void var3_5;
        void var1_1;
        void var2_3;
        if (this.isFake) {
            return CollectionsKt.emptyList();
        }
        List unmergedChildren = new ArrayList();
        SemanticsNode semanticsNode = this;
        semanticsNode.fillOneLayerOfSemanticsWrappers(semanticsNode.layoutNode, unmergedChildren, (boolean)var2_3);
        if (var1_1 != false) {
            List list = unmergedChildren;
            SemanticsNode semanticsNode2 = this;
            Object object = SemanticsNodeKt.access$getRole(semanticsNode2);
            if (object != null && semanticsNode2.unmergedConfig.isMergingSemanticsOfDescendants() && !((Collection)list).isEmpty()) {
                object = semanticsNode2.fakeSemanticsNode-ypyhhiA((Role)object, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)new Function1<SemanticsPropertyReceiver, Unit>((Role)object){
                    final /* synthetic */ Role $nodeRole;
                    {
                        void var1_1;
                        this.$nodeRole = var1_1;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(SemanticsPropertyReceiver $this$fakeSemanticsNode) {
                        void var1_1;
                        Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
                        SemanticsPropertiesKt.setRole-kuIjeqM((SemanticsPropertyReceiver)var1_1, this.$nodeRole.unbox-impl());
                    }
                }));
                list.add(object);
            }
            if (semanticsNode2.unmergedConfig.contains(SemanticsProperties.INSTANCE.getContentDescription()) && !((Collection)list).isEmpty() && semanticsNode2.unmergedConfig.isMergingSemanticsOfDescendants()) {
                List<String> list2 = SemanticsConfigurationKt.getOrNull(semanticsNode2.unmergedConfig, SemanticsProperties.INSTANCE.getContentDescription());
                object = list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
                if (object != null) {
                    semanticsNode2 = semanticsNode2.fakeSemanticsNode-ypyhhiA(null, (Function1<? super SemanticsPropertyReceiver, Unit>)((Function1)new Function1<SemanticsPropertyReceiver, Unit>((String)object){
                        final /* synthetic */ String $contentDescription;
                        {
                            void var1_1;
                            this.$contentDescription = var1_1;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(SemanticsPropertyReceiver $this$fakeSemanticsNode) {
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)$this$fakeSemanticsNode, (String)"$this$fakeSemanticsNode");
                            SemanticsPropertiesKt.setContentDescription((SemanticsPropertyReceiver)var1_1, this.$contentDescription);
                        }
                    }));
                    list.add(0, semanticsNode2);
                }
            }
        }
        return var3_5;
    }

    private final void fillOneLayerOfSemanticsWrappers(LayoutNode $this$fillOneLayerOfSemanticsWrappers, List<SemanticsNode> list, boolean includeDeactivatedNodes) {
        MutableVector<LayoutNode> this_$iv = $this$fillOneLayerOfSemanticsWrappers.getZSortedChildren();
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child;
                if (!(child = (LayoutNode)content$iv[i$iv]).isAttached() || !includeDeactivatedNodes && child.isDeactivated()) continue;
                int n = 8;
                if (child.getNodes$ui().has-H91voCI$ui(8)) {
                    list.add(SemanticsNodeKt.SemanticsNode(child, this.mergingEnabled));
                    continue;
                }
                this.fillOneLayerOfSemanticsWrappers(child, list, includeDeactivatedNodes);
            } while (++i$iv < size$iv);
        }
    }

    public final List<SemanticsNode> getReplacedChildren$ui() {
        int n = 4;
        n = 0;
        n = 1;
        n = 0;
        SemanticsNode semanticsNode = this;
        return semanticsNode.getChildren$ui(false, true, false);
    }

    /*
     * WARNING - void declaration
     */
    private List<SemanticsNode> getChildren$ui(boolean includeReplacedSemantics, boolean includeFakeNodes2, boolean includeDeactivatedNodes) {
        void var3_5;
        void var2_3;
        if (!includeReplacedSemantics && this.unmergedConfig.isClearingSemantics()) {
            return CollectionsKt.emptyList();
        }
        if (this.isMergingSemanticsOfDescendants()) {
            boolean bl = true;
            List includeFakeNodes2 = null;
            SemanticsNode semanticsNode = this;
            includeFakeNodes2 = new ArrayList();
            return semanticsNode.findOneLayerOfMergingSemanticsNodes(includeFakeNodes2);
        }
        return this.unmergedChildren$ui((boolean)var2_3, (boolean)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final SemanticsNode getParent() {
        void var1_1;
        if (this.fakeNodeParent != null) {
            return this.fakeNodeParent;
        }
        LayoutNode node = null;
        if (this.mergingEnabled) {
            node = SemanticsNodeKt.findClosestParentNode(this.layoutNode, (Function1<? super LayoutNode, Boolean>)((Function1)parent.1.INSTANCE));
        }
        if (node == null) {
            node = SemanticsNodeKt.findClosestParentNode(this.layoutNode, (Function1<? super LayoutNode, Boolean>)((Function1)parent.2.INSTANCE));
        }
        if (node == null) {
            return null;
        }
        return SemanticsNodeKt.SemanticsNode((LayoutNode)var1_1, this.mergingEnabled);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SemanticsNode> findOneLayerOfMergingSemanticsNodes(List<SemanticsNode> list) {
        void var1_1;
        int n = 3;
        n = 0;
        n = 0;
        SemanticsNode semanticsNode = this;
        List<SemanticsNode> $this$fastForEach$iv = semanticsNode.unmergedChildren$ui(false, false);
        int n2 = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            SemanticsNode semanticsNode2;
            SemanticsNode child = semanticsNode2 = $this$fastForEach$iv.get(index$iv);
            if (semanticsNode2.isMergingSemanticsOfDescendants()) {
                list.add(child);
                continue;
            }
            if (child.unmergedConfig.isClearingSemantics()) continue;
            child.findOneLayerOfMergingSemanticsNodes(list);
        }
        return var1_1;
    }

    public final NodeCoordinator findCoordinatorToGetBounds$ui() {
        if (this.isFake) {
            SemanticsNode semanticsNode = this.getParent();
            if (semanticsNode != null) {
                return semanticsNode.findCoordinatorToGetBounds$ui();
            }
            return null;
        }
        SemanticsModifierNode semanticsModifierNode = SemanticsNodeKt.getOuterMergingSemantics(this.layoutNode);
        DelegatableNode delegatableNode = semanticsModifierNode != null ? (DelegatableNode)semanticsModifierNode : (DelegatableNode)this.outerSemanticsNode;
        int n = 8;
        return DelegatableNodeKt.requireCoordinator-64DMado(delegatableNode, 8);
    }

    /*
     * WARNING - void declaration
     */
    private final SemanticsNode fakeSemanticsNode-ypyhhiA(Role role, Function1<? super SemanticsPropertyReceiver, Unit> properties) {
        void configuration;
        void var1_1;
        void var2_2;
        SemanticsConfiguration semanticsConfiguration;
        SemanticsConfiguration it = semanticsConfiguration = new SemanticsConfiguration();
        semanticsConfiguration.setMergingSemanticsOfDescendants(false);
        it.setClearingSemantics(false);
        properties.invoke((Object)it);
        SemanticsNode fakeNode2 = new SemanticsNode((Modifier.Node)((Object)new SemanticsModifierNode((Function1<? super SemanticsPropertyReceiver, Unit>)var2_2){
            final /* synthetic */ Function1<SemanticsPropertyReceiver, Unit> $properties;
            {
                void var1_1;
                this.$properties = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void applySemantics(SemanticsPropertyReceiver $this$applySemantics) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)$this$applySemantics, (String)"<this>");
                this.$properties.invoke((Object)var1_1);
            }
        }), false, new LayoutNode(true, var1_1 != null ? SemanticsNodeKt.access$roleFakeNodeId(this) : SemanticsNodeKt.access$contentDescriptionFakeNodeId(this)), (SemanticsConfiguration)configuration);
        new SemanticsNode((Modifier.Node)((Object)new /* invalid duplicate definition of identical inner class */), false, new LayoutNode(true, var1_1 != null ? SemanticsNodeKt.access$roleFakeNodeId(this) : SemanticsNodeKt.access$contentDescriptionFakeNodeId(this)), (SemanticsConfiguration)configuration).isFake = true;
        fakeNode2.fakeNodeParent = this;
        return semanticsConfiguration;
    }
}

