/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.JvmActuals_jvmKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSemanticsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1747#2,3:200\n*S KotlinDebug\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n*L\n78#1:200,3\n*E\n"})
public final class SemanticsConfiguration
implements SemanticsPropertyReceiver,
Iterable<Map.Entry<? extends SemanticsPropertyKey<?>, ? extends Object>>,
KMappedMarker {
    private final Map<SemanticsPropertyKey<?>, Object> props = new LinkedHashMap();
    private boolean isMergingSemanticsOfDescendants;
    private boolean isClearingSemantics;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public final <T> T getOrElseNullable(SemanticsPropertyKey<T> key, Function0<? extends T> defaultValue) {
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Object object = this.props.get(var1_1);
        if (object == null) {
            void var2_2;
            object = var2_2.invoke();
        }
        return (T)object;
    }

    @Override
    public final Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator() {
        return this.props.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> void set(SemanticsPropertyKey<T> key, T value) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (value instanceof AccessibilityAction && this.contains(key)) {
            Object t;
            Object object = this.props.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
            AccessibilityAction prev = (AccessibilityAction)object;
            Map<SemanticsPropertyKey<?>, Object> map = this.props;
            String string = ((AccessibilityAction)value).getLabel();
            if (string == null) {
                string = prev.getLabel();
            }
            if ((t = ((AccessibilityAction)value).getAction()) == null) {
                void var3_3;
                t = var3_3.getAction();
            }
            value = new AccessibilityAction(string, t);
            map.put(key, value);
            return;
        }
        this.props.put((SemanticsPropertyKey<?>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> boolean contains(SemanticsPropertyKey<T> key) {
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.props.containsKey(var1_1);
    }

    public final boolean isMergingSemanticsOfDescendants() {
        return this.isMergingSemanticsOfDescendants;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMergingSemanticsOfDescendants(boolean bl) {
        void var1_1;
        this.isMergingSemanticsOfDescendants = var1_1;
    }

    public final boolean isClearingSemantics() {
        return this.isClearingSemantics;
    }

    /*
     * WARNING - void declaration
     */
    public final void setClearingSemantics(boolean bl) {
        void var1_1;
        this.isClearingSemantics = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeChild$ui(SemanticsConfiguration child) {
        Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator2;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : ((SemanticsConfiguration)((Object)iterator2)).props.entrySet()) {
            void var3_3;
            SemanticsPropertyKey<?> key = entry.getKey();
            SemanticsPropertyKey<?> nextValue = entry.getValue();
            Object existingValue = this.props.get(key);
            Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.SemanticsPropertyKey<kotlin.Any?>");
            SemanticsPropertyKey<?> semanticsPropertyKey = nextValue;
            Object object = existingValue;
            nextValue = key;
            Object mergeResult = nextValue.mergePolicy.invoke(object, semanticsPropertyKey);
            if (mergeResult == null) continue;
            this.props.put((SemanticsPropertyKey<?>)var3_3, entry);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void collapsePeer$ui(SemanticsConfiguration peer) {
        Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator2;
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        if (peer.isMergingSemanticsOfDescendants) {
            this.isMergingSemanticsOfDescendants = true;
        }
        if (peer.isClearingSemantics) {
            this.isClearingSemantics = true;
        }
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : ((SemanticsConfiguration)((Object)iterator2)).props.entrySet()) {
            void var3_6;
            Object t;
            SemanticsPropertyKey<?> key = entry.getKey();
            Object object = entry.getValue();
            if (!this.props.containsKey(key)) {
                this.props.put(key, object);
                continue;
            }
            if (!(object instanceof AccessibilityAction)) continue;
            Object object2 = this.props.get(key);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
            AccessibilityAction value = (AccessibilityAction)object2;
            Map<SemanticsPropertyKey<?>, Object> map = this.props;
            String string = value.getLabel();
            if (string == null) {
                string = ((AccessibilityAction)object).getLabel();
            }
            if ((t = value.getAction()) == null) {
                t = ((AccessibilityAction)object).getAction();
            }
            AccessibilityAction accessibilityAction = new AccessibilityAction(string, t);
            map.put((SemanticsPropertyKey<?>)var3_6, accessibilityAction);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final SemanticsConfiguration copy() {
        void var1_1;
        SemanticsConfiguration copy = new SemanticsConfiguration();
        new SemanticsConfiguration().isMergingSemanticsOfDescendants = this.isMergingSemanticsOfDescendants;
        copy.isClearingSemantics = this.isClearingSemantics;
        copy.props.putAll(this.props);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticsConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.props, ((SemanticsConfiguration)other).props)) {
            return false;
        }
        if (this.isMergingSemanticsOfDescendants != ((SemanticsConfiguration)other).isMergingSemanticsOfDescendants) {
            return false;
        }
        return this.isClearingSemantics == ((SemanticsConfiguration)var1_1).isClearingSemantics;
    }

    public final int hashCode() {
        int n;
        int result2 = ((Object)this.props).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isMergingSemanticsOfDescendants);
        n = 31 * n + Boolean.hashCode(this.isClearingSemantics);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder propsString = new StringBuilder();
        String nextSeparator = "";
        if (this.isMergingSemanticsOfDescendants) {
            propsString.append(nextSeparator);
            propsString.append("mergeDescendants=true");
            nextSeparator = ", ";
        }
        if (this.isClearingSemantics) {
            propsString.append(nextSeparator);
            propsString.append("isClearingSemantics=true");
            nextSeparator = ", ";
        }
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry : this.props.entrySet()) {
            SemanticsPropertyKey<?> key = entry.getKey();
            Object value = entry.getValue();
            propsString.append(nextSeparator);
            propsString.append(key.getName());
            propsString.append(" : ");
            propsString.append(value);
            nextSeparator = ", ";
        }
        return JvmActuals_jvmKt.simpleIdentityToString(this, null) + "{ " + var1_1 + " }";
    }
}

