/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@StabilityInferred(parameters=0)
public final class ComposeAccessible
extends Component
implements Accessible {
    private final AccessibilityController controller;
    private SemanticsNode semanticsNode;
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    public static final int $stable = 8;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;

    /*
     * WARNING - void declaration
     */
    public ComposeAccessible(SemanticsNode semanticsNode, AccessibilityController controller) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = var2_2;
        this.semanticsNode = var1_1;
        this.isNativelyInitialized$volatile = 0;
        this.composeAccessibleContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleComponent>(this){
            final /* synthetic */ ComposeAccessible this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final ComposeAccessibleComponent invoke() {
                return new ComposeAccessibleComponent(this.this$0);
            }
        }));
    }

    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSemanticsNode(SemanticsNode value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.semanticsNode = var1_1;
        this.cachedSemanticsConfig = null;
    }

    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final void setRemoved(boolean bl) {
        this.removed = true;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    public static final /* synthetic */ SemanticsConfiguration access$getSemanticsConfig(ComposeAccessible $this) {
        ComposeAccessible composeAccessible = $this;
        SemanticsConfiguration semanticsConfiguration = composeAccessible.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration semanticsConfiguration3;
            composeAccessible.cachedSemanticsConfig = semanticsConfiguration3 = (semanticsConfiguration2 = composeAccessible.semanticsNode.getConfig());
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,884:1\n149#2:885\n350#3,7:886\n82#4:893\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n225#1:885\n327#1:886,7\n365#1:893\n*E\n"})
    public final class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        private AccessibleAction accessibleAction;
        private final Lazy accessibleText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleText>(this){
            final /* synthetic */ ComposeAccessibleComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final ComposeAccessibleText invoke() {
                if (this.this$0.getSetText() != null) {
                    return this.this$0.new ComposeAccessibleEditableText();
                }
                if (this.this$0.getText() != null) {
                    return new ComposeAccessibleText(this.this$0);
                }
                return null;
            }
        }));
        final /* synthetic */ ComposeAccessible this$0;

        /*
         * WARNING - void declaration
         */
        public ComposeAccessibleComponent(ComposeAccessible this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsActions.INSTANCE.getSetText());
        }

        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        /*
         * WARNING - void declaration
         */
        public final TextLayoutResult getTextLayoutResult() {
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            accessibilityAction = accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null ? (Boolean)accessibilityAction.invoke(textLayoutResults) : null;
            if (Intrinsics.areEqual(accessibilityAction, (Object)Boolean.TRUE)) {
                void var1_1;
                return (TextLayoutResult)var1_1.get(0);
            }
            return null;
        }

        private Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getFocused());
        }

        private Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return this.this$0.controller.getDesktopComponent().getDensity();
        }

        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getToggleableState());
        }

        /*
         * WARNING - void declaration
         */
        public final List<Accessible> getAuxiliaryChildren() {
            List list;
            List $this$_get_auxiliaryChildren__u24lambda_u242 = list = CollectionsKt.createListBuilder();
            if (this.getHorizontalScroll() != null) {
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
            }
            if (this.getVerticalScroll() != null) {
                void var2_2;
                var2_2.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list);
        }

        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        /*
         * WARNING - void declaration
         */
        private final Accessible makeScrollbarChild(boolean vertical) {
            void var1_2;
            void var2_3;
            void var3_4;
            ScrollBarAccessible bar = new ScrollBarAccessible(this, vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, this.this$0);
            bar.getContext().getAccessibleRelationSet().add((AccessibleRelation)var3_4);
            this.getAccessibleRelationSet().add((AccessibleRelation)var2_3);
            return (Accessible)var1_2;
        }

        private static int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            float f;
            if (Float.isInfinite($this$toAwtPx_u2d0680j_4)) {
                return Integer.MAX_VALUE;
            }
            return MathKt.roundToInt((float)f);
        }

        /*
         * WARNING - void declaration
         */
        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            void var1_1;
            void var2_2;
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            return new Rectangle(ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getWidth())), ComposeAccessibleComponent.toAwtPx-0680j_4(var2_2.toDp-u2uoSUM(var1_1.getHeight())));
        }

        /*
         * WARNING - void declaration
         */
        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            void var1_1;
            void var3_2;
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            return new Point(ComposeAccessibleComponent.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Offset.getX-impl((long)$this$toAwtPoint_u2dk_u2d4lQ0M))), ComposeAccessibleComponent.toAwtPx-0680j_4(var3_2.toDp-u2uoSUM(Offset.getY-impl((long)var1_1))));
        }

        @Override
        public final String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            if (annotatedString != null) {
                return annotatedString.toString();
            }
            return null;
        }

        @Override
        public final String getAccessibleDescription() {
            return (String)ComposeAccessibleKt.access$getFirstOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getContentDescription());
        }

        @Override
        public final Accessible getAccessibleParent() {
            Object object = this.this$0.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = this.this$0;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(n);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    return (Accessible)object;
                }
            }
            return this.accessibleParent;
        }

        @Override
        public final AccessibleComponent getAccessibleComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleAction getAccessibleAction() {
            void var1_1;
            List actions = new ArrayList();
            if (SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsActions.INSTANCE.getOnClick()) != null) {
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction((List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>>)var1_1, this.this$0){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.$actions = var1_1;
                    this.this$0 = var2_2;
                }

                public final int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String getAccessibleActionDescription(int i) {
                    void var1_1;
                    String string = (String)this.$actions.get((int)var1_1).component1();
                    return string;
                }

                public final boolean doAccessibleAction(int i) {
                    AccessibilityAction accessibilityAction;
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    Object object = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), accessibilityAction);
                    if (object != null) {
                        accessibilityAction = object;
                        Function0 function0 = (Function0)((AccessibilityAction)object).getAction();
                        object = function0 != null ? (Boolean)function0.invoke() : null;
                        if (object != null) {
                            return (Boolean)object;
                        }
                    }
                    return false;
                }
            };
            return this.accessibleAction;
        }

        @Override
        public final AccessibleValue getAccessibleValue() {
            if (this.getToggleableState() != null) {
                return new ToggleableAccessibleValue(this);
            }
            if (this.getProgressBarRangeInfo() != null) {
                return new ProgressBarAccessibleValue(this);
            }
            return null;
        }

        @Override
        public final int getAccessibleIndexInParent() {
            int n;
            block3: {
                Object object;
                SemanticsNode semanticsNode = this.this$0.getSemanticsNode().getParent();
                Object object2 = object = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (object2 != null) {
                    object = object2;
                    ComposeAccessible composeAccessible = this.this$0;
                    int index$iv = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object3 = object.next();
                        if (((SemanticsNode)(object3 = (SemanticsNode)object3)).getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block3;
                        }
                        ++index$iv;
                    }
                    return -1;
                }
                n = -1;
            }
            return n;
        }

        @Override
        public final int getAccessibleChildrenCount() {
            return this.this$0.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Accessible getAccessibleChild(int i) {
            void var3_3;
            void var1_1;
            List<SemanticsNode> replacedChildren = this.this$0.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            if (i < replacedChildrenSize) {
                void var2_2;
                return this.this$0.controller.accessibleByNodeId(((SemanticsNode)var2_2.get(i)).getId());
            }
            return this.getAuxiliaryChildren().get((int)(var1_1 - var3_3));
        }

        @Override
        public final Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final Point getLocationOnScreen() {
            long l;
            ComposeAccessibleComponent composeAccessibleComponent = this;
            Object object = composeAccessibleComponent.this$0.getSemanticsNode();
            Object object2 = ((SemanticsNode)object).findCoordinatorToGetBounds$ui();
            if (object2 != null) {
                object = object2;
                NodeCoordinator nodeCoordinator = object2;
                if ((object2 = ((NodeCoordinator)object2).isAttached() ? object : null) != null) {
                    object = (LayoutCoordinates)object2;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
                    l = object.localToScreen-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
                    return composeAccessibleComponent.toAwtPoint-k-4lQ0M(l);
                }
            }
            l = Offset.Companion.getZero-F1C5BW0();
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(l);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final Point getLocation() {
            long l;
            ComposeAccessibleComponent composeAccessibleComponent = this;
            Object object = composeAccessibleComponent.this$0.getSemanticsNode();
            Object object2 = ((SemanticsNode)object).findCoordinatorToGetBounds$ui();
            if (object2 != null) {
                object = object2;
                NodeCoordinator nodeCoordinator = object2;
                if ((object2 = ((NodeCoordinator)object2).isAttached() ? object : null) != null) {
                    l = LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)object2);
                    return composeAccessibleComponent.toAwtPoint-k-4lQ0M(l);
                }
            }
            l = Offset.Companion.getZero-F1C5BW0();
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(l);
        }

        @Override
        public final Rectangle getBounds() {
            Object object;
            ComposeAccessibleComponent composeAccessibleComponent;
            block3: {
                block2: {
                    composeAccessibleComponent = this;
                    Object object2 = composeAccessibleComponent.this$0.getSemanticsNode();
                    object = ((SemanticsNode)object2).findCoordinatorToGetBounds$ui();
                    if (object == null) break block2;
                    object2 = object;
                    NodeCoordinator nodeCoordinator = object;
                    if ((object = ((NodeCoordinator)object).isAttached() ? object2 : null) != null && (object = LayoutCoordinatesKt.boundsInRoot((LayoutCoordinates)object)) != null) break block3;
                }
                object = Rect.Companion.getZero();
            }
            return composeAccessibleComponent.toAwtRectangle((Rect)object);
        }

        @Override
        public final Dimension getSize() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            Object object = composeAccessibleComponent.this$0.getSemanticsNode();
            NodeCoordinator nodeCoordinator = ((SemanticsNode)object).findCoordinatorToGetBounds$ui();
            long l = nodeCoordinator != null ? nodeCoordinator.getSize-YbymL2g() : IntSize.Companion.getZero-YbymL2g();
            object = composeAccessibleComponent;
            object = composeAccessibleComponent.getDensity();
            return new Dimension(ComposeAccessibleComponent.toAwtPx-0680j_4(object.toDp-u2uoSUM(IntSize.getWidth-impl((long)l))), ComposeAccessibleComponent.toAwtPx-0680j_4(object.toDp-u2uoSUM(IntSize.getHeight-impl((long)l))));
        }

        @Override
        public final boolean isVisible() {
            if (!ComposeAccessible.access$getSemanticsConfig(this.this$0).contains(SemanticsProperties.INSTANCE.getInvisibleToUser())) {
                int n = 8;
                if (!DelegatableNodeKt.requireCoordinator-64DMado(this.this$0.getSemanticsNode().getOuterSemanticsNode$ui(), 8).isTransparent()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public final boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public final boolean isShowing() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Accessible getAccessibleAt(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                Accessible accessible2 = this.getAccessibleChild(i);
                Object object = accessible2 != null ? accessible2.getAccessibleContext() : null;
                AccessibleComponent child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt((Point)p)) == null) continue;
                p = object;
                return p;
            }
            if (this.contains((Point)var1_1)) {
                return this.this$0;
            }
            return null;
        }

        @Override
        public final boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public final void requestFocus() {
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.FALSE)) {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus());
                if (accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                    Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke();
                }
            }
        }

        @Override
        public final void addFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void removeFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
            Object object = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getButton-o7Vup1c();
            Role role = object;
            if (role == null ? false : Role.equals-impl0(role.unbox-impl(), n)) {
                accessibleRole = AccessibleRole.PUSH_BUTTON;
            } else {
                n = Role.Companion.getCheckbox-o7Vup1c();
                Object object2 = object;
                if (object2 == null ? false : Role.equals-impl0(((Role)object2).unbox-impl(), n)) {
                    accessibleRole = AccessibleRole.CHECK_BOX;
                } else {
                    n = Role.Companion.getRadioButton-o7Vup1c();
                    Object object3 = object;
                    if (object3 == null ? false : Role.equals-impl0(((Role)object3).unbox-impl(), n)) {
                        accessibleRole = AccessibleRole.RADIO_BUTTON;
                    } else {
                        n = Role.Companion.getTab-o7Vup1c();
                        Object object4 = object;
                        if (object4 == null ? false : Role.equals-impl0(((Role)object4).unbox-impl(), n)) {
                            accessibleRole = AccessibleRole.PAGE_TAB;
                        } else {
                            n = Role.Companion.getDropdownList-o7Vup1c();
                            Object object5 = object;
                            accessibleRole = (object5 == null ? false : Role.equals-impl0(((Role)object5).unbox-impl(), n)) ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            object = accessibleRole;
            AccessibleRole accessibleRole2 = accessibleRole;
            if (accessibleRole == null) {
                object = this;
                if (SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(((ComposeAccessibleComponent)object).this$0), SemanticsProperties.INSTANCE.getPassword()) != null) {
                    AccessibleRole accessibleRole3 = AccessibleRole.PASSWORD_TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"PASSWORD_TEXT");
                    return accessibleRole3;
                }
                if (this.getScrollBy() != null) {
                    AccessibleRole accessibleRole4 = AccessibleRole.SCROLL_PANE;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole4, (String)"SCROLL_PANE");
                    return accessibleRole4;
                }
                if (this.getSetText() != null) {
                    AccessibleRole accessibleRole5 = AccessibleRole.TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole5, (String)"TEXT");
                    return accessibleRole5;
                }
                if (this.getText() != null) {
                    AccessibleRole accessibleRole6 = AccessibleRole.LABEL;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole6, (String)"LABEL");
                    return accessibleRole6;
                }
                if (this.getProgressBarRangeInfo() != null) {
                    AccessibleRole accessibleRole7 = AccessibleRole.PROGRESS_BAR;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole7, (String)"PROGRESS_BAR");
                    return accessibleRole7;
                }
                object = this;
                if (SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(((ComposeAccessibleComponent)object).this$0), SemanticsProperties.INSTANCE.getIsContainer()) != null) {
                    AccessibleRole accessibleRole8 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole8, (String)"GROUP_BOX");
                    return accessibleRole8;
                }
                object = this;
                if (SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(((ComposeAccessibleComponent)object).this$0), SemanticsProperties.INSTANCE.getIsTraversalGroup()) != null) {
                    AccessibleRole accessibleRole9 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole9, (String)"GROUP_BOX");
                    return accessibleRole9;
                }
                AccessibleRole accessibleRole10 = AccessibleRole.UNKNOWN;
                accessibleRole2 = accessibleRole10;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole10, (String)"UNKNOWN");
            }
            return accessibleRole2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleStateSet getAccessibleStateSet() {
            void var2_3;
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = this.this$0;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2412 = accessibleStateSet;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.TRUE)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSED);
            }
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.CHECKED);
                    break;
                }
                case 2: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.INDETERMINATE);
                }
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(composeAccessible), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl = canCollapse = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(composeAccessible), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (var2_3 != false) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (this.getSelected() != null) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTABLE);
            }
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)Boolean.TRUE)) {
                void var3_4;
                var3_4.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        public final AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText2 = this.getAccessibleText();
            if (accessibleText2 instanceof AccessibleEditableText) {
                void var1_1;
                return (AccessibleEditableText)var1_1;
            }
            return null;
        }

        @Override
        public final void setBounds(Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setSize(Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setLocation(Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setBackground(Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setForeground(Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setCursor(Cursor cursor) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setFont(Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final FontMetrics getFontMetrics(Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public final int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                return accessibleAction.getAccessibleActionCount();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getAccessibleActionDescription(int i) {
            void var1_1;
            AccessibleAction accessibleAction = this.accessibleAction;
            String string = accessibleAction != null ? accessibleAction.getAccessibleActionDescription((int)var1_1) : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                void var1_1;
                return accessibleAction.doAccessibleAction((int)var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this$0), key);
            if (accessibilityAction != null) {
                void var2_2;
                AccessibilityAction<Function0<Boolean>> accessibilityAction2;
                void var1_1;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                var1_1.add(new Pair((Object)accessibilityAction2.getLabel(), (Object)var2_2));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ long access$toComposeOffset-tuRUvjQ(ComposeAccessibleComponent $this, Point $receiver) {
            void var1_1;
            ComposeAccessibleComponent composeAccessibleComponent = $this;
            composeAccessibleComponent = composeAccessibleComponent.getDensity();
            int n = var1_1.x;
            int n2 = n;
            n2 = var1_1.y;
            return OffsetKt.Offset((float)composeAccessibleComponent.toPx-0680j_4(Dp.constructor-impl((float)n)), (float)composeAccessibleComponent.toPx-0680j_4(Dp.constructor-impl((float)n2)));
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Rectangle access$toAwtRectangle(ComposeAccessibleComponent $this, Rect $receiver) {
            void var1_1;
            return $this.toAwtRectangle((Rect)var1_1);
        }

        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,884:1\n1241#2:885\n1241#2:886\n1241#2:887\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n688#1:885\n703#1:886\n721#1:887\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleEditableText() {
                void var1_1;
                super((ComposeAccessibleComponent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setTextContents(String s) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString((String)var1_1, null, null, 6, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void insertTextAtIndex(int index, String s) {
                void var3_3;
                void var1_1;
                void var2_2;
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index));
                $this$insertTextAtIndex_u24lambda_u240.append((String)var2_2);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence((int)var1_1, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence((int)var1_1, (int)var2_2)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void delete(int startIndex, int endIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$delete_u24lambda_u241.append(text.subSequence(0, (int)var1_1));
                $this$delete_u24lambda_u241.append(text.subSequence((int)var2_2, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public final void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public final void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void replaceText(int startIndex, int endIndex, String s) {
                void var2_2;
                void var3_3;
                void var1_1;
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, (int)var1_1));
                $this$replaceText_u24lambda_u242.append((String)var3_3);
                $this$replaceText_u24lambda_u242.append(text.subSequence((int)var2_2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void selectText(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                ComposeAccessibleComponent composeAccessibleComponent = ComposeAccessibleComponent.this;
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(composeAccessibleComponent.this$0), SemanticsActions.INSTANCE.getSetSelection());
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)((int)var1_1), (Object)((int)var2_2), (Object)Boolean.FALSE);
            }

            @Override
            public final void setAttributes(int startIndex, int endIndex, AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleText(ComposeAccessibleComponent this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getIndexAtPoint(Point p) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.access$toComposeOffset-tuRUvjQ(this.this$0, (Point)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Rectangle getCharacterBounds(int i) {
                void var1_1;
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        AnnotatedString annotatedString = this.this$0.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        if (i < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)this.this$0.getLocation().x / this.this$0.getDensity().getDensity()), (int)((float)this.this$0.getLocation().y / this.this$0.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.access$toAwtRectangle(this.this$0, textLayoutResult.getBoundingBox((int)var1_1));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            private final BreakIterator partToBreakIterator(int part) {
                void var1_2;
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                breakIterator.setText(annotatedString.toString());
                return var1_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAtIndex(int part, int index) {
                void var1_1;
                void var2_2;
                int end = this.partToBreakIterator(part).following(index);
                if (end == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_2, (int)var1_1).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAfterIndex(int part, int index) {
                void var1_3;
                void var2_4;
                void var3_5;
                BreakIterator iterator2 = this.partToBreakIterator(part);
                while (true) {
                    int start;
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    if (annotatedString.charAt(start) == ' ') continue;
                    AnnotatedString annotatedString2 = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString2);
                    if (annotatedString2.charAt(start) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : var3_5;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_4, (int)var1_3).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getBeforeIndex(int part, int index) {
                void var2_2;
                void var1_1;
                int start = this.partToBreakIterator(part).preceding(index);
                if (start == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getEnd-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        void var3_3;
                        object = this.this$0.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = this.this$0;
                        long selection = textRange.unbox-impl();
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        object = annotatedString.subSequence(TextRange.getStart-impl((long)selection), TextRange.getEnd-impl((long)var3_3)).toString();
                        if (object != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AccessibleTextSequence getTextSequenceAt(int part, int index) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            private final AccessibleContext context;
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ScrollBarAccessible(ComposeAccessibleComponent this$0, boolean vertical) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.vertical = var2_2;
                ScrollBarAccessible scrollBarAccessible = this;
                this.context = (AccessibleContext)((Object)new AccessibleValue(scrollBarAccessible, scrollBarAccessible.this$0, this.this$0.this$0){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        void var1_1;
                        void var3_3;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = var3_3;
                        if (var1_1.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            void var2_2;
                            ScrollAxisRange scrollAxisRange3 = var2_2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public final AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public final AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        if (scrollBarAccessible.getVertical()) {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL);
                        } else {
                            void var3_3;
                            var3_3.add(AccessibleState.HORIZONTAL);
                        }
                        return accessibleStateSet;
                    }

                    public final Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public final int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public final int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public final Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    public final Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    public final Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean setCurrentAccessibleValue(Number n) {
                        void var1_1;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            return (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        }
                        AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                        Intrinsics.checkNotNull(accessibilityAction);
                        Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                        Intrinsics.checkNotNull(function2);
                        void v6 = var1_1;
                        Intrinsics.checkNotNull((Object)v6);
                        return (Boolean)function2.invoke((Object)Float.valueOf(v6.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                    }

                    public final Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public final Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            public final AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

