/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CompositingStrategy;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.Matrices_skikoKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.ReusableGraphicsLayerScope;
import androidx.compose.ui.graphics.TransformOrigin;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerKt;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.platform.InvertMatrixKt;
import androidx.compose.ui.platform.ShapeContainingUtilKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGraphicsLayerOwnerLayer.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphicsLayerOwnerLayer.skiko.kt\nandroidx/compose/ui/platform/GraphicsLayerOwnerLayer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Matrix.kt\nandroidx/compose/ui/graphics/Matrix\n*L\n1#1,357:1\n66#2,9:358\n96#2,7:367\n1#3:374\n39#4:375\n42#4,2:376\n*S KotlinDebug\n*F\n+ 1 GraphicsLayerOwnerLayer.skiko.kt\nandroidx/compose/ui/platform/GraphicsLayerOwnerLayer\n*L\n268#1:358,9\n271#1:367,7\n315#1:375\n327#1:376,2\n*E\n"})
public final class GraphicsLayerOwnerLayer
implements OwnedLayer {
    private GraphicsLayer graphicsLayer;
    private final GraphicsContext context;
    private Function2<? super Canvas, ? super GraphicsLayer, Unit> drawBlock;
    private Function0<Unit> invalidateParentLayer;
    private long size;
    private boolean isDestroyed;
    private final float[] matrixCache;
    private float[] inverseMatrixCache;
    private boolean isDirty;
    private Density density;
    private LayoutDirection layoutDirection;
    private final CanvasDrawScope scope;
    private int mutatedFields;
    private long transformOrigin;
    private Outline outline;
    private boolean isMatrixDirty;
    private boolean isInverseMatrixDirty;
    private boolean isIdentity;
    private boolean drawnWithEnabledZ;
    private final Function1<DrawScope, Unit> recordLambda;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public GraphicsLayerOwnerLayer(GraphicsLayer graphicsLayer, GraphicsContext context2, Function2<? super Canvas, ? super GraphicsLayer, Unit> drawBlock2, Function0<Unit> invalidateParentLayer2) {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)graphicsLayer, (String)"graphicsLayer");
        Intrinsics.checkNotNullParameter(drawBlock2, (String)"drawBlock");
        Intrinsics.checkNotNullParameter(invalidateParentLayer2, (String)"invalidateParentLayer");
        this.graphicsLayer = var1_1;
        this.context = null;
        this.drawBlock = var3_3;
        this.invalidateParentLayer = invalidateParentLayer2;
        this.size = IntSizeKt.IntSize((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        this.matrixCache = Matrix.constructor-impl$default$343e1048(null, (int)1);
        this.density = DensityKt.Density$default$1311851a((float)1.0f, (float)0.0f, (int)2);
        this.layoutDirection = LayoutDirection.Ltr;
        this.scope = new CanvasDrawScope();
        this.transformOrigin = TransformOrigin.Companion.getCenter-SzJe1aQ();
        this.isIdentity = true;
        this.recordLambda = (Function1)new Function1<DrawScope, Unit>(this){
            final /* synthetic */ GraphicsLayerOwnerLayer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(DrawScope $this$null) {
                void $this$drawIntoCanvas$iv;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                DrawScope drawScope = $this$null;
                GraphicsLayerOwnerLayer graphicsLayerOwnerLayer = this.this$0;
                Canvas canvas = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
                Function2 function2 = GraphicsLayerOwnerLayer.access$getDrawBlock$p(graphicsLayerOwnerLayer);
                if (function2 != null) {
                    void var1_1;
                    graphicsLayerOwnerLayer = function2;
                    function2.invoke((Object)drawScope, (Object)var1_1.getDrawContext().getGraphicsLayer());
                    return;
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void updateLayerProperties(ReusableGraphicsLayerScope scope2) {
        void var2_2;
        void var1_1;
        int n;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        int maybeChangedFields = scope2.getMutatedFields$ui() | this.mutatedFields;
        this.layoutDirection = scope2.getLayoutDirection$ui();
        this.density = scope2.getGraphicsDensity$ui();
        if ((maybeChangedFields & 0x1000) != 0) {
            this.transformOrigin = scope2.getTransformOrigin-SzJe1aQ();
        }
        if ((maybeChangedFields & 1) != 0) {
            this.graphicsLayer.setScaleX(scope2.getScaleX());
        }
        if ((maybeChangedFields & 2) != 0) {
            this.graphicsLayer.setScaleY(scope2.getScaleY());
        }
        if ((maybeChangedFields & 4) != 0) {
            this.graphicsLayer.setAlpha(scope2.getAlpha());
        }
        if ((maybeChangedFields & 8) != 0) {
            this.graphicsLayer.setTranslationX(scope2.getTranslationX());
        }
        if ((maybeChangedFields & 0x10) != 0) {
            this.graphicsLayer.setTranslationY(scope2.getTranslationY());
        }
        if ((maybeChangedFields & 0x20) != 0) {
            this.graphicsLayer.setShadowElevation(scope2.getShadowElevation());
        }
        if ((maybeChangedFields & 0x40) != 0) {
            this.graphicsLayer.setAmbientShadowColor-8_81llA(scope2.getAmbientShadowColor-0d7_KjU());
        }
        if ((maybeChangedFields & 0x80) != 0) {
            this.graphicsLayer.setSpotShadowColor-8_81llA(scope2.getSpotShadowColor-0d7_KjU());
        }
        if ((maybeChangedFields & 0x400) != 0) {
            this.graphicsLayer.setRotationZ(scope2.getRotationZ());
        }
        if ((maybeChangedFields & 0x100) != 0) {
            this.graphicsLayer.setRotationX(scope2.getRotationX());
        }
        if ((maybeChangedFields & 0x200) != 0) {
            this.graphicsLayer.setRotationY(scope2.getRotationY());
        }
        if ((maybeChangedFields & 0x800) != 0) {
            this.graphicsLayer.setCameraDistance(scope2.getCameraDistance());
        }
        if ((maybeChangedFields & 0x1000) != 0) {
            if (TransformOrigin.equals-impl0(this.transformOrigin, TransformOrigin.Companion.getCenter-SzJe1aQ())) {
                this.graphicsLayer.setPivotOffset-k-4lQ0M(Offset.Companion.getUnspecified-F1C5BW0());
            } else {
                this.graphicsLayer.setPivotOffset-k-4lQ0M(OffsetKt.Offset((float)(TransformOrigin.getPivotFractionX-impl(this.transformOrigin) * (float)IntSize.getWidth-impl((long)this.size)), (float)(TransformOrigin.getPivotFractionY-impl(this.transformOrigin) * (float)IntSize.getHeight-impl((long)this.size))));
            }
        }
        if ((maybeChangedFields & 0x4000) != 0) {
            this.graphicsLayer.setClip(scope2.getClip());
        }
        if ((maybeChangedFields & 0x20000) != 0) {
            this.graphicsLayer.setRenderEffect(scope2.getRenderEffect());
        }
        if ((maybeChangedFields & 0x8000) != 0) {
            int n2;
            n = scope2.getCompositingStrategy--NrFUSI();
            if (CompositingStrategy.equals-impl0(n, CompositingStrategy.Companion.getAuto--NrFUSI())) {
                n2 = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getAuto-ke2Ky5w();
            } else if (CompositingStrategy.equals-impl0(n, CompositingStrategy.Companion.getOffscreen--NrFUSI())) {
                n2 = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getOffscreen-ke2Ky5w();
            } else if (CompositingStrategy.equals-impl0(n, CompositingStrategy.Companion.getModulateAlpha--NrFUSI())) {
                n2 = androidx.compose.ui.graphics.layer.CompositingStrategy.Companion.getModulateAlpha-ke2Ky5w();
            } else {
                throw new IllegalStateException("Not supported composition strategy");
            }
            this.graphicsLayer.setCompositingStrategy-Wpw9cng(n2);
        }
        if ((maybeChangedFields & 0x1F1B) != 0) {
            this.isMatrixDirty = true;
            this.isInverseMatrixDirty = true;
        }
        boolean outlineChanged = false;
        if (!Intrinsics.areEqual((Object)this.outline, (Object)scope2.getOutline$ui())) {
            outlineChanged = true;
            this.outline = scope2.getOutline$ui();
            GraphicsLayerOwnerLayer graphicsLayerOwnerLayer = this;
            Outline outline = graphicsLayerOwnerLayer.outline;
            if (outline != null) {
                Outline outline2 = outline;
                graphicsLayerOwnerLayer = graphicsLayerOwnerLayer.graphicsLayer;
                Intrinsics.checkNotNullParameter((Object)graphicsLayerOwnerLayer, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)outline2, (String)"outline");
                Outline outline3 = outline2;
                if (outline3 instanceof Outline.Rectangle) {
                    graphicsLayerOwnerLayer.setRectOutline-tz77jQw(OffsetKt.Offset((float)((Outline.Rectangle)outline2).getRect().getLeft(), (float)((Outline.Rectangle)outline2).getRect().getTop()), SizeKt.Size((float)((Outline.Rectangle)outline2).getRect().getWidth(), (float)((Outline.Rectangle)outline2).getRect().getHeight()));
                } else if (outline3 instanceof Outline.Generic) {
                    graphicsLayerOwnerLayer.setPathOutline(((Outline.Generic)outline2).getPath());
                } else if (outline3 instanceof Outline.Rounded) {
                    if (((Outline.Rounded)outline2).getRoundRectPath$ui_graphics() != null) {
                        graphicsLayerOwnerLayer.setPathOutline(((Outline.Rounded)outline2).getRoundRectPath$ui_graphics());
                    } else {
                        outline2 = ((Outline.Rounded)outline2).getRoundRect();
                        graphicsLayerOwnerLayer.setRoundRectOutline-TNW_H78(OffsetKt.Offset((float)outline2.getLeft(), (float)outline2.getTop()), SizeKt.Size((float)outline2.getWidth(), (float)outline2.getHeight()), CornerRadius.getX-impl((long)outline2.getBottomLeftCornerRadius-kKHJgLs()));
                    }
                }
            }
        }
        this.mutatedFields = var1_1.getMutatedFields$ui();
        if (var2_2 != false || n != 0) {
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isInLayer-k-4lQ0M(long position) {
        float x = Offset.getX-impl((long)position);
        float y = Offset.getY-impl((long)position);
        if (this.graphicsLayer.getClip()) {
            void var1_2;
            void var3_3;
            return ShapeContainingUtilKt.isInOutline$default$6c801e6b(this.graphicsLayer.getOutline(), (float)var3_3, (float)var1_2, null, null, 24);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void move--gyyYBs(long position) {
        void var1_1;
        this.graphicsLayer.setTopLeft--gyyYBs((long)var1_1);
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void resize-ozmzZPI(long size) {
        if (!IntSize.equals-impl0((long)size, (long)this.size)) {
            void var1_1;
            this.size = var1_1;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void drawLayer(Canvas canvas, GraphicsLayer parentLayer) {
        void var2_2;
        void var1_1;
        GraphicsLayerOwnerLayer graphicsLayerOwnerLayer;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        GraphicsLayerOwnerLayer graphicsLayerOwnerLayer2 = this;
        if (graphicsLayerOwnerLayer2.isDirty) {
            if (!TransformOrigin.equals-impl0(graphicsLayerOwnerLayer2.transformOrigin, TransformOrigin.Companion.getCenter-SzJe1aQ()) && !IntSize.equals-impl0((long)graphicsLayerOwnerLayer2.graphicsLayer.getSize-YbymL2g(), (long)graphicsLayerOwnerLayer2.size)) {
                graphicsLayerOwnerLayer2.graphicsLayer.setPivotOffset-k-4lQ0M(OffsetKt.Offset((float)(TransformOrigin.getPivotFractionX-impl(graphicsLayerOwnerLayer2.transformOrigin) * (float)IntSize.getWidth-impl((long)graphicsLayerOwnerLayer2.size)), (float)(TransformOrigin.getPivotFractionY-impl(graphicsLayerOwnerLayer2.transformOrigin) * (float)IntSize.getHeight-impl((long)graphicsLayerOwnerLayer2.size))));
            }
            graphicsLayerOwnerLayer2.graphicsLayer.record-mL-hObY(graphicsLayerOwnerLayer2.density, graphicsLayerOwnerLayer2.layoutDirection, graphicsLayerOwnerLayer2.size, graphicsLayerOwnerLayer2.recordLambda);
            graphicsLayerOwnerLayer2.isDirty = false;
        }
        this.drawnWithEnabledZ = graphicsLayerOwnerLayer.graphicsLayer.getShadowElevation() > 0.0f;
        graphicsLayerOwnerLayer2 = this.scope.getDrawContext();
        DrawContext it = graphicsLayerOwnerLayer2;
        graphicsLayerOwnerLayer2.setCanvas((Canvas)var1_1);
        graphicsLayerOwnerLayer2.setGraphicsLayer((GraphicsLayer)var2_2);
        GraphicsLayerKt.drawLayer((DrawScope)((DrawScope)this.scope), (GraphicsLayer)this.graphicsLayer);
    }

    @Override
    public final void invalidate() {
        if (!this.isDirty && !this.isDestroyed) {
            Function0<Unit> function0 = this.invalidateParentLayer;
            if (function0 != null) {
                function0.invoke();
            }
            this.isDirty = true;
        }
    }

    @Override
    public final void destroy() {
        this.drawBlock = null;
        this.invalidateParentLayer = null;
        this.isDestroyed = true;
        this.isDirty = false;
        GraphicsContext graphicsContext = this.context;
        if (graphicsContext != null) {
            graphicsContext.releaseGraphicsLayer(this.graphicsLayer);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long mapOffset-8S9VItk(long point, boolean inverse) {
        void var1_1;
        void var3_3;
        float[] fArray;
        if (inverse) {
            fArray = this.getInverseMatrix-3i98HWw();
            if (fArray == null) {
                return Offset.Companion.getInfinite-F1C5BW0();
            }
        } else {
            float[] matrix;
            fArray = matrix = this.getMatrix-sQKQjiQ();
        }
        if (this.isIdentity) {
            return point;
        }
        return Matrix.map-MK-Hz9U((float[])var3_3, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mapBounds(MutableRect rect, boolean inverse) {
        float[] matrix;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        float[] fArray = matrix = inverse ? this.getInverseMatrix-3i98HWw() : this.getMatrix-sQKQjiQ();
        if (!this.isIdentity) {
            void var1_1;
            void var2_3;
            if (matrix == null) {
                rect.set(0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            Matrix.map-impl((float[])var2_3, (MutableRect)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void transform-58bKbWc(float[] matrix) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Matrix.timesAssign-58bKbWc((float[])var1_1, (float[])this.getMatrix-sQKQjiQ());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void inverseTransform-58bKbWc(float[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] inverse = this.getInverseMatrix-3i98HWw();
        if (inverse != null) {
            void var2_2;
            void var1_1;
            Matrix.timesAssign-58bKbWc((float[])var1_1, (float[])var2_2);
        }
    }

    private final float[] getMatrix-sQKQjiQ() {
        this.updateMatrix();
        return this.matrixCache;
    }

    /*
     * WARNING - void declaration
     */
    private final float[] getInverseMatrix-3i98HWw() {
        void var2_2;
        float[] inverseMatrix;
        float[] fArray = this.inverseMatrixCache;
        if (this.inverseMatrixCache == null) {
            float[] fArray2;
            float[] it = fArray2 = Matrix.constructor-impl$default$343e1048(null, (int)1);
            this.inverseMatrixCache = it;
            fArray = inverseMatrix = inverseMatrix;
        }
        if (!this.isInverseMatrixDirty) {
            if (Float.isNaN(inverseMatrix[0])) {
                return null;
            }
            return inverseMatrix;
        }
        this.isInverseMatrixDirty = false;
        float[] matrix = this.getMatrix-sQKQjiQ();
        if (this.isIdentity) {
            return matrix;
        }
        if (InvertMatrixKt.invertTo-JiSxe2E((float[])var2_2, inverseMatrix)) {
            return inverseMatrix;
        }
        fArray2[0] = Float.NaN;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMatrix() {
        void var1_1;
        void var3_3;
        void var2_2;
        float pivotY;
        float pivotX;
        GraphicsLayer $this$updateMatrix_u24lambda_u244 = this.graphicsLayer;
        if (OffsetKt.isUnspecified-k-4lQ0M((long)$this$updateMatrix_u24lambda_u244.getPivotOffset-F1C5BW0())) {
            pivotX = (float)IntSize.getWidth-impl((long)$this$updateMatrix_u24lambda_u244.getSize-YbymL2g()) / 2.0f;
            pivotY = (float)IntSize.getHeight-impl((long)$this$updateMatrix_u24lambda_u244.getSize-YbymL2g()) / 2.0f;
        } else {
            pivotX = Offset.getX-impl((long)$this$updateMatrix_u24lambda_u244.getPivotOffset-F1C5BW0());
            pivotY = Offset.getY-impl((long)$this$updateMatrix_u24lambda_u244.getPivotOffset-F1C5BW0());
        }
        Matrices_skikoKt.prepareTransformationMatrix-ao2toNE((float[])this.matrixCache, (float)var2_2, (float)var3_3, (float)$this$updateMatrix_u24lambda_u244.getTranslationX(), (float)$this$updateMatrix_u24lambda_u244.getTranslationY(), (float)$this$updateMatrix_u24lambda_u244.getRotationX(), (float)$this$updateMatrix_u24lambda_u244.getRotationY(), (float)$this$updateMatrix_u24lambda_u244.getRotationZ(), (float)$this$updateMatrix_u24lambda_u244.getScaleX(), (float)$this$updateMatrix_u24lambda_u244.getScaleY(), (float)var1_1.getCameraDistance());
    }

    public static final /* synthetic */ Function2 access$getDrawBlock$p(GraphicsLayerOwnerLayer $this) {
        return $this.drawBlock;
    }
}

