/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Crypt32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinCrypt;
import java.util.Arrays;

public abstract class Crypt32Util {
    public static byte[] cryptProtectData(byte[] data) {
        return Crypt32Util.cryptProtectData(data, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] cryptProtectData(byte[] data, int flags) {
        void var1_1;
        return Crypt32Util.cryptProtectData(data, null, (int)var1_1, "", null);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] cryptProtectData(byte[] data, byte[] entropy, int flags, String description, WinCrypt.CRYPTPROTECT_PROMPTSTRUCT prompt) {
        byte[] protectedData;
        Win32Exception err;
        block17: {
            WinCrypt.DATA_BLOB pEntropy;
            WinCrypt.DATA_BLOB pDataProtected;
            block16: {
                Object pDataIn = (Object)new WinCrypt.DATA_BLOB(data);
                pDataProtected = new WinCrypt.DATA_BLOB();
                pEntropy = entropy == null ? null : new WinCrypt.DATA_BLOB(entropy);
                err = null;
                protectedData = null;
                try {
                    void var2_4;
                    void var3_6;
                    if (!Crypt32.INSTANCE.CryptProtectData((WinCrypt.DATA_BLOB)((Object)pDataIn), (String)var3_6, pEntropy, null, prompt, (int)var2_4, pDataProtected)) {
                        err = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    } else {
                        protectedData = pDataProtected.getData();
                    }
                    if (pDataIn.pbData == null) break block16;
                }
                catch (Throwable throwable) {
                    block18: {
                        Object e;
                        if (e.pbData != null) {
                            e.pbData.clear((long)e.cbData);
                        }
                        if (pEntropy != null && pEntropy.pbData != null) {
                            void var1_3;
                            pEntropy.pbData.clear((long)var1_3.cbData);
                        }
                        if (pDataProtected.pbData != null) {
                            pDataProtected.pbData.clear((long)pDataProtected.cbData);
                            try {
                                Kernel32Util.freeLocalMemory(pDataProtected.pbData);
                            }
                            catch (Win32Exception e2) {
                                void var0_2;
                                if (err == null) break block18;
                                err.addSuppressedReflected((Throwable)var0_2);
                            }
                        }
                    }
                    throw throwable;
                }
                pDataIn.pbData.clear((long)pDataIn.cbData);
            }
            if (pEntropy != null && pEntropy.pbData != null) {
                pEntropy.pbData.clear((long)pEntropy.cbData);
            }
            if (pDataProtected.pbData != null) {
                pDataProtected.pbData.clear((long)pDataProtected.cbData);
                try {
                    Kernel32Util.freeLocalMemory(pDataProtected.pbData);
                }
                catch (Win32Exception e) {
                    if (err == null) {
                        err = e;
                        break block17;
                    }
                    err.addSuppressedReflected((Throwable)((Object)e));
                }
            }
        }
        if (err != null) {
            if (protectedData != null) {
                Arrays.fill(protectedData, (byte)0);
            }
            throw err;
        }
        return protectedData;
    }

    public static byte[] cryptUnprotectData(byte[] data) {
        return Crypt32Util.cryptUnprotectData(data, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] cryptUnprotectData(byte[] data, int flags) {
        void var1_1;
        return Crypt32Util.cryptUnprotectData(data, null, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] cryptUnprotectData(byte[] data, byte[] entropy, int flags, WinCrypt.CRYPTPROTECT_PROMPTSTRUCT prompt) {
        byte[] unProtectedData;
        Win32Exception err;
        block17: {
            WinCrypt.DATA_BLOB pEntropy;
            WinCrypt.DATA_BLOB pDataUnprotected;
            block16: {
                Object pDataIn = (Object)new WinCrypt.DATA_BLOB(data);
                pDataUnprotected = new WinCrypt.DATA_BLOB();
                pEntropy = entropy == null ? null : new WinCrypt.DATA_BLOB(entropy);
                err = null;
                unProtectedData = null;
                try {
                    void var2_4;
                    void var3_6;
                    if (!Crypt32.INSTANCE.CryptUnprotectData((WinCrypt.DATA_BLOB)((Object)pDataIn), null, pEntropy, null, (WinCrypt.CRYPTPROTECT_PROMPTSTRUCT)var3_6, (int)var2_4, pDataUnprotected)) {
                        err = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    } else {
                        unProtectedData = pDataUnprotected.getData();
                    }
                    if (pDataIn.pbData == null) break block16;
                }
                catch (Throwable throwable) {
                    block18: {
                        Object e;
                        if (e.pbData != null) {
                            e.pbData.clear((long)e.cbData);
                        }
                        if (pEntropy != null && pEntropy.pbData != null) {
                            void var1_3;
                            pEntropy.pbData.clear((long)var1_3.cbData);
                        }
                        if (pDataUnprotected.pbData != null) {
                            pDataUnprotected.pbData.clear((long)pDataUnprotected.cbData);
                            try {
                                Kernel32Util.freeLocalMemory(pDataUnprotected.pbData);
                            }
                            catch (Win32Exception e2) {
                                void var0_2;
                                if (err == null) break block18;
                                err.addSuppressedReflected((Throwable)var0_2);
                            }
                        }
                    }
                    throw throwable;
                }
                pDataIn.pbData.clear((long)pDataIn.cbData);
            }
            if (pEntropy != null && pEntropy.pbData != null) {
                pEntropy.pbData.clear((long)pEntropy.cbData);
            }
            if (pDataUnprotected.pbData != null) {
                pDataUnprotected.pbData.clear((long)pDataUnprotected.cbData);
                try {
                    Kernel32Util.freeLocalMemory(pDataUnprotected.pbData);
                }
                catch (Win32Exception e) {
                    if (err == null) {
                        err = e;
                        break block17;
                    }
                    err.addSuppressedReflected((Throwable)((Object)e));
                }
            }
        }
        if (err != null) {
            if (unProtectedData != null) {
                Arrays.fill(unProtectedData, (byte)0);
            }
            throw err;
        }
        return unProtectedData;
    }

    /*
     * WARNING - void declaration
     */
    public static String CertNameToStr(int dwCertEncodingType, int dwStrType, WinCrypt.DATA_BLOB pName) {
        void var3_4;
        int n;
        void var1_1;
        void var2_2;
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        int requiredSize = Crypt32.INSTANCE.CertNameToStr(dwCertEncodingType, pName, dwStrType, Pointer.NULL, 0);
        Memory mem = new Memory((long)(requiredSize * charToBytes));
        int resultBytes = Crypt32.INSTANCE.CertNameToStr(dwCertEncodingType, (WinCrypt.DATA_BLOB)var2_2, (int)var1_1, (Pointer)mem, requiredSize);
        assert (n == requiredSize);
        if (Boolean.getBoolean("w32.ascii")) {
            return mem.getString(0L);
        }
        return var3_4.getWideString(0L);
    }
}

