/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.bsd;

import com.sun.jna.Native;
import com.sun.jna.platform.bsd.ExtAttr;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExtAttrUtil {
    /*
     * WARNING - void declaration
     */
    public static List<String> list(String path) throws IOException {
        void var3_2;
        void var1_1;
        String string;
        long bufferLength = ExtAttr.INSTANCE.extattr_list_file(path, 1, null, new LibCAPI.size_t(0L)).longValue();
        if (bufferLength < 0L) {
            throw new IOException("errno: " + Native.getLastError());
        }
        if (bufferLength == 0L) {
            return Collections.emptyList();
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)bufferLength);
        long l = ExtAttr.INSTANCE.extattr_list_file(string, 1, buffer, new LibCAPI.size_t((long)var1_1)).longValue();
        if (l < 0L) {
            throw new IOException("errno: " + Native.getLastError());
        }
        return ExtAttrUtil.decodeStringList((ByteBuffer)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer get(String path, String name) throws IOException {
        void var2_2;
        void var1_1;
        String string;
        long bufferLength = ExtAttr.INSTANCE.extattr_get_file(path, 1, name, null, new LibCAPI.size_t(0L)).longValue();
        if (bufferLength < 0L) {
            throw new IOException("errno: " + Native.getLastError());
        }
        if (bufferLength == 0L) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)bufferLength);
        long l = ExtAttr.INSTANCE.extattr_get_file(string, 1, (String)var1_1, buffer, new LibCAPI.size_t((long)var2_2)).longValue();
        if (l < 0L) {
            throw new IOException("errno: " + Native.getLastError());
        }
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public static void set(String path, String name, ByteBuffer value) throws IOException {
        void var2_2;
        void var1_1;
        String string;
        long l = ExtAttr.INSTANCE.extattr_set_file(string, 1, (String)var1_1, value, new LibCAPI.size_t(var2_2.remaining())).longValue();
        if (l < 0L) {
            throw new IOException("errno: " + Native.getLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void delete(String path, String name) throws IOException {
        void var1_2;
        String string;
        int n = ExtAttr.INSTANCE.extattr_delete_file(string, 1, (String)var1_2);
        if (n < 0) {
            throw new IOException("errno: " + Native.getLastError());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> decodeStringList(ByteBuffer buffer) {
        void var1_2;
        ArrayList<String> list = new ArrayList<String>();
        while (buffer.hasRemaining()) {
            int n = buffer.get() & 0xFF;
            byte[] value = new byte[n];
            buffer.get(value);
            try {
                void var2_3;
                list.add(new String((byte[])var2_3, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                void var0_1;
                throw new RuntimeException((Throwable)var0_1);
            }
        }
        return var1_2;
    }
}

