/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.win32.W32FileMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FileMonitor {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_ACCESSED = 8;
    public static final int FILE_NAME_CHANGED_OLD = 16;
    public static final int FILE_NAME_CHANGED_NEW = 32;
    public static final int FILE_RENAMED = 48;
    public static final int FILE_SIZE_CHANGED = 64;
    public static final int FILE_ATTRIBUTES_CHANGED = 128;
    public static final int FILE_SECURITY_CHANGED = 256;
    public static final int FILE_ANY = 511;
    private final Map<File, Integer> watched = new HashMap<File, Integer>();
    private List<FileListener> listeners = new ArrayList<FileListener>();

    protected abstract void watch(File var1, int var2, boolean var3) throws IOException;

    protected abstract void unwatch(File var1);

    public abstract void dispose();

    /*
     * WARNING - void declaration
     */
    public void addWatch(File dir) throws IOException {
        void var1_1;
        this.addWatch((File)var1_1, 511);
    }

    /*
     * WARNING - void declaration
     */
    public void addWatch(File dir, int mask) throws IOException {
        void var1_1;
        void var2_2;
        this.addWatch(dir, (int)var2_2, var1_1.isDirectory());
    }

    /*
     * WARNING - void declaration
     */
    public void addWatch(File dir, int mask, boolean recursive) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.watched.put(dir, mask);
        this.watch((File)var1_1, (int)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void removeWatch(File file) {
        if (this.watched.remove(file) != null) {
            void var1_1;
            this.unwatch((File)var1_1);
        }
    }

    protected void notify(FileEvent e) {
        for (FileListener fileListener : this.listeners) {
            fileListener.fileChanged(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addFileListener(FileListener listener) {
        void var2_2;
        void var1_1;
        ArrayList<FileListener> list = new ArrayList<FileListener>(this.listeners);
        list.add((FileListener)var1_1);
        this.listeners = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeFileListener(FileListener x) {
        void var2_2;
        void var1_1;
        ArrayList<FileListener> list = new ArrayList<FileListener>(this.listeners);
        list.remove(var1_1);
        this.listeners = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void finalize() {
        for (File watchedFile : this.watched.keySet()) {
            void var2_2;
            this.removeWatch((File)var2_2);
        }
        this.dispose();
    }

    public static FileMonitor getInstance() {
        return Holder.INSTANCE;
    }

    public static interface FileListener {
        public void fileChanged(FileEvent var1);
    }

    public class FileEvent
    extends EventObject {
        private final File file;
        private final int type;

        /*
         * WARNING - void declaration
         */
        public FileEvent(File file, int type) {
            void var3_3;
            void var2_2;
            void var1_1;
            super(var1_1);
            this.file = var2_2;
            this.type = var3_3;
        }

        public File getFile() {
            return this.file;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "FileEvent: " + this.file + ":" + this.type;
        }
    }

    private static class Holder {
        public static final FileMonitor INSTANCE;

        private Holder() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                INSTANCE = new W32FileMonitor();
                return;
            }
            throw new Error("FileMonitor not implemented for " + (String)var0);
        }
    }
}

