/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGB;
import kotlin.Metadata;

public interface RGBColorSpace
extends WhitePointColorSpace<RGB> {
    public RGB invoke(float var1, float var2, float var3, float var4);

    public TransferFunctions getTransferFunctions();

    public float[] getMatrixToXyz();

    public float[] getMatrixFromXyz();

    public static final class GammaTransferFunctions
    implements TransferFunctions {
        private final double gamma;

        /*
         * WARNING - void declaration
         */
        public GammaTransferFunctions(double gamma) {
            void var1_1;
            this.gamma = var1_1;
        }

        @Override
        public final float eotf(float x) {
            double d = this.gamma;
            float f = x;
            return (float)InternalMathKt.spow(f, d);
        }

        @Override
        public final float oetf(float x) {
            double d = 1.0 / this.gamma;
            float f = x;
            return (float)InternalMathKt.spow(f, d);
        }

        public final String toString() {
            return "GammaTransferFunctions(gamma=" + this.gamma + ')';
        }

        public final int hashCode() {
            return Double.hashCode(this.gamma);
        }

        public final boolean equals(Object other) {
            GammaTransferFunctions gammaTransferFunctions;
            if (this == other) {
                return true;
            }
            if (!(other instanceof GammaTransferFunctions)) {
                return false;
            }
            gammaTransferFunctions = gammaTransferFunctions;
            return Double.compare(this.gamma, gammaTransferFunctions.gamma) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0007"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace$LinearTransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "<init>", "()V", "", "x", "eotf", "(F)F", "oetf"})
    public static final class LinearTransferFunctions
    implements TransferFunctions {
        public static final LinearTransferFunctions INSTANCE = new LinearTransferFunctions();

        private LinearTransferFunctions() {
        }

        @Override
        public final float eotf(float x) {
            return x;
        }

        @Override
        public final float oetf(float x) {
            return x;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0006\u0010\u0005"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "", "", "x", "eotf", "(F)F", "oetf"})
    public static interface TransferFunctions {
        public float eotf(float var1);

        public float oetf(float var1);
    }
}

