/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB1\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001dR\u0014\u0010\b\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001e"}, d2={"Lcom/github/ajalt/colormath/model/RGB;", "Lcom/github/ajalt/colormath/Color;", "", "r", "g", "b", "alpha", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "space", "<init>", "(FFFFLcom/github/ajalt/colormath/model/RGBColorSpace;)V", "convertTo", "(Lcom/github/ajalt/colormath/model/RGBColorSpace;)Lcom/github/ajalt/colormath/model/RGB;", "Lcom/github/ajalt/colormath/model/XYZ;", "toXYZ", "()Lcom/github/ajalt/colormath/model/XYZ;", "toSRGB", "()Lcom/github/ajalt/colormath/model/RGB;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "Companion"})
@SourceDebugExtension(value={"SMAP\nRGB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGB.kt\ncom/github/ajalt/colormath/model/RGB\n+ 2 Matrix.kt\ncom/github/ajalt/colormath/internal/MatrixKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,381:1\n360#1:382\n341#1:383\n360#1:384\n342#1,16:385\n341#1:401\n360#1:402\n342#1,16:403\n360#1:423\n341#1:424\n360#1:425\n342#1,16:426\n360#1:442\n360#1:443\n360#1:456\n70#2,4:419\n89#3,12:444\n*S KotlinDebug\n*F\n+ 1 RGB.kt\ncom/github/ajalt/colormath/model/RGB\n*L\n181#1:382\n225#1:383\n225#1:384\n225#1:385,16\n237#1:401\n237#1:402\n237#1:403,16\n253#1:423\n264#1:424\n264#1:425\n264#1:426,16\n301#1:442\n310#1:443\n341#1:456\n248#1:419,4\n331#1:444,12\n*E\n"})
public final class RGB
implements Color {
    public static final Companion Companion = new Companion(0);
    public final float r;
    public final float g;
    public final float b;
    public final float alpha;
    public final RGBColorSpace space;

    /*
     * WARNING - void declaration
     */
    public RGB(float r, float g, float b, float alpha, RGBColorSpace space) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        this.r = var1_1;
        this.g = var2_2;
        this.b = var3_3;
        this.alpha = alpha;
        this.space = space;
    }

    /*
     * WARNING - void declaration
     */
    public final RGB convertTo(RGBColorSpace space) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        RGBColorSpace.TransferFunctions f = SRGB.INSTANCE.getTransferFunctions();
        RGB rGB = this;
        if (Intrinsics.areEqual((Object)rGB.space, (Object)space)) {
            return this;
        }
        rGB = this;
        if (Intrinsics.areEqual((Object)rGB.space, (Object)SRGB.INSTANCE)) {
            if (Intrinsics.areEqual((Object)space, (Object)RGBColorSpaces.INSTANCE.getLinearSRGB())) {
                rGB = this;
                return space.invoke(f.eotf(this.r), f.eotf(this.g), f.eotf(this.b), rGB.alpha);
            }
        }
        rGB = this;
        if (Intrinsics.areEqual((Object)rGB.space, (Object)RGBColorSpaces.INSTANCE.getLinearSRGB()) && Intrinsics.areEqual((Object)space, (Object)SRGB.INSTANCE)) {
            void var2_2;
            rGB = this;
            return space.invoke(f.oetf(this.r), f.oetf(this.g), var2_2.oetf(this.b), rGB.alpha);
        }
        return this.toXYZ().toRGB((RGBColorSpace)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final XYZ toXYZ() {
        void var1_3;
        void var2_5;
        void v1$iv;
        void v0$iv;
        void $this$dot_u2dlwRpc58$iv;
        Object object = this;
        RGBColorSpace.TransferFunctions f = ((RGB)object).space.getTransferFunctions();
        object = this;
        float[] fArray = ((RGB)object).space.getMatrixToXyz();
        object = fArray;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"rowMajor");
        Object object2 = object;
        float f2 = f.eotf(this.r);
        float f3 = f.eotf(this.g);
        float v2$iv = f.eotf(this.b);
        int n = 0;
        int n2 = 0;
        object = $this$dot_u2dlwRpc58$iv;
        void v1 = object[n * 3 + n2] * v0$iv;
        n = 0;
        n2 = 1;
        object = $this$dot_u2dlwRpc58$iv;
        void v2 = v1 + object[n * 3 + n2] * v1$iv;
        n = 0;
        n2 = 2;
        object = $this$dot_u2dlwRpc58$iv;
        void v3 = v2 + object[n * 3 + n2] * v2$iv;
        n = 1;
        n2 = 0;
        object = $this$dot_u2dlwRpc58$iv;
        void v4 = object[n * 3 + n2] * v0$iv;
        n = 1;
        n2 = 1;
        object = $this$dot_u2dlwRpc58$iv;
        void v5 = v4 + object[n * 3 + n2] * v1$iv;
        n = 1;
        n2 = 2;
        object = $this$dot_u2dlwRpc58$iv;
        void v6 = v5 + object[n * 3 + n2] * v2$iv;
        n = 2;
        n2 = 0;
        object = $this$dot_u2dlwRpc58$iv;
        void v7 = object[n * 3 + n2] * v0$iv;
        n = 2;
        n2 = 1;
        object = $this$dot_u2dlwRpc58$iv;
        void v8 = v7 + object[n * 3 + n2] * v1$iv;
        n = 2;
        n2 = 2;
        object = $this$dot_u2dlwRpc58$iv;
        v2$iv = v8 + object[n * 3 + n2] * v2$iv;
        void y = v6;
        void x = v3;
        RGB rGB = this;
        object = rGB;
        object = this;
        return XYZKt.XYZColorSpace(rGB.space.getWhitePoint()).invoke(f2, (float)var2_5, (float)var1_3, ((RGB)object).alpha);
    }

    @Override
    public final RGB toSRGB() {
        return this.convertTo(RGBColorSpaces.INSTANCE.getSRGB());
    }

    public final String toString() {
        return "RGB(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public final int hashCode() {
        int n = Float.hashCode(this.r);
        n = n * 31 + Float.hashCode(this.g);
        n = n * 31 + Float.hashCode(this.b);
        n = n * 31 + Float.hashCode(this.alpha);
        n = n * 31 + this.space.hashCode();
        return n;
    }

    public final boolean equals(Object other) {
        RGB rGB;
        if (this == other) {
            return true;
        }
        if (!(other instanceof RGB)) {
            return false;
        }
        rGB = rGB;
        if (Float.compare(this.r, rGB.r) != 0) {
            return false;
        }
        if (Float.compare(this.g, rGB.g) != 0) {
            return false;
        }
        if (Float.compare(this.b, rGB.b) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, rGB.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.space, (Object)rGB.space);
    }

    public static final class Companion
    implements RGBColorSpace {
        private final /* synthetic */ RGBColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = RGBColorSpaces.INSTANCE.getSRGB();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final RGB invoke(float r, float g, float b, float alpha) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.$$delegate_0.invoke((float)var1_1, (float)var2_2, (float)var3_3, alpha);
        }

        @Override
        public final RGBColorSpace.TransferFunctions getTransferFunctions() {
            return this.$$delegate_0.getTransferFunctions();
        }

        @Override
        public final float[] getMatrixToXyz() {
            return this.$$delegate_0.getMatrixToXyz();
        }

        @Override
        public final float[] getMatrixFromXyz() {
            return this.$$delegate_0.getMatrixFromXyz();
        }

        @Override
        public final WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        public final String getName() {
            return this.$$delegate_0.getName();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return Intrinsics.areEqual((Object)RGBColorSpaces.INSTANCE.getSRGB(), (Object)var1_1);
        }

        public final int hashCode() {
            return RGBColorSpaces.INSTANCE.getSRGB().hashCode();
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

