/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.descriptors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.internal.CachedNames;
import kotlinx.serialization.internal.Platform_commonKt;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptorKt;

@SourceDebugExtension(value={"SMAP\nSerialDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerialDescriptors.kt\nkotlinx/serialization/descriptors/SerialDescriptorImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Platform.kt\nkotlinx/serialization/internal/PlatformKt\n+ 5 PluginGeneratedSerialDescriptor.kt\nkotlinx/serialization/internal/PluginGeneratedSerialDescriptorKt\n*L\n1#1,366:1\n37#2,2:367\n37#2,2:369\n1557#3:371\n1628#3,3:372\n16#4:375\n16#4:376\n16#4:377\n21#4:378\n111#5,10:379\n*S KotlinDebug\n*F\n+ 1 SerialDescriptors.kt\nkotlinx/serialization/descriptors/SerialDescriptorImpl\n*L\n336#1:367,2\n338#1:369,2\n340#1:371\n340#1:372,3\n344#1:375\n346#1:376\n347#1:377\n348#1:378\n351#1:379,10\n*E\n"})
public final class SerialDescriptorImpl
implements SerialDescriptor,
CachedNames {
    private final String serialName;
    private final SerialKind kind;
    private final int elementsCount;
    private final List<Annotation> annotations;
    private final Set<String> serialNames;
    private final String[] elementNames;
    private final SerialDescriptor[] elementDescriptors;
    private final List<Annotation>[] elementAnnotations;
    private final boolean[] elementOptionality;
    private final Map<String, Integer> name2Index;
    private final SerialDescriptor[] typeParametersDescriptors;
    private final Lazy _hashCode$delegate;

    /*
     * WARNING - void declaration
     */
    public SerialDescriptorImpl(String serialName, SerialKind kind, int elementsCount, List<? extends SerialDescriptor> typeParameters, ClassSerialDescriptorBuilder builder) {
        void var1_1;
        Iterator iterator;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(typeParameters, (String)"typeParameters");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.serialName = serialName;
        this.kind = kind;
        this.elementsCount = elementsCount;
        this.annotations = builder.getAnnotations();
        this.serialNames = CollectionsKt.toHashSet((Iterable)builder.getElementNames$kotlinx_serialization_core());
        kind = serialName = (Collection)builder.getElementNames$kotlinx_serialization_core();
        this.elementNames = serialName.toArray(new String[0]);
        this.elementDescriptors = Platform_commonKt.compactArray(builder.getElementDescriptors$kotlinx_serialization_core());
        kind = serialName = (Collection)builder.getElementAnnotations$kotlinx_serialization_core();
        this.elementAnnotations = serialName.toArray(new List[0]);
        this.elementOptionality = CollectionsKt.toBooleanArray((Collection)builder.getElementOptionality$kotlinx_serialization_core());
        SerialDescriptorImpl serialDescriptorImpl = this;
        serialName = ArraysKt.withIndex((Object[])serialDescriptorImpl.elementNames);
        SerialDescriptorImpl serialDescriptorImpl2 = serialDescriptorImpl;
        kind = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            void it;
            Object item$iv$iv = iterator.next();
            item$iv$iv = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(TuplesKt.to((Object)it.getValue(), (Object)var3_4.getIndex()));
        }
        serialDescriptorImpl2.name2Index = MapsKt.toMap((Iterable)((List)var1_1));
        this.typeParametersDescriptors = Platform_commonKt.compactArray(typeParameters);
        this._hashCode$delegate = LazyKt.lazy(() -> SerialDescriptorImpl._hashCode_delegate$lambda$1(this));
    }

    @Override
    public final String getSerialName() {
        return this.serialName;
    }

    @Override
    public final SerialKind getKind() {
        return this.kind;
    }

    @Override
    public final int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    public final List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public final Set<String> getSerialNames() {
        return this.serialNames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getElementName(int index) {
        void var1_1;
        String[] stringArray = this.elementNames;
        return this.elementNames[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getElementIndex(String name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.name2Index.get(var1_1);
        if (n != null) {
            return n;
        }
        return -3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Annotation> getElementAnnotations(int index) {
        void var1_1;
        List<Annotation>[] listArray = this.elementAnnotations;
        return this.elementAnnotations[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SerialDescriptor getElementDescriptor(int index) {
        void var1_1;
        SerialDescriptor[] serialDescriptorArray = this.elementDescriptors;
        return this.elementDescriptors[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isElementOptional(int index) {
        void var1_1;
        boolean[] blArray = this.elementOptionality;
        return this.elementOptionality[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        SerialDescriptor $this$equalsImpl$iv = this;
        if ($this$equalsImpl$iv != other) {
            void var3_3;
            if (!(other instanceof SerialDescriptorImpl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$equalsImpl$iv.getSerialName(), (Object)((SerialDescriptor)other).getSerialName())) {
                return false;
            }
            SerialDescriptorImpl otherDescriptor = (SerialDescriptorImpl)other;
            if (!Arrays.equals(this.typeParametersDescriptors, var3_3.typeParametersDescriptors)) {
                return false;
            }
            if ($this$equalsImpl$iv.getElementsCount() != ((SerialDescriptor)other).getElementsCount()) {
                return false;
            }
            int n = $this$equalsImpl$iv.getElementsCount();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                if (!Intrinsics.areEqual((Object)$this$equalsImpl$iv.getElementDescriptor(index$iv).getSerialName(), (Object)((SerialDescriptor)other).getElementDescriptor(index$iv).getSerialName())) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)$this$equalsImpl$iv.getElementDescriptor(index$iv).getKind(), (Object)((SerialDescriptor)other).getElementDescriptor(index$iv).getKind())) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        SerialDescriptorImpl serialDescriptorImpl = this;
        serialDescriptorImpl = serialDescriptorImpl._hashCode$delegate;
        return ((Number)serialDescriptorImpl.getValue()).intValue();
    }

    public final String toString() {
        SerialDescriptorImpl serialDescriptorImpl = this;
        SerialDescriptorImpl serialDescriptorImpl2 = serialDescriptorImpl;
        serialDescriptorImpl2 = this;
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)serialDescriptorImpl.elementsCount)), (CharSequence)", ", (CharSequence)(serialDescriptorImpl2.serialName + '('), (CharSequence)")", (int)0, null, arg_0 -> SerialDescriptorImpl.toString$lambda$3(this, arg_0), (int)24, null);
    }

    @Override
    public final boolean isNullable() {
        return false;
    }

    @Override
    public final boolean isInline() {
        return false;
    }

    private static final int _hashCode_delegate$lambda$1(SerialDescriptorImpl this$0) {
        SerialDescriptorImpl serialDescriptorImpl;
        return PluginGeneratedSerialDescriptorKt.hashCodeImpl(this$0, serialDescriptorImpl.typeParametersDescriptors);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence toString$lambda$3(SerialDescriptorImpl this$0, int it) {
        void var1_1;
        SerialDescriptorImpl serialDescriptorImpl;
        return this$0.getElementName(it) + ": " + serialDescriptorImpl.getElementDescriptor((int)var1_1).getSerialName();
    }
}

