/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class PropertyListParser {
    /*
     * WARNING - void declaration
     */
    private static int determineType(InputStream is, int offset) throws IOException {
        void var1_3;
        int type;
        void var2_5;
        void var3_7;
        int b;
        ByteOrderMarkReader bomReader;
        block0: while (true) {
            int index = offset;
            int readLimit = index + 1024;
            if (is.markSupported()) {
                is.mark(readLimit);
            }
            is.skip(offset);
            bomReader = new ByteOrderMarkReader();
            boolean bom = true;
            do {
                if (++index <= readLimit) continue;
                is.reset();
                offset = readLimit;
                continue block0;
            } while ((b = is.read()) != -1 && (b == 32 || b == 9 || b == 13 || b == 10 || b == 12 || (bom &= bomReader.readByte(b))));
            break;
        }
        if (b == -1) {
            return 10;
        }
        String charset = bomReader.getDetectedCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] byArray = new byte[8];
        byte[] magicBytes = byArray;
        byArray[0] = (byte)b;
        int read22 = is.read(magicBytes, 1, 7);
        if (read22 == -1) {
            return 11;
        }
        String read22 = new String((byte[])var3_7, 0, read22, Charset.forName((String)var2_5));
        int n = (read22 = read22.trim()).length() == 0 ? 10 : (read22.startsWith("bplist") ? 1 : (read22.startsWith("(") || read22.startsWith("{") || read22.startsWith("/") ? 2 : (type = read22.startsWith("<") ? 0 : 11)));
        if (is.markSupported()) {
            InputStream inputStream;
            inputStream.reset();
        }
        return (int)var1_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static byte[] readAll(InputStream in) throws IOException {
        void var1_1;
        int read;
        Objects.requireNonNull(in, "The specified input stream is null");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((read = in.read(buf, 0, 4096)) != -1) {
            void var3_3;
            outputStream.write(buf, 0, (int)var3_3);
        }
        return var1_1.toByteArray();
    }

    public static NSObject parse(Path path) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        InputStream inputStream;
        block16: {
            InputStream fileInputStream2 = Files.newInputStream(path, new OpenOption[0]);
            Throwable throwable = null;
            try {
                NSObject nSObject;
                inputStream = fileInputStream2;
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                switch (PropertyListParser.determineType(inputStream, 0)) {
                    case 1: {
                        nSObject = BinaryPropertyListParser.parse(inputStream);
                        break;
                    }
                    case 0: {
                        nSObject = XMLPropertyListParser.parse(inputStream);
                        break;
                    }
                    case 2: {
                        nSObject = ASCIIPropertyListParser.parse(inputStream);
                        break;
                    }
                    case 10: {
                        nSObject = null;
                        break;
                    }
                    default: {
                        throw new PropertyListFormatException("The given data is not a property list of a supported format.");
                    }
                }
                inputStream = nSObject;
                if (fileInputStream2 == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (fileInputStream2 != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream2.close();
                            }
                            catch (Throwable fileInputStream2) {
                                throwable.addSuppressed(fileInputStream2);
                            }
                        } else {
                            InputStream inputStream2;
                            inputStream2.close();
                        }
                    }
                    throw throwable4;
                }
            }
            fileInputStream2.close();
        }
        return inputStream;
    }
}

