/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryLocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import com.dd.plist.ParsedObjectStack;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.dd.plist.UID;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;

public final class BinaryPropertyListParser {
    private int majorVersion;
    private int minorVersion;
    private byte[] bytes;
    private int objectRefSize;
    private int offsetSize;
    private int numObjects;
    private int offsetTableOffset;
    private final HashMap<Integer, NSObject> parsedObjects = new HashMap();

    private BinaryPropertyListParser() {
    }

    public static NSObject parse(InputStream is) throws IOException, PropertyListFormatException {
        Object object = PropertyListParser.readAll(is);
        BinaryPropertyListParser binaryPropertyListParser = new BinaryPropertyListParser();
        Object object2 = binaryPropertyListParser;
        object2 = object;
        object = binaryPropertyListParser;
        Objects.requireNonNull(object2);
        if (((Object)object2).length < 8) {
            throw new PropertyListFormatException("The available binary property list data is too short.");
        }
        ((BinaryPropertyListParser)object).bytes = (byte[])object2;
        object2 = new String(BinaryPropertyListParser.copyOfRange(((BinaryPropertyListParser)object).bytes, 0, 8), StandardCharsets.US_ASCII);
        if (!(((String)object2).startsWith("bplist") && ((String)object2).length() >= 8 && Character.isDigit(((String)object2).charAt(6)) && Character.isDigit(((String)object2).charAt(7)))) {
            throw new PropertyListFormatException("The binary property list has an invalid file header: " + (String)object2);
        }
        ((BinaryPropertyListParser)object).majorVersion = ((String)object2).charAt(6) - 48;
        ((BinaryPropertyListParser)object).minorVersion = ((String)object2).charAt(7) - 48;
        if (((BinaryPropertyListParser)object).majorVersion > 0) {
            throw new PropertyListFormatException("Unsupported binary property list format: v" + ((BinaryPropertyListParser)object).majorVersion + "." + ((BinaryPropertyListParser)object).minorVersion + ". Version 1.0 and later are not yet supported.");
        }
        if (((BinaryPropertyListParser)object).bytes.length < 40) {
            throw new PropertyListFormatException("The binary property list does not contain a complete object offset table.");
        }
        object2 = BinaryPropertyListParser.copyOfRange(((BinaryPropertyListParser)object).bytes, ((BinaryPropertyListParser)object).bytes.length - 32, ((BinaryPropertyListParser)object).bytes.length);
        ((BinaryPropertyListParser)object).offsetSize = (int)BinaryPropertyListParser.parseUnsignedInt((byte[])object2, 6, 7);
        ((BinaryPropertyListParser)object).objectRefSize = (int)BinaryPropertyListParser.parseUnsignedInt((byte[])object2, 7, 8);
        ((BinaryPropertyListParser)object).numObjects = (int)BinaryPropertyListParser.parseUnsignedInt((byte[])object2, 8, 16);
        int n = (int)BinaryPropertyListParser.parseUnsignedInt((byte[])object2, 16, 24);
        ((BinaryPropertyListParser)object).offsetTableOffset = (int)BinaryPropertyListParser.parseUnsignedInt((byte[])object2, 24, 32);
        if (((BinaryPropertyListParser)object).offsetTableOffset + (((BinaryPropertyListParser)object).numObjects + 1) * ((BinaryPropertyListParser)object).offsetSize > ((BinaryPropertyListParser)object).bytes.length || n >= ((BinaryPropertyListParser)object).bytes.length - 32) {
            throw new PropertyListFormatException("The binary property list contains a corrupted object offset table.");
        }
        return super.parseObject(ParsedObjectStack.empty(), n);
    }

    /*
     * WARNING - void declaration
     */
    private static long parseUnsignedInt(byte[] bytes, int startIndex, int endIndex) {
        void i;
        long l = 0L;
        while (i < endIndex) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return (long)(var3_3 &= 0xFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    public static long parseLong(byte[] bytes, int startIndex, int endIndex) {
        void var3_3;
        void i;
        long l = 0L;
        while (i < endIndex) {
            l <<= 8;
            l |= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static double parseDouble(byte[] bytes, int startIndex, int endIndex) {
        void var1_1;
        void var2_2;
        if (endIndex - startIndex == 8) {
            return Double.longBitsToDouble(BinaryPropertyListParser.parseLong(bytes, startIndex, endIndex));
        }
        if (endIndex - startIndex == 4) {
            byte[] byArray;
            return Float.intBitsToFloat((int)BinaryPropertyListParser.parseLong(byArray, startIndex, endIndex));
        }
        throw new IllegalArgumentException("endIndex (" + (int)var2_2 + ") - startIndex (" + (int)var1_1 + ") != 4 or 8");
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] copyOfRange(byte[] src, int startIndex, int endIndex) {
        void var2_3;
        void var3_4;
        void var1_1;
        byte[] byArray;
        int length = endIndex - startIndex;
        if (length < 0) {
            throw new IllegalArgumentException("startIndex (" + startIndex + ") > endIndex (" + endIndex + ")");
        }
        byte[] dest = new byte[length];
        System.arraycopy(byArray, (int)var1_1, dest, 0, (int)var3_4);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private NSObject parseObject(ParsedObjectStack stack22, int obj) throws PropertyListFormatException {
        void var1_1;
        void var2_5;
        Object result;
        int n;
        stack22 = stack22.push(obj);
        if (this.parsedObjects.containsKey(obj)) {
            return this.parsedObjects.get(obj);
        }
        int n2 = obj;
        BinaryPropertyListParser binaryPropertyListParser = this;
        if (n2 >= binaryPropertyListParser.numObjects) {
            throw new PropertyListFormatException("The given binary property list contains an invalid object identifier (" + n2 + ").");
        }
        int n3 = n = binaryPropertyListParser.offsetTableOffset + n2 * binaryPropertyListParser.offsetSize;
        int offset = (int)BinaryPropertyListParser.parseUnsignedInt(binaryPropertyListParser.bytes, n3, n3 + binaryPropertyListParser.offsetSize);
        BinaryLocationInformation loc = new BinaryLocationInformation(obj, offset);
        byte type = this.bytes[offset];
        int objType = (type & 0xF0) >> 4;
        int objInfo42 = type & 0xF;
        try {
            switch (objType) {
                case 0: {
                    NSObject nSObject;
                    int stack22 = obj;
                    n = objInfo42;
                    n2 = offset;
                    BinaryPropertyListParser objInfo42 = this;
                    switch (n) {
                        case 0: {
                            nSObject = null;
                            break;
                        }
                        case 8: {
                            nSObject = new NSNumber(false);
                            break;
                        }
                        case 9: {
                            nSObject = new NSNumber(true);
                            break;
                        }
                        case 12: 
                        case 13: {
                            throw new PropertyListFormatException("The NSObject at offset " + n2 + " is a URL, which is not supported.");
                        }
                        case 14: {
                            nSObject = objInfo42.parseUid(stack22, n2, 16);
                            break;
                        }
                        default: {
                            obj = n2;
                            BinaryPropertyListParser stack22 = objInfo42;
                            throw new PropertyListFormatException(stack22.buildTypeError(obj, "NSObject"));
                        }
                    }
                    result = nSObject;
                    break;
                }
                case 1: {
                    result = this.parseNumber(offset, objInfo42, 0);
                    break;
                }
                case 2: {
                    result = this.parseNumber(offset, objInfo42, 1);
                    break;
                }
                case 3: {
                    n = objInfo42;
                    n2 = offset;
                    BinaryPropertyListParser objInfo42 = this;
                    if (n != 3) {
                        throw new PropertyListFormatException(objInfo42.buildTypeError(n2, "NSDate"));
                    }
                    if (n2 + 9 > objInfo42.bytes.length) {
                        throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n2, "NSDate"));
                    }
                    result = new NSDate(objInfo42.bytes, n2 + 1, n2 + 9);
                    break;
                }
                case 4: {
                    n = objInfo42;
                    n2 = offset;
                    BinaryPropertyListParser objInfo42 = this;
                    int[] nArray = objInfo42.readLengthAndOffset(n, n2);
                    result = nArray;
                    n = nArray[0];
                    int n4 = n2 + result[1];
                    if (n4 + n > objInfo42.bytes.length) {
                        throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n2, "NSData"));
                    }
                    int n5 = n4;
                    result = new NSData(BinaryPropertyListParser.copyOfRange(objInfo42.bytes, n5, n5 + n));
                    break;
                }
                case 5: {
                    result = this.parseString(offset, objInfo42, (o, l) -> l, StandardCharsets.US_ASCII.name());
                    break;
                }
                case 6: {
                    result = this.parseString(offset, objInfo42, (o, l) -> {
                        void var1_1;
                        return 2 * var1_1.intValue();
                    }, StandardCharsets.UTF_16BE.name());
                    break;
                }
                case 7: {
                    result = this.parseString(offset, objInfo42, this::calculateUtf8StringLength, StandardCharsets.UTF_8.name());
                    break;
                }
                case 8: {
                    result = this.parseUid(obj, offset, objInfo42 + 1);
                    break;
                }
                case 10: {
                    n = objInfo42;
                    n2 = offset;
                    BinaryPropertyListParser objInfo42 = this;
                    int[] nArray = objInfo42.readLengthAndOffset(n, n2);
                    int n6 = nArray[0];
                    int n7 = n2 + nArray[1];
                    NSArray nSArray = new NSArray(n6);
                    for (int i = 0; i < n6; ++i) {
                        int n8 = objInfo42.parseObjectReferenceFromList(n7, i);
                        nSArray.setValue$1ef468a(i, objInfo42.parseObject((ParsedObjectStack)result, n8));
                    }
                    result = nSArray;
                    break;
                }
                case 11: {
                    result = this.parseSet(offset, objInfo42, true, (ParsedObjectStack)result);
                    break;
                }
                case 12: {
                    result = this.parseSet(offset, objInfo42, false, (ParsedObjectStack)result);
                    break;
                }
                case 13: {
                    n = objInfo42;
                    n2 = offset;
                    BinaryPropertyListParser binaryPropertyListParser2 = this;
                    int[] nArray = binaryPropertyListParser2.readLengthAndOffset(n, n2);
                    int n9 = nArray[0];
                    int n10 = nArray[1];
                    int n11 = n2 + n10;
                    int n12 = n11 + n9 * binaryPropertyListParser2.objectRefSize;
                    NSDictionary nSDictionary = new NSDictionary();
                    for (n10 = 0; n10 < n9; ++n10) {
                        int n13 = binaryPropertyListParser2.parseObjectReferenceFromList(n11, n10);
                        int n14 = binaryPropertyListParser2.parseObjectReferenceFromList(n12, n10);
                        NSObject nSObject = binaryPropertyListParser2.parseObject((ParsedObjectStack)result, n13);
                        if (nSObject == null) {
                            throw new PropertyListFormatException("The key #" + (n10 + 1) + " of the NSDictionary at offset " + n2 + " is NULL.");
                        }
                        NSObject nSObject2 = binaryPropertyListParser2.parseObject((ParsedObjectStack)result, n14);
                        nSDictionary.put(nSObject.toString(), nSObject2);
                    }
                    result = nSDictionary;
                    break;
                }
                default: {
                    obj = offset;
                    result = this;
                    throw new PropertyListFormatException(((BinaryPropertyListParser)result).buildTypeError(obj, "NSObject"));
                }
            }
        }
        catch (PropertyListFormatException propertyListFormatException) {
            PropertyListFormatException ex = propertyListFormatException;
            if (propertyListFormatException.getLocationInformation() == null) {
                ex.setLocationInformation$176de991(loc);
            }
            throw ex;
        }
        catch (UnsupportedEncodingException ex) {
            void var3_19;
            throw new PropertyListFormatException("The encoding of the NSString at offset " + (int)var3_19 + " is not supported.", loc, ex);
        }
        if (result != null) {
            ((NSObject)result).setLocationInformation(loc);
        }
        this.parsedObjects.put((int)var2_5, (NSObject)result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private UID parseUid(int obj, int offset, int length) throws PropertyListFormatException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (offset + 1 + length >= this.bytes.length) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(offset, "UID"));
        }
        return new UID(String.valueOf((int)var1_1), BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, (int)(var2_2 + true + var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    private NSNumber parseNumber(int offset, int objInfo, int integer) throws PropertyListFormatException {
        int length = (int)Math.pow(2.0, objInfo);
        try {
            void var3_4;
            return new NSNumber(this.bytes, offset + 1, offset + 1 + length, (int)var3_4);
        }
        catch (IndexOutOfBoundsException ex) {
            void var2_3;
            void var1_1;
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError((int)var1_1, "NSNumber"), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private NSString parseString(int offset, int objInfo, BiFunction<Integer, Integer, Integer> stringLengthCalculator, String charsetName) throws PropertyListFormatException, UnsupportedEncodingException {
        void var2_4;
        void var3_5;
        int length;
        int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
        int strOffset = offset + lengthAndOffset[1];
        if (strOffset + (length = ((Integer)var3_5.apply(strOffset, lengthAndOffset[0])).intValue()) > this.bytes.length) {
            void var1_1;
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError((int)var1_1, "NSString"));
        }
        int n = strOffset;
        return new NSString(this.bytes, n, n + var2_4, charsetName);
    }

    /*
     * WARNING - void declaration
     */
    private NSSet parseSet(int offset, int objInfo, boolean ordered, ParsedObjectStack stack) throws PropertyListFormatException, UnsupportedEncodingException {
        void var2_3;
        int[] lengthAndOffset = this.readLengthAndOffset(objInfo, offset);
        int length = lengthAndOffset[0];
        int setOffset = offset + lengthAndOffset[1];
        NSSet set = new NSSet(ordered);
        HashSet<Integer> addedObjectReferences = new HashSet<Integer>();
        for (int i = 0; i < length; ++i) {
            int objRef = this.parseObjectReferenceFromList(setOffset, i);
            if (!addedObjectReferences.add(objRef)) continue;
            set.addObject(this.parseObject(stack, objRef));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private int[] readLengthAndOffset(int objInfo, int offset) throws PropertyListFormatException {
        try {
            int intType;
            int lengthValue = objInfo;
            int offsetValue = 1;
            if (objInfo == 15) {
                void var1_1;
                byte int_type = this.bytes[offset + 1];
                intType = (int_type & 0xF0) >> 4;
                if (intType != 1) {
                    System.err.println("BinaryPropertyListParser: Length integer has an unexpected type (" + intType + "). Attempting to parse anyway...");
                }
                int intInfo = int_type & 0xF;
                int intLength = (int)Math.pow(2.0, intInfo);
                offsetValue = 2 + intLength;
                intType = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, offset + 2, offset + 2 + intLength) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + var1_1)).intValue();
            }
            return new int[]{intType, offsetValue};
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
            void var3_4;
            void var2_2;
            throw new PropertyListFormatException("The length/offset integer at offset " + (int)var2_2 + " is invalid.", (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int calculateUtf8StringLength(int offset, int numCharacters) {
        void var3_3;
        int length = 0;
        for (int i = 0; i < numCharacters; ++i) {
            boolean bl;
            block11: {
                int tempOffset = offset + length;
                if (this.bytes.length <= tempOffset) {
                    return numCharacters;
                }
                byte currentByte = this.bytes[tempOffset];
                if ((currentByte & 0x80) != 128) {
                    ++length;
                    continue;
                }
                int n = 0;
                if ((currentByte & 0xC0) == 128) {
                    return numCharacters;
                }
                if ((currentByte & 0xE0) == 192) {
                    n = 1;
                } else if ((currentByte & 0xF0) == 224) {
                    n = 2;
                } else if ((currentByte & 0xF8) == 240) {
                    n = 3;
                }
                int n2 = n;
                int n3 = tempOffset;
                BinaryPropertyListParser binaryPropertyListParser = this;
                for (int j = 1; j <= n2; ++j) {
                    if (n3 + j < binaryPropertyListParser.bytes.length && (binaryPropertyListParser.bytes[n3 + j] & 0xC0) == 128) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            if (bl) {
                length += 2;
                continue;
            }
            return numCharacters;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int parseObjectReferenceFromList(int baseOffset, int objectIndex) throws PropertyListFormatException {
        void var2_2;
        void var1_1;
        return this.parseObjectReference((int)(var1_1 + var2_2 * this.objectRefSize));
    }

    /*
     * WARNING - void declaration
     */
    private int parseObjectReference(int offset) throws PropertyListFormatException {
        void var1_1;
        if (offset + this.objectRefSize >= this.bytes.length) {
            throw new PropertyListFormatException("Encountered the end of the file while parsing the object reference at offset " + offset + ".");
        }
        void v0 = var1_1;
        return (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, (int)v0, (int)(v0 + this.objectRefSize));
    }

    /*
     * WARNING - void declaration
     */
    private String buildTypeError(int offset, String objectType) {
        void var1_1;
        void var2_2;
        return String.format("The %s at offset %d has an unknown or unsupported type (0x%02x)", var2_2, offset, this.bytes[var1_1]);
    }

    /*
     * WARNING - void declaration
     */
    private static String buildLengthError(int offset, String objectType) {
        int n;
        void var1_1;
        return String.format("The length of the %s at offset %d is larger than the amount of available data.", var1_1, n);
    }
}

