/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.mylzw;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.mylzw.MyBitInputStream;

public final class MyLzwDecompressor {
    private final byte[][] table;
    private int codeSize;
    private final int initialCodeSize;
    private int codes = -1;
    private final ByteOrder byteOrder;
    private final Listener listener = null;
    private final int clearCode;
    private final int eoiCode;
    private int written;
    private final boolean tiffLZWMode;

    /*
     * WARNING - void declaration
     */
    public MyLzwDecompressor(int initialCodeSize, ByteOrder byteOrder, boolean tiffLZWMode) throws ImagingException {
        this((int)var1_1, (ByteOrder)var2_2, (boolean)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private MyLzwDecompressor(int initialCodeSize, ByteOrder byteOrder, boolean tiffLZWMode, Listener listener) throws ImagingException {
        void var1_1;
        int n;
        void var2_3;
        this.byteOrder = var2_3;
        this.tiffLZWMode = n;
        this.initialCodeSize = initialCodeSize;
        this.table = new byte[4096][];
        this.clearCode = 1 << var1_1;
        this.eoiCode = this.clearCode + 1;
        MyLzwDecompressor myLzwDecompressor = this;
        this.codeSize = myLzwDecompressor.initialCodeSize;
        int n2 = 1 << myLzwDecompressor.codeSize + 2;
        if (n2 > myLzwDecompressor.table.length) {
            throw new ImagingException(String.format("Invalid Lzw table length [%d]; entries count is [%d]", myLzwDecompressor.table.length, n2));
        }
        for (n = 0; n < n2; ++n) {
            myLzwDecompressor.table[n] = new byte[]{(byte)n};
        }
    }

    private void addStringToTable(byte[] bytes) {
        MyLzwDecompressor myLzwDecompressor;
        if (this.codes < 1 << this.codeSize) {
            this.table[this.codes] = (byte[])myLzwDecompressor;
            ++this.codes;
        }
        myLzwDecompressor = this;
        int n = 1 << myLzwDecompressor.codeSize;
        if (myLzwDecompressor.tiffLZWMode) {
            --n;
        }
        if (myLzwDecompressor.codes == n) {
            myLzwDecompressor.incrementCodeSize();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] appendBytes(byte[] bytes, byte b) {
        byte[] byArray;
        void var1_1;
        byte[] byArray2 = Arrays.copyOf(bytes, bytes.length + 1);
        byte[] result = byArray2;
        byArray2[result.length - 1] = var1_1;
        return byArray;
    }

    private void clearTable() {
        this.codes = (1 << this.initialCodeSize) + 2;
        this.codeSize = this.initialCodeSize;
        this.incrementCodeSize();
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] decompress(InputStream is, int expectedLength) throws IOException {
        int oldCode22 = -1;
        try (MyBitInputStream mbis = new MyBitInputStream(is, this.byteOrder, this.tiffLZWMode);){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(Allocator.checkByteArray(expectedLength));){
                int code;
                this.clearTable();
                while ((code = this.getNextCode(mbis)) != this.eoiCode) {
                    void var1_2;
                    if (code == this.clearCode) {
                        this.clearTable();
                        if (this.written >= expectedLength || (code = this.getNextCode(mbis)) == this.eoiCode) break;
                        this.writeToResult(baos, this.stringFromCode(code));
                    } else {
                        int n = code;
                        MyLzwDecompressor myLzwDecompressor = this;
                        if (n < myLzwDecompressor.codes) {
                            this.writeToResult(baos, this.stringFromCode(code));
                            MyLzwDecompressor myLzwDecompressor2 = this;
                            byte[] oldCode22 = this.stringFromCode(code);
                            myLzwDecompressor2.addStringToTable(MyLzwDecompressor.appendBytes(myLzwDecompressor2.stringFromCode(oldCode22), oldCode22[0]));
                        } else {
                            void var3_7;
                            byte[] oldCode22 = this.stringFromCode(oldCode22);
                            byte[] outString = MyLzwDecompressor.appendBytes(this.stringFromCode(oldCode22), oldCode22[0]);
                            this.writeToResult(baos, outString);
                            this.addStringToTable((byte[])var3_7);
                        }
                    }
                    void var3_5 = var1_2;
                    if (this.written < expectedLength) continue;
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getNextCode(MyBitInputStream is) throws IOException {
        void var1_2;
        int code = is.readBits(this.codeSize);
        if (this.listener != null) {
        }
        return (int)var1_2;
    }

    private void incrementCodeSize() {
        if (this.codeSize != 12) {
            ++this.codeSize;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] stringFromCode(int code) throws ImagingException {
        void var1_1;
        if (code >= this.codes || code < 0) {
            throw new ImagingException("Bad Code: " + code + " codes: " + this.codes + " code_size: " + this.codeSize + ", table: " + this.table.length);
        }
        return this.table[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void writeToResult(OutputStream os, byte[] bytes) throws IOException {
        void var2_2;
        os.write(bytes);
        this.written += ((void)var2_2).length;
    }

    public static interface Listener {
    }
}

