/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.xbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BasicCParser;
import org.apache.commons.imaging.formats.xbm.XbmImagingParameters;

public final class XbmImageParser
extends AbstractImageParser<XbmImagingParameters> {
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.XBM.getExtensions();
    private static final String DEFAULT_EXTENSION = ImageFormats.XBM.getDefaultExtension();

    private static int parseCIntegerLiteral(String value) {
        String string;
        if (value.startsWith("0")) {
            if (value.length() >= 2) {
                if (value.charAt(1) == 'x' || value.charAt(1) == 'X') {
                    return Integer.parseInt(value.substring(2), 16);
                }
                return Integer.parseInt(value.substring(1), 8);
            }
            return 0;
        }
        return Integer.parseInt(string);
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.XBM};
    }

    /*
     * WARNING - void declaration
     */
    private static XbmParseResult parseXbmHeader(ByteSource byteSource) throws ImagingException, IOException {
        void var7_10;
        block11: {
            InputStream is = byteSource.getInputStream();
            try {
                void var1_1;
                void var3_5;
                void var2_3;
                HashMap<String, String> defines = new HashMap<String, String>();
                ByteArrayOutputStream preprocessedFile = BasicCParser.preprocess(is, null, defines);
                int width = -1;
                int height = -1;
                int xHot = -1;
                int yHot = -1;
                for (Map.Entry entry : defines.entrySet()) {
                    String name = (String)entry.getKey();
                    if (name.endsWith("_width")) {
                        width = XbmImageParser.parseCIntegerLiteral((String)entry.getValue());
                        continue;
                    }
                    if (name.endsWith("_height")) {
                        height = XbmImageParser.parseCIntegerLiteral((String)entry.getValue());
                        continue;
                    }
                    if (name.endsWith("_x_hot")) {
                        xHot = XbmImageParser.parseCIntegerLiteral((String)entry.getValue());
                        continue;
                    }
                    if (!name.endsWith("_y_hot")) continue;
                    yHot = XbmImageParser.parseCIntegerLiteral((String)entry.getValue());
                }
                if (width == -1) {
                    throw new ImagingException("width not found");
                }
                if (height == -1) {
                    throw new ImagingException("height not found");
                }
                XbmParseResult xbmParseResult = new XbmParseResult(0);
                new XbmParseResult(0).cParser = new BasicCParser(new ByteArrayInputStream(var2_3.toByteArray()));
                xbmParseResult.xbmHeader = new XbmHeader((int)var3_5, height, xHot, yHot);
                var7_10 = var1_1;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        InputStream inputStream;
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return var7_10;
    }

    private static final class XbmHeader {
        final int height;
        final int width;
        int xHot = -1;
        int yHot = -1;

        /*
         * WARNING - void declaration
         */
        XbmHeader(int width, int height, int xHot, int yHot) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.xHot = var3_3;
            this.yHot = yHot;
        }
    }

    private static final class XbmParseResult {
        BasicCParser cParser;
        XbmHeader xbmHeader;

        private XbmParseResult() {
        }

        /* synthetic */ XbmParseResult(byte by) {
            this();
        }
    }
}

