/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.taginfos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeLong;

public class TagInfo {
    public final String name;
    public final int tag;
    public final List<AbstractFieldType> dataTypes;
    public final int length;
    public final TiffDirectoryType directoryType;
    private final boolean isOffset;

    /*
     * WARNING - void declaration
     */
    public TagInfo(String name, int tag, AbstractFieldType dataType, int length, TiffDirectoryType exifDirectory) {
        this((String)var1_1, (int)var2_2, Arrays.asList(var3_3), length, exifDirectory);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TagInfo(String name, int tag, FieldTypeLong dataType, int length, TiffDirectoryType exifDirectory, boolean isOffset) {
        this((String)var1_1, (int)var2_2, Arrays.asList(var3_3), length, exifDirectory, isOffset);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TagInfo(String name, int tag, List<AbstractFieldType> dataTypes, int length, TiffDirectoryType exifDirectory) {
        this((String)var1_1, (int)var2_2, (List<AbstractFieldType>)var3_3, length, exifDirectory, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TagInfo(String name, int tag, List<AbstractFieldType> dataTypes, int length, TiffDirectoryType exifDirectory, boolean isOffset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.tag = var2_2;
        this.dataTypes = Collections.unmodifiableList(new ArrayList(var3_3));
        this.length = length;
        this.directoryType = exifDirectory;
        this.isOffset = isOffset;
    }

    public final String getDescription() {
        return this.tag + " (0x" + Integer.toHexString(this.tag) + ": " + this.name + "): ";
    }

    /*
     * WARNING - void declaration
     */
    public Object getValue(TiffField entry) throws ImagingException {
        void var1_1;
        return entry.getFieldType().getValue((TiffField)var1_1);
    }

    public String toString() {
        return "[TagInfo. tag: " + this.tag + " (0x" + Integer.toHexString(this.tag) + ", name: " + this.name + "]";
    }
}

