/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.itu_t4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.formats.tiff.itu_t4.BitArrayOutputStream;
import org.apache.commons.imaging.formats.tiff.itu_t4.BitInputStreamFlexible;
import org.apache.commons.imaging.formats.tiff.itu_t4.HuffmanTree;
import org.apache.commons.imaging.formats.tiff.itu_t4.T4_T6_Tables;

public final class T4AndT6Compression {
    private static final HuffmanTree<Integer> WHITE_RUN_LENGTHS = new HuffmanTree();
    private static final HuffmanTree<Integer> BLACK_RUN_LENGTHS = new HuffmanTree();
    private static final HuffmanTree<T4_T6_Tables.Entry> CONTROL_CODES = new HuffmanTree();

    /*
     * WARNING - void declaration
     */
    private static int changingElementAt(int[] line, int position) {
        void var1_1;
        int[] nArray;
        if (position < 0 || position >= line.length) {
            return 0;
        }
        return nArray[var1_1];
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressModifiedHuffman(byte[] compressed, int width, int height) throws ImagingException {
        try (Object baos = new ByteArrayInputStream(compressed);){
            BitInputStreamFlexible inputStream = new BitInputStreamFlexible((InputStream)baos);
            BitArrayOutputStream outputStream = new BitArrayOutputStream();
            for (int y = 0; y < height; ++y) {
                int rowLength;
                int runLength;
                int color = 0;
                for (rowLength = 0; rowLength < width; rowLength += runLength) {
                    runLength = T4AndT6Compression.readTotalRunLength(inputStream, color);
                    for (int i = 0; i < runLength; ++i) {
                        outputStream.writeBit(color);
                    }
                    color = 1 - color;
                }
                if (rowLength == width) {
                    inputStream.flushCache();
                    outputStream.flush();
                    continue;
                }
                if (rowLength <= width) continue;
                throw new ImagingException("Unrecoverable row length error in image row " + y);
            }
            byte[] byArray = outputStream.toByteArray();
            outputStream.close();
            inputStream.close();
            return byArray;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        try {
                            void var3_4;
                            var3_4.close();
                        }
                        catch (Throwable throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (IOException ioException) {
            void var0_1;
            throw new ImagingException("Error reading image to decompress", (Throwable)var0_1);
        }
    }

    public static byte[] decompressT4_1D(byte[] compressed, int width, int height, boolean hasFill) throws ImagingException {
        Object inputStream = new BitInputStreamFlexible(new ByteArrayInputStream(compressed));
        try (BitArrayOutputStream outputStream = new BitArrayOutputStream();){
            for (int y = 0; y < height; ++y) {
                int rowLength;
                try {
                    int runLength;
                    T4_T6_Tables.Entry entry = CONTROL_CODES.decode((BitInputStreamFlexible)inputStream);
                    if (!T4AndT6Compression.isEol(entry, hasFill)) {
                        throw new ImagingException("Expected EOL not found");
                    }
                    int color = 0;
                    for (rowLength = 0; rowLength < width; rowLength += runLength) {
                        runLength = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, color);
                        for (int i = 0; i < runLength; ++i) {
                            outputStream.writeBit(color);
                        }
                        color = 1 - color;
                    }
                }
                catch (ImagingException huffmanException) {
                    throw new ImagingException("Decompression error", huffmanException);
                }
                if (rowLength == width) {
                    outputStream.flush();
                    continue;
                }
                if (rowLength <= width) continue;
                throw new ImagingException("Unrecoverable row length error in image row " + y);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decompressT4_2D(byte[] compressed, int width, int height, boolean hasFill) throws ImagingException {
        Object inputStream = new BitInputStreamFlexible(new ByteArrayInputStream(compressed));
        try (BitArrayOutputStream outputStream = new BitArrayOutputStream();){
            int[] referenceLine = Allocator.intArray(width);
            for (int y = 0; y < height; ++y) {
                int n;
                boolean rowLength = false;
                try {
                    T4_T6_Tables.Entry entry = CONTROL_CODES.decode((BitInputStreamFlexible)inputStream);
                    if (!T4AndT6Compression.isEol(entry, hasFill)) {
                        throw new ImagingException("Expected EOL not found");
                    }
                    int n2 = ((BitInputStreamFlexible)inputStream).readBits(1);
                    if (n2 == 0) {
                        int codingA0Color = 0;
                        int b1 = T4AndT6Compression.nextChangingElement(referenceLine, 0, 0);
                        int b2 = T4AndT6Compression.nextChangingElement(referenceLine, 1, b1 + 1);
                        int a0 = 0;
                        while (a0 < width) {
                            int a1;
                            T4_T6_Tables.Entry entry2 = CONTROL_CODES.decode((BitInputStreamFlexible)inputStream);
                            if (entry2 == T4_T6_Tables.P) {
                                T4AndT6Compression.fillRange(outputStream, referenceLine, a0, b2, codingA0Color);
                                a0 = b2;
                            } else if (entry2 == T4_T6_Tables.H) {
                                int a0a1 = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, codingA0Color);
                                a1 = a0 + a0a1;
                                T4AndT6Compression.fillRange(outputStream, referenceLine, a0, a1, codingA0Color);
                                int a1a2 = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, 1 - codingA0Color);
                                int a2 = a1 + a1a2;
                                T4AndT6Compression.fillRange(outputStream, referenceLine, a1, a2, 1 - codingA0Color);
                                a0 = a2;
                            } else {
                                int a1b1;
                                void a2;
                                if (a2 == T4_T6_Tables.V0) {
                                    a1b1 = 0;
                                } else if (a2 == T4_T6_Tables.VL1) {
                                    a1b1 = -1;
                                } else if (a2 == T4_T6_Tables.VL2) {
                                    a1b1 = -2;
                                } else if (a2 == T4_T6_Tables.VL3) {
                                    a1b1 = -3;
                                } else if (a2 == T4_T6_Tables.VR1) {
                                    a1b1 = 1;
                                } else if (a2 == T4_T6_Tables.VR2) {
                                    a1b1 = 2;
                                } else if (a2 == T4_T6_Tables.VR3) {
                                    a1b1 = 3;
                                } else {
                                    throw new ImagingException("Invalid/unknown T.4 control code " + a2.bitString);
                                }
                                a1 = b1 + a1b1;
                                T4AndT6Compression.fillRange(outputStream, referenceLine, a0, a1, codingA0Color);
                                a0 = a1;
                                codingA0Color = 1 - codingA0Color;
                            }
                            int referenceA0Color = T4AndT6Compression.changingElementAt(referenceLine, a0);
                            if (codingA0Color == referenceA0Color) {
                                b1 = T4AndT6Compression.nextChangingElement(referenceLine, referenceA0Color, a0 + 1);
                            } else {
                                b1 = T4AndT6Compression.nextChangingElement(referenceLine, referenceA0Color, a0 + 1);
                                b1 = T4AndT6Compression.nextChangingElement(referenceLine, 1 - referenceA0Color, b1 + 1);
                            }
                            b2 = T4AndT6Compression.nextChangingElement(referenceLine, 1 - codingA0Color, b1 + 1);
                            n = a0;
                        }
                    } else {
                        int runLength;
                        int color = 0;
                        for (n = 0; n < width; n += runLength) {
                            runLength = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, color);
                            for (int i = 0; i < runLength; ++i) {
                                outputStream.writeBit(color);
                                referenceLine[n + i] = color;
                            }
                            color = 1 - color;
                        }
                    }
                }
                catch (IOException e) {
                    throw new ImagingException("Decompression error", e);
                }
                if (n == width) {
                    outputStream.flush();
                    continue;
                }
                if (n <= width) continue;
                throw new ImagingException("Unrecoverable row length error in image row " + y);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressT6(byte[] compressed, int width, int height) throws ImagingException {
        try (Object inputStream = new BitInputStreamFlexible(new ByteArrayInputStream(compressed));){
            BitArrayOutputStream outputStream = new BitArrayOutputStream();
            try {
                int[] referenceLine = Allocator.intArray(width);
                for (int y = 0; y < height; ++y) {
                    int n;
                    boolean rowLength = false;
                    int codingA0Color = 0;
                    int b1 = T4AndT6Compression.nextChangingElement(referenceLine, 0, 0);
                    int b2 = T4AndT6Compression.nextChangingElement(referenceLine, 1, b1 + 1);
                    int a0 = 0;
                    while (a0 < width) {
                        int n2;
                        T4_T6_Tables.Entry entry = CONTROL_CODES.decode((BitInputStreamFlexible)inputStream);
                        if (entry == T4_T6_Tables.P) {
                            T4AndT6Compression.fillRange(outputStream, referenceLine, a0, b2, codingA0Color);
                            a0 = b2;
                        } else if (entry == T4_T6_Tables.H) {
                            int a0a1 = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, codingA0Color);
                            int a1 = a0 + a0a1;
                            T4AndT6Compression.fillRange(outputStream, referenceLine, a0, a1, codingA0Color);
                            int a1a2 = T4AndT6Compression.readTotalRunLength((BitInputStreamFlexible)inputStream, 1 - codingA0Color);
                            int a2 = a1 + a1a2;
                            T4AndT6Compression.fillRange(outputStream, referenceLine, a1, a2, 1 - codingA0Color);
                            a0 = a2;
                        } else {
                            void a1b12;
                            int a1b12;
                            void a1;
                            if (a1 == T4_T6_Tables.V0) {
                                a1b12 = 0;
                            } else if (a1b12 == T4_T6_Tables.VL1) {
                                a1b12 = -1;
                            } else if (a1b12 == T4_T6_Tables.VL2) {
                                a1b12 = -2;
                            } else if (a1b12 == T4_T6_Tables.VL3) {
                                a1b12 = -3;
                            } else if (a1b12 == T4_T6_Tables.VR1) {
                                a1b12 = 1;
                            } else if (a1b12 == T4_T6_Tables.VR2) {
                                a1b12 = 2;
                            } else if (a1b12 == T4_T6_Tables.VR3) {
                                a1b12 = 3;
                            } else {
                                throw new ImagingException("Invalid/unknown T.6 control code " + a1b12.bitString);
                            }
                            a1 = n2 + a1b12;
                            T4AndT6Compression.fillRange(outputStream, referenceLine, a0, (int)a1, codingA0Color);
                            a0 = a1;
                            codingA0Color = 1 - codingA0Color;
                        }
                        int referenceA0Color = T4AndT6Compression.changingElementAt(referenceLine, a0);
                        if (codingA0Color == referenceA0Color) {
                            n2 = T4AndT6Compression.nextChangingElement(referenceLine, referenceA0Color, a0 + 1);
                        } else {
                            n2 = T4AndT6Compression.nextChangingElement(referenceLine, referenceA0Color, a0 + 1);
                            n2 = T4AndT6Compression.nextChangingElement(referenceLine, 1 - referenceA0Color, n2 + 1);
                        }
                        b2 = T4AndT6Compression.nextChangingElement(referenceLine, 1 - codingA0Color, n2 + 1);
                        n = a0;
                    }
                    if (n == width) {
                        outputStream.flush();
                        continue;
                    }
                    if (n <= width) continue;
                    throw new ImagingException("Unrecoverable row length error in image row " + y);
                }
                byte[] byArray = outputStream.toByteArray();
                outputStream.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    void var3_3;
                    var3_3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            Object object;
            Object e = iOException;
            if (iOException instanceof ImagingException) {
                throw (ImagingException)e;
            }
            throw new ImagingException("Closing stream", (Throwable)object);
        }
    }

    private static void fillRange(BitArrayOutputStream outputStream, int[] referenceRow, int a0, int end, int color) {
        for (int i = a0; i < end; ++i) {
            referenceRow[i] = color;
            outputStream.writeBit(color);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isEol(T4_T6_Tables.Entry entry, boolean hasFill) {
        void var1_1;
        if (entry == T4_T6_Tables.EOL) {
            return true;
        }
        if (var1_1 != false) {
            T4_T6_Tables.Entry entry2;
            return entry == T4_T6_Tables.EOL13 || entry == T4_T6_Tables.EOL14 || entry == T4_T6_Tables.EOL15 || entry == T4_T6_Tables.EOL16 || entry == T4_T6_Tables.EOL17 || entry == T4_T6_Tables.EOL18 || entry2 == T4_T6_Tables.EOL19;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static int nextChangingElement(int[] line, int currentColour, int start) {
        int[] nArray;
        void var2_2;
        for (int position = start; position < line.length && line[position] == currentColour; ++position) {
        }
        return Math.min((int)var2_2, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    private static int readTotalRunLength(BitInputStreamFlexible bitStream, int color) throws ImagingException {
        void var2_2;
        void var3_3;
        int totalLength = 0;
        do {
            Integer runLength = color == 0 ? WHITE_RUN_LENGTHS.decode(bitStream) : BLACK_RUN_LENGTHS.decode(bitStream);
            totalLength += runLength.intValue();
        } while (var3_3.intValue() > 63);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            T4_T6_Tables.Entry entry;
            int n;
            T4_T6_Tables.Entry[] entryArray = T4_T6_Tables.WHITE_TERMINATING_CODES;
            int n2 = T4_T6_Tables.WHITE_TERMINATING_CODES.length;
            for (n = 0; n < n2; ++n) {
                entry = entryArray[n];
                WHITE_RUN_LENGTHS.insert(entry.bitString, entry.value);
            }
            entryArray = T4_T6_Tables.WHITE_MAKE_UP_CODES;
            n2 = T4_T6_Tables.WHITE_MAKE_UP_CODES.length;
            for (n = 0; n < n2; ++n) {
                entry = entryArray[n];
                WHITE_RUN_LENGTHS.insert(entry.bitString, entry.value);
            }
            entryArray = T4_T6_Tables.BLACK_TERMINATING_CODES;
            n2 = T4_T6_Tables.BLACK_TERMINATING_CODES.length;
            for (n = 0; n < n2; ++n) {
                entry = entryArray[n];
                BLACK_RUN_LENGTHS.insert(entry.bitString, entry.value);
            }
            entryArray = T4_T6_Tables.BLACK_MAKE_UP_CODES;
            n2 = T4_T6_Tables.BLACK_MAKE_UP_CODES.length;
            for (n = 0; n < n2; ++n) {
                entry = entryArray[n];
                BLACK_RUN_LENGTHS.insert(entry.bitString, entry.value);
            }
            entryArray = T4_T6_Tables.ADDITIONAL_MAKE_UP_CODES;
            n2 = T4_T6_Tables.ADDITIONAL_MAKE_UP_CODES.length;
            for (n = 0; n < n2; ++n) {
                void var3_4;
                entry = entryArray[n];
                WHITE_RUN_LENGTHS.insert(entry.bitString, entry.value);
                BLACK_RUN_LENGTHS.insert(entry.bitString, var3_4.value);
            }
            CONTROL_CODES.insert(T4_T6_Tables.EOL.bitString, T4_T6_Tables.EOL);
            CONTROL_CODES.insert(T4_T6_Tables.EOL13.bitString, T4_T6_Tables.EOL13);
            CONTROL_CODES.insert(T4_T6_Tables.EOL14.bitString, T4_T6_Tables.EOL14);
            CONTROL_CODES.insert(T4_T6_Tables.EOL15.bitString, T4_T6_Tables.EOL15);
            CONTROL_CODES.insert(T4_T6_Tables.EOL16.bitString, T4_T6_Tables.EOL16);
            CONTROL_CODES.insert(T4_T6_Tables.EOL17.bitString, T4_T6_Tables.EOL17);
            CONTROL_CODES.insert(T4_T6_Tables.EOL18.bitString, T4_T6_Tables.EOL18);
            CONTROL_CODES.insert(T4_T6_Tables.EOL19.bitString, T4_T6_Tables.EOL19);
            CONTROL_CODES.insert(T4_T6_Tables.P.bitString, T4_T6_Tables.P);
            CONTROL_CODES.insert(T4_T6_Tables.H.bitString, T4_T6_Tables.H);
            CONTROL_CODES.insert(T4_T6_Tables.V0.bitString, T4_T6_Tables.V0);
            CONTROL_CODES.insert(T4_T6_Tables.VL1.bitString, T4_T6_Tables.VL1);
            CONTROL_CODES.insert(T4_T6_Tables.VL2.bitString, T4_T6_Tables.VL2);
            CONTROL_CODES.insert(T4_T6_Tables.VL3.bitString, T4_T6_Tables.VL3);
            CONTROL_CODES.insert(T4_T6_Tables.VR1.bitString, T4_T6_Tables.VR1);
            CONTROL_CODES.insert(T4_T6_Tables.VR2.bitString, T4_T6_Tables.VR2);
            CONTROL_CODES.insert(T4_T6_Tables.VR3.bitString, T4_T6_Tables.VR3);
            return;
        }
        catch (ImagingException cannotHappen) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }
}

