/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.itu_t4;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;

final class BitInputStreamFlexible
extends FilterInputStream {
    private int cache;
    private int cacheBitsRemaining;
    private long bytesRead;

    /*
     * WARNING - void declaration
     */
    BitInputStreamFlexible(InputStream is) {
        super((InputStream)var1_1);
        void var1_1;
    }

    public final void flushCache() {
        this.cacheBitsRemaining = 0;
    }

    @Override
    public final int read() throws IOException {
        if (this.cacheBitsRemaining > 0) {
            throw new ImagingException("BitInputStream: incomplete bit read");
        }
        return this.in.read();
    }

    /*
     * WARNING - void declaration
     */
    public final int readBits(int count) throws IOException {
        void var2_2;
        int result = 0;
        if (this.cacheBitsRemaining > 0) {
            if (1 >= this.cacheBitsRemaining) {
                result = (1 << this.cacheBitsRemaining) - 1 & this.cache;
                count = 1 - this.cacheBitsRemaining;
                this.cacheBitsRemaining = 0;
            } else {
                --this.cacheBitsRemaining;
                result = 1 & this.cache >> this.cacheBitsRemaining;
                count = 0;
            }
        }
        while (count >= 8) {
            this.cache = this.in.read();
            if (this.cache < 0) {
                throw new ImagingException("Couldn't read bits");
            }
            ++this.bytesRead;
            result = result << 8 | 0xFF & this.cache;
            count -= 8;
        }
        if (count > 0) {
            void var1_1;
            this.cache = this.in.read();
            if (this.cache < 0) {
                throw new ImagingException("Couldn't read bits");
            }
            ++this.bytesRead;
            this.cacheBitsRemaining = 8 - count;
            result = result << count | (1 << var1_1) - 1 & this.cache >> this.cacheBitsRemaining;
        }
        return (int)var2_2;
    }
}

