/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.itu_t4;

import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.imaging.common.Allocator;

final class BitArrayOutputStream
extends OutputStream {
    private byte[] buffer = new byte[16];
    private int bytesWritten;
    private int cache;
    private int cacheMask = 128;

    BitArrayOutputStream() {
    }

    @Override
    public final void close() {
        this.flush();
    }

    @Override
    public final void flush() {
        if (this.cacheMask != 128) {
            BitArrayOutputStream bitArrayOutputStream = this;
            bitArrayOutputStream.writeByte(bitArrayOutputStream.cache);
            this.cache = 0;
            this.cacheMask = 128;
        }
    }

    public final byte[] toByteArray() {
        this.flush();
        if (this.bytesWritten == this.buffer.length) {
            return this.buffer;
        }
        return Arrays.copyOf(this.buffer, this.bytesWritten);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(int b) {
        void var1_1;
        this.flush();
        this.writeByte((int)var1_1);
    }

    public final void writeBit(int bit) {
        if (bit != 0) {
            this.cache |= this.cacheMask;
        }
        this.cacheMask >>>= 1;
        if (this.cacheMask == 0) {
            this.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeByte(int b) {
        void var1_1;
        if (this.bytesWritten >= this.buffer.length) {
            void var2_2;
            byte[] bigger = Allocator.byteArray(this.buffer.length * 2);
            System.arraycopy(this.buffer, 0, bigger, 0, this.bytesWritten);
            this.buffer = var2_2;
        }
        this.buffer[this.bytesWritten++] = (byte)var1_1;
    }
}

