/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.fieldtypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeByte;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeDouble;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeFloat;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeLong;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeLong8;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeRational;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeShort;

public abstract class AbstractFieldType {
    public static final FieldTypeByte BYTE = new FieldTypeByte(1, "Byte");
    public static final FieldTypeAscii ASCII = new FieldTypeAscii(2, "ASCII");
    public static final FieldTypeShort SHORT = new FieldTypeShort(3, "Short");
    public static final FieldTypeLong LONG = new FieldTypeLong(4, "Long");
    public static final FieldTypeRational RATIONAL = new FieldTypeRational(5, "Rational");
    public static final FieldTypeByte SBYTE = new FieldTypeByte(6, "SByte");
    public static final FieldTypeByte UNDEFINED = new FieldTypeByte(7, "Undefined");
    public static final FieldTypeShort SSHORT = new FieldTypeShort(8, "SShort");
    public static final FieldTypeLong SLONG = new FieldTypeLong(9, "SLong");
    public static final FieldTypeRational SRATIONAL = new FieldTypeRational(10, "SRational");
    public static final FieldTypeFloat FLOAT = new FieldTypeFloat(11, "Float");
    public static final FieldTypeDouble DOUBLE = new FieldTypeDouble(12, "Double");
    public static final FieldTypeLong IFD = new FieldTypeLong(13, "IFD");
    public static final FieldTypeLong8 LONG8 = new FieldTypeLong8(16, "Long8");
    public static final FieldTypeLong8 SLONG8 = new FieldTypeLong8(17, "Long8");
    public static final FieldTypeLong8 IFD8 = new FieldTypeLong8(18, "Long8");
    public static final List<AbstractFieldType> ANY = Collections.unmodifiableList(Arrays.asList(BYTE, ASCII, SHORT, LONG, RATIONAL, SBYTE, UNDEFINED, SSHORT, SLONG, SRATIONAL, FLOAT, DOUBLE, IFD, LONG8, SLONG8, IFD8));
    public static final List<AbstractFieldType> SHORT_OR_LONG = Collections.unmodifiableList(Arrays.asList(SHORT, LONG));
    public static final List<AbstractFieldType> SHORT_OR_RATIONAL = Collections.unmodifiableList(Arrays.asList(SHORT, RATIONAL));
    public static final List<AbstractFieldType> SHORT_OR_LONG_OR_RATIONAL = Collections.unmodifiableList(Arrays.asList(SHORT, LONG, RATIONAL));
    public static final List<AbstractFieldType> LONG_OR_SHORT = Collections.unmodifiableList(Arrays.asList(SHORT, LONG));
    public static final List<AbstractFieldType> BYTE_OR_SHORT = Collections.unmodifiableList(Arrays.asList(SHORT, BYTE));
    public static final List<AbstractFieldType> LONG_OR_IFD = Collections.unmodifiableList(Arrays.asList(LONG, IFD));
    public static final List<AbstractFieldType> ASCII_OR_RATIONAL = Collections.unmodifiableList(Arrays.asList(ASCII, RATIONAL));
    public static final List<AbstractFieldType> ASCII_OR_BYTE = Collections.unmodifiableList(Arrays.asList(ASCII, BYTE));
    private final int type;
    private final String name;
    private final int elementSize;

    /*
     * WARNING - void declaration
     */
    public static AbstractFieldType getFieldType(int type) throws ImagingException {
        int n;
        Iterator<AbstractFieldType> iterator = ANY.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            AbstractFieldType abstractFieldType;
            AbstractFieldType abstractFieldType2 = abstractFieldType = iterator.next();
            if (abstractFieldType.type != type) continue;
            return var2_2;
        }
        throw new ImagingException("Field type " + n + " is unsupported");
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractFieldType(int type, String name, int elementSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.type = var1_1;
        this.name = var2_2;
        this.elementSize = var3_3;
    }

    public final String getName() {
        return this.name;
    }

    public final int getSize() {
        return this.elementSize;
    }

    public abstract Object getValue(TiffField var1);
}

