/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.datareaders.BitInputStream;
import org.apache.commons.imaging.formats.tiff.datareaders.DataInterpreterJpeg;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;

public final class DataReaderTiled
extends ImageDataReader {
    private final int tileWidth;
    private final int tileLength;
    private final int bitsPerPixel;
    private final int compression;
    private final ByteOrder byteOrder;
    private final AbstractTiffImageData.Tiles imageData;

    /*
     * WARNING - void declaration
     */
    public DataReaderTiled(TiffDirectory directory, PhotometricInterpreter photometricInterpreter, int tileWidth, int tileLength, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int sampleFormat, int width, int height, int compression, TiffPlanarConfiguration planarConfiguration, ByteOrder byteOrder, AbstractTiffImageData.Tiles imageData) {
        super((TiffDirectory)var1_1, (PhotometricInterpreter)var2_2, bitsPerSample, predictor, samplesPerPixel, sampleFormat, width, height, planarConfiguration);
        void var3_3;
        void var2_2;
        void var1_1;
        this.tileWidth = var3_3;
        this.tileLength = tileLength;
        this.bitsPerPixel = bitsPerPixel;
        this.compression = compression;
        this.imageData = imageData;
        this.byteOrder = byteOrder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImageBuilder readImageData(Rectangle subImageSpecification, boolean hasAlpha, boolean isAlphaPreMultiplied) throws IOException, ImagingException {
        void var1_1;
        void var2_3;
        Rectangle subImage;
        if (subImageSpecification == null) {
            subImage = new Rectangle(0, 0, this.width, this.height);
        }
        int n = this.tileWidth * this.bitsPerPixel;
        n = (n + 7) / 8;
        int bytesPerTile = n * this.tileLength;
        int col0 = subImage.x / this.tileWidth;
        int col1 = (subImage.x + subImage.width - 1) / this.tileWidth;
        int row0 = subImage.y / this.tileLength;
        int row1 = (subImage.y + subImage.height - 1) / this.tileLength;
        int nCol = col1 - col0 + 1;
        int nRow = row1 - row0 + 1;
        int workingWidth = nCol * this.tileWidth;
        int workingHeight = nRow * this.tileLength;
        int nColumnsOfTiles = (this.width + this.tileWidth - 1) / this.tileWidth;
        int x0 = col0 * this.tileWidth;
        int y0 = row0 * this.tileLength;
        ImageBuilder workingBuilder = new ImageBuilder(workingWidth, workingHeight, hasAlpha, isAlphaPreMultiplied);
        for (int iRow = row0; iRow <= row1; ++iRow) {
            block6: for (int iCol = col0; iCol <= col1; ++iCol) {
                int n2;
                int[] nArray;
                int n3;
                int n4;
                int n5;
                int n6;
                int tile = iRow * nColumnsOfTiles + iCol;
                byte[] compressed = this.imageData.tiles[tile].getData();
                int x = iCol * this.tileWidth - x0;
                int y = iRow * this.tileLength - y0;
                if (this.compression == 7) {
                    if (this.planarConfiguration == TiffPlanarConfiguration.PLANAR) {
                        throw new ImagingException("TIFF file in non-supported configuration: JPEG compression used in planar configuration.");
                    }
                    DataInterpreterJpeg.intepretBlock(this.directory, workingBuilder, x, y, this.tileWidth, this.tileLength, compressed);
                    continue;
                }
                byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile, this.tileWidth, this.tileLength);
                int n7 = this.height;
                int n8 = this.width;
                int n9 = y;
                int n10 = x;
                byte[] byArray = decompressed;
                ImageBuilder imageBuilder = workingBuilder;
                DataReaderTiled dataReaderTiled = this;
                if (dataReaderTiled.sampleFormat == 3) {
                    n6 = n9;
                    n5 = n9 + dataReaderTiled.tileLength;
                    if (n5 > n7) {
                        n5 = n7;
                    }
                    n4 = n10;
                    n3 = n10 + dataReaderTiled.tileWidth;
                    if (n3 > n8) {
                        n3 = n8;
                    }
                    int[] nArray2 = new int[4];
                    nArray = dataReaderTiled.unpackFloatingPointSamples(n3 - n4, n5 - n6, dataReaderTiled.tileWidth, byArray, dataReaderTiled.bitsPerPixel, dataReaderTiled.byteOrder);
                    while (n6 < n5) {
                        int n11 = n6 - n9;
                        n2 = n11 * dataReaderTiled.tileWidth;
                        for (n11 = n4; n11 < n3; ++n11) {
                            n8 = n11 - n10;
                            n8 = (n2 + n8) * dataReaderTiled.samplesPerPixel;
                            nArray2[0] = nArray[n8];
                            dataReaderTiled.photometricInterpreter.interpretPixel(imageBuilder, nArray2, n11, n6);
                        }
                        ++n6;
                    }
                    continue;
                }
                n6 = dataReaderTiled.isHomogenous(8) ? 1 : 0;
                if ((dataReaderTiled.bitsPerPixel == 24 || dataReaderTiled.bitsPerPixel == 32) && n6 != 0 && dataReaderTiled.photometricInterpreter instanceof PhotometricInterpreterRgb) {
                    n5 = n9 + dataReaderTiled.tileLength;
                    if (n5 > n7) {
                        n5 = n7;
                    }
                    if ((n4 = n10 + dataReaderTiled.tileWidth) > n8) {
                        n4 = n8;
                    }
                    if (dataReaderTiled.predictor == 2) {
                        DataReaderTiled.applyPredictorToBlock(dataReaderTiled.tileWidth, n5 - n9, dataReaderTiled.samplesPerPixel, byArray);
                    }
                    if (dataReaderTiled.bitsPerPixel == 24) {
                        for (n3 = n9; n3 < n5; ++n3) {
                            int n12 = (n3 - n9) * dataReaderTiled.tileWidth * 3;
                            int n13 = n10;
                            while (n13 < n4) {
                                n6 = 0xFF000000 | byArray[n12] << 16 | (byArray[n12 + 1] & 0xFF) << 8 | byArray[n12 + 2] & 0xFF;
                                imageBuilder.setRgb(n13, n3, n6);
                                ++n13;
                                n12 += 3;
                            }
                        }
                        continue;
                    }
                    if (dataReaderTiled.bitsPerPixel != 32) continue;
                    for (n3 = n9; n3 < n5; ++n3) {
                        int n14 = (n3 - n9) * dataReaderTiled.tileWidth * 4;
                        int n15 = n10;
                        while (n15 < n4) {
                            n6 = (byArray[n14] & 0xFF) << 16 | (byArray[n14 + 1] & 0xFF) << 8 | byArray[n14 + 2] & 0xFF | byArray[n14 + 3] << 24;
                            imageBuilder.setRgb(n15, n3, n6);
                            ++n15;
                            n14 += 4;
                        }
                    }
                    continue;
                }
                try (BitInputStream bitInputStream = new BitInputStream(new ByteArrayInputStream(byArray), dataReaderTiled.byteOrder);){
                    n4 = dataReaderTiled.tileWidth * dataReaderTiled.tileLength;
                    n3 = 0;
                    int n16 = 0;
                    nArray = Allocator.intArray(dataReaderTiled.bitsPerSampleLength);
                    dataReaderTiled.resetPredictor();
                    for (n6 = 0; n6 < n4; ++n6) {
                        int n17 = n3 + n10;
                        n2 = n16 + n9;
                        dataReaderTiled.getSamplesAsBytes(bitInputStream, nArray);
                        if (n17 < n8 && n2 < n7) {
                            nArray = dataReaderTiled.applyPredictor(nArray);
                            dataReaderTiled.photometricInterpreter.interpretPixel(imageBuilder, nArray, n17, n2);
                        }
                        if (++n3 < dataReaderTiled.tileWidth) continue;
                        n3 = 0;
                        dataReaderTiled.resetPredictor();
                        bitInputStream.flushCache();
                        if (++n16 >= dataReaderTiled.tileLength) continue block6;
                    }
                    continue;
                }
            }
        }
        if (subImage.x == x0 && subImage.y == y0 && subImage.width == workingWidth && subImage.height == workingHeight) {
            return workingBuilder;
        }
        return var2_3.getSubset(subImage.x - x0, subImage.y - y0, subImage.width, var1_1.height);
    }
}

