/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegDecoder;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.AdobePhotoshopTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.io.build.AbstractOrigin;

final class DataInterpreterJpeg {
    static void intepretBlock(TiffDirectory directory, ImageBuilder workingBuilder, int xBlock, int yBlock, int blockWidth, int blockHeight, byte[] compressed) throws ImagingException, IOException {
        Object concat;
        if (compressed.length <= 4) {
            return;
        }
        byte[] field = directory.getFieldValue$6c63a701(AdobePhotoshopTagConstants.EXIF_TAG_JPEGTABLES, false);
        if (field == null || field.length == 0) {
            concat = compressed;
        } else {
            concat = new byte[field.length + compressed.length - 4];
            System.arraycopy(field, 0, concat, 0, field.length - 2);
            System.arraycopy(compressed, 2, concat, field.length - 2, compressed.length - 2);
        }
        byte[] byArray = concat;
        concat = "JPEGtile";
        compressed = byArray;
        ByteSource bsArray = new ByteSource((AbstractOrigin<?, ?>)new AbstractOrigin.ByteArrayOrigin(compressed), (String)concat);
        JpegDecoder decoder = new JpegDecoder();
        TiffField piField = directory.findField(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
        if (piField != null && (piField = piField.getIntValue()) == 2) {
            decoder.setTiffRgb();
        }
        BufferedImage bImage = decoder.decode(bsArray);
        int iWidth = bImage.getWidth();
        int iHeight = bImage.getHeight();
        int[] argb = new int[iWidth * iHeight];
        bImage.getRGB(0, 0, iWidth, iHeight, argb, 0, iWidth);
        int i1 = iHeight > blockHeight ? blockHeight : iHeight;
        int j1 = iWidth > blockWidth ? blockWidth : iWidth;
        for (int i = 0; i < i1; ++i) {
            for (int j = 0; j < j1; ++j) {
                workingBuilder.setRgb(j + xBlock, i + yBlock, argb[i * iWidth + j]);
            }
        }
    }
}

