/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.formats.tiff.constants.AdobePageMaker6TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.AdobePhotoshopTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.AliasSketchbookProTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.DcfTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.DngTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GdalLibraryTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GeoTiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.HylaFaxTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftHdPhotoTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MicrosoftTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.MolecularDynamicsGelTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.OceScanjobTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.Rfc2301TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.Tiff4TagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffDirectoryType;
import org.apache.commons.imaging.formats.tiff.constants.TiffEpTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.WangTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

final class TiffTags {
    private static final List<TagInfo> ALL_TAGS;
    private static final Map<Integer, List<TagInfo>> ALL_TAG_MAP;
    private static final Map<Integer, Integer> TAG_COUNTS;

    /*
     * WARNING - void declaration
     */
    static TagInfo getTag(int directoryType, int tag) {
        int n;
        void var1_2;
        List<TagInfo> possibleMatches = ALL_TAG_MAP.get(tag);
        if (possibleMatches == null) {
            return TiffTagConstants.TIFF_TAG_UNKNOWN;
        }
        if (var1_2.isEmpty()) {
            return null;
        }
        for (TagInfo tagInfo : var1_2) {
            if (tagInfo.directoryType == TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN || n != tagInfo.directoryType.directoryType) continue;
            return tagInfo;
        }
        for (TagInfo tagInfo : var1_2) {
            if (tagInfo.directoryType == TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN) continue;
            if (n >= 0 && tagInfo.directoryType.isImageDirectory()) {
                return tagInfo;
            }
            if (n >= 0 || tagInfo.directoryType.isImageDirectory()) continue;
            return tagInfo;
        }
        for (TagInfo tagInfo : var1_2) {
            if (tagInfo.directoryType != TiffDirectoryType.EXIF_DIRECTORY_UNKNOWN) continue;
            return tagInfo;
        }
        return TiffTagConstants.TIFF_TAG_UNKNOWN;
    }

    static {
        TagInfo tagInfo;
        Object object = new ArrayList<TagInfo>(AdobePageMaker6TagConstants.ALL_ADOBE_PAGEMAKER_6_TAGS);
        ((ArrayList)object).addAll(AdobePhotoshopTagConstants.ALL_ADOBE_PHOTOSHOP_TAGS);
        ((ArrayList)object).addAll(AliasSketchbookProTagConstants.ALL_ALIAS_SKETCHBOOK_PRO_TAGS);
        ((ArrayList)object).addAll(DcfTagConstants.ALL_DCF_TAGS);
        ((ArrayList)object).addAll(DngTagConstants.ALL_DNG_TAGS);
        ((ArrayList)object).addAll(ExifTagConstants.ALL_EXIF_TAGS);
        ((ArrayList)object).addAll(GeoTiffTagConstants.ALL_GEO_TIFF_TAGS);
        ((ArrayList)object).addAll(GdalLibraryTagConstants.ALL_GDAL_LIBRARY_TAGS);
        ((ArrayList)object).addAll(GpsTagConstants.ALL_GPS_TAGS);
        ((ArrayList)object).addAll(HylaFaxTagConstants.ALL_HYLAFAX_TAGS);
        ((ArrayList)object).addAll(MicrosoftTagConstants.ALL_MICROSOFT_TAGS);
        ((ArrayList)object).addAll(MicrosoftHdPhotoTagConstants.ALL_MICROSOFT_HD_PHOTO_TAGS);
        ((ArrayList)object).addAll(MolecularDynamicsGelTagConstants.ALL_MOLECULAR_DYNAMICS_GEL_TAGS);
        ((ArrayList)object).addAll(OceScanjobTagConstants.ALL_OCE_SCANJOB_TAGS);
        ((ArrayList)object).addAll(Rfc2301TagConstants.ALL_RFC_2301_TAGS);
        ((ArrayList)object).addAll(Tiff4TagConstants.ALL_TIFF_4_TAGS);
        ((ArrayList)object).addAll(TiffEpTagConstants.ALL_TIFF_EP_TAGS);
        ((ArrayList)object).addAll(TiffTagConstants.ALL_TIFF_TAGS);
        ((ArrayList)object).addAll(WangTagConstants.ALL_WANG_TAGS);
        ALL_TAGS = Collections.unmodifiableList(object);
        object = ALL_TAGS;
        HashMap<Integer, List<TagInfo>> hashMap = new HashMap<Integer, List<TagInfo>>();
        object = object.iterator();
        while (object.hasNext()) {
            tagInfo = (TagInfo)object.next();
            List list = hashMap.computeIfAbsent(tagInfo.tag, k -> new ArrayList());
            list.add(tagInfo);
        }
        ALL_TAG_MAP = hashMap;
        object = ALL_TAGS;
        hashMap = new HashMap();
        object = object.iterator();
        while (object.hasNext()) {
            tagInfo = (TagInfo)object.next();
            hashMap.merge(tagInfo.tag, (List<TagInfo>)1, Integer::sum);
        }
        TAG_COUNTS = hashMap;
    }
}

