/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterBiLevel;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterCieLab;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterCmyk;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterLogLuv;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterPalette;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterYCbCr;

public final class TiffImageParser
extends AbstractImageParser<TiffImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.TIFF.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.TIFF.getExtensions();

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.TIFF};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        void var2_2;
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, formatCompliance);
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        for (int i = 0; i < contents.directories.size(); ++i) {
            TiffDirectory tiffDirectory = contents.directories.get(i);
            BufferedImage result = tiffDirectory.getTiffImage(tiffReader.getByteOrder(), null);
            if (result == null) continue;
            results.add(result);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final BufferedImage getBufferedImage(TiffDirectory directory, ByteOrder byteOrder, TiffImagingParameters params2222) throws ImagingException, IOException {
        void var2_2;
        void var3_3;
        Object object;
        TiffField pcField;
        TiffPlanarConfiguration planarConfiguration;
        Object photometricInterpreter32;
        Rectangle subImage;
        Rectangle rectangle;
        int n;
        int n2;
        int n3;
        short compressionFieldValue = directory.findField(TiffTagConstants.TIFF_TAG_COMPRESSION) != null ? directory.getFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION) : (short)1;
        int compression = 0xFFFF & compressionFieldValue;
        int width = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH);
        int height = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
        TiffImagingParameters tiffImagingParameters = params2222;
        if (tiffImagingParameters != null && tiffImagingParameters.isSubImageSet()) {
            n3 = tiffImagingParameters.getSubImageX();
            int n4 = tiffImagingParameters.getSubImageY();
            n2 = tiffImagingParameters.getSubImageWidth();
            n = tiffImagingParameters.getSubImageHeight();
            rectangle = new Rectangle(n3, n4, n2, n);
        } else {
            rectangle = subImage = null;
        }
        if (rectangle != null) {
            if (subImage.width <= 0) {
                throw new ImagingException("Negative or zero subimage width.");
            }
            if (subImage.height <= 0) {
                throw new ImagingException("Negative or zero subimage height.");
            }
            if (subImage.x < 0 || subImage.x >= width) {
                throw new ImagingException("Subimage x is outside raster.");
            }
            if (subImage.x + subImage.width > width) {
                throw new ImagingException("Subimage (x+width) is outside raster.");
            }
            if (subImage.y < 0 || subImage.y >= height) {
                throw new ImagingException("Subimage y is outside raster.");
            }
            if (subImage.y + subImage.height > height) {
                throw new ImagingException("Subimage (y+height) is outside raster.");
            }
        }
        int samplesPerPixel = 1;
        TiffField samplesPerPixelField = directory.findField(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        if (samplesPerPixelField != null) {
            samplesPerPixel = samplesPerPixelField.getIntValue();
        }
        int[] bitsPerSample = new int[]{1};
        int bitsPerPixel = samplesPerPixel;
        TiffField bitsPerSampleField = directory.findField(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
        if (bitsPerSampleField != null) {
            bitsPerSample = bitsPerSampleField.getIntArrayValue();
            bitsPerPixel = bitsPerSampleField.getIntValueOrArraySum();
        }
        int predictor = -1;
        TiffField tiffField = directory.findField(TiffTagConstants.TIFF_TAG_PREDICTOR);
        if (tiffField != null) {
            predictor = tiffField.getIntValueOrArraySum();
        }
        if (samplesPerPixel != bitsPerSample.length) {
            throw new ImagingException("Tiff: samplesPerPixel (" + samplesPerPixel + ")!=fBitsPerSample.length (" + bitsPerSample.length + ")");
        }
        boolean bl = 0xFFFF & directory.getFieldValue(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        if (bl && samplesPerPixel == 4) {
            TiffField extraSamplesField = directory.findField(TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES);
            if (extraSamplesField == null) {
                hasAlpha = true;
                isAlphaPremultiplied = false;
            } else {
                n3 = extraSamplesField.getIntValue();
                switch (n3) {
                    case 2: {
                        hasAlpha = true;
                        isAlphaPremultiplied = false;
                        break;
                    }
                    case 1: {
                        hasAlpha = true;
                        isAlphaPremultiplied = true;
                        break;
                    }
                    default: {
                        hasAlpha = false;
                        isAlphaPremultiplied = false;
                    }
                }
            }
        }
        if ((photometricInterpreter32 = params2222 == null ? null : params2222.getCustomPhotometricInterpreter()) == null) {
            PhotometricInterpreter photometricInterpreter;
            int n5 = height;
            int n6 = width;
            n = samplesPerPixel;
            n2 = predictor;
            int[] nArray = bitsPerSample;
            n3 = bitsPerPixel;
            boolean params2222 = bl;
            photometricInterpreter32 = directory;
            switch (params2222) {
                case 0: 
                case 1: {
                    params2222 = !params2222;
                    photometricInterpreter = new PhotometricInterpreterBiLevel(n, nArray, n2, n6, n5, params2222);
                    break;
                }
                case 3: {
                    int[] params2222 = ((TiffDirectory)photometricInterpreter32).findField(TiffTagConstants.TIFF_TAG_COLOR_MAP, true).getIntArrayValue();
                    int photometricInterpreter32 = 3 * (1 << n3);
                    if (params2222.length != photometricInterpreter32) {
                        throw new ImagingException("Tiff: fColorMap.length (" + params2222.length + ") != expectedColormapSize (" + photometricInterpreter32 + ")");
                    }
                    photometricInterpreter = new PhotometricInterpreterPalette(n, nArray, n2, n6, n5, params2222);
                    break;
                }
                case 2: {
                    photometricInterpreter = new PhotometricInterpreterRgb(n, nArray, n2, n6, n5);
                    break;
                }
                case 5: {
                    photometricInterpreter = new PhotometricInterpreterCmyk(n, nArray, n2, n6, n5);
                    break;
                }
                case 6: {
                    photometricInterpreter = new PhotometricInterpreterYCbCr(n, nArray, n2, n6, n5);
                    break;
                }
                case 8: {
                    photometricInterpreter = new PhotometricInterpreterCieLab(n, nArray, n2, n6, n5);
                    break;
                }
                case 32844: 
                case 32845: {
                    photometricInterpreter = new PhotometricInterpreterLogLuv(n, nArray, n2, n6, n5);
                    break;
                }
                default: {
                    throw new ImagingException("TIFF: Unknown fPhotometricInterpretation: " + (int)(params2222 ? 1 : 0));
                }
            }
            photometricInterpreter32 = photometricInterpreter;
        }
        if ((planarConfiguration = (pcField = directory.findField(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION)) == null ? TiffPlanarConfiguration.CHUNKY : TiffPlanarConfiguration.lenientValueOf(pcField.getIntValue())) == TiffPlanarConfiguration.PLANAR) {
            if (!bl || bitsPerPixel != 24) {
                throw new ImagingException("For planar configuration 2, only 24 bit RGB is currently supported");
            }
            if (null == directory.findField(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS)) {
                throw new ImagingException("For planar configuration 2, only strips-organization is supported");
            }
        }
        AbstractTiffImageData abstractTiffImageData = directory.getTiffImageData();
        object = abstractTiffImageData.getDataReader((TiffDirectory)object, (PhotometricInterpreter)photometricInterpreter32, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, (TiffPlanarConfiguration)var3_3, (ByteOrder)var2_2);
        object = ((ImageDataReader)object).readImageData(subImage, hasAlpha, isAlphaPremultiplied);
        return ((ImageBuilder)object).getBufferedImage();
    }
}

