/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.tiff.TiffTags;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class TiffField {
    private static final Logger LOGGER = Logger.getLogger(TiffField.class.getName());
    private final TagInfo tagInfo;
    private final int tag;
    private final int directoryType;
    private final AbstractFieldType abstractFieldType;
    private final long count;
    private final long offset;
    private final byte[] value;
    private final ByteOrder byteOrder;
    private final int sortHint;

    /*
     * WARNING - void declaration
     */
    public TiffField(int tag, int directoryType, AbstractFieldType abstractFieldType, long count, long offset, byte[] value, ByteOrder byteOrder, int sortHint) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.tag = tag;
        this.directoryType = directoryType;
        this.abstractFieldType = var3_3;
        this.count = count;
        this.offset = offset;
        this.value = value;
        this.byteOrder = byteOrder;
        this.sortHint = sortHint;
        this.tagInfo = TiffTags.getTag((int)var2_2, (int)var1_1);
    }

    public final byte[] getByteArrayValue() {
        TiffField tiffField = this;
        return BinaryFunctions.head(this.value, (int)tiffField.count * tiffField.abstractFieldType.getSize());
    }

    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public final long getCount() {
        return this.count;
    }

    public final String getDescriptionWithoutValue() {
        TiffField tiffField = this;
        TiffField tiffField2 = tiffField;
        TiffField tiffField3 = this;
        tiffField2 = tiffField3;
        tiffField2 = this;
        return tiffField.tag + " (0x" + Integer.toHexString(tiffField3.tag) + ": " + tiffField2.tagInfo.name + "): ";
    }

    public final int getDirectoryType() {
        return this.directoryType;
    }

    public final AbstractFieldType getFieldType() {
        return this.abstractFieldType;
    }

    /*
     * WARNING - void declaration
     */
    public final int[] getIntArrayValue() throws ImagingException {
        TiffField tiffField;
        Object[] numbers;
        Object o = this.getValue();
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            numbers = (Number[])o;
            int[] result = Allocator.intArray(numbers.length);
            Arrays.setAll(result, arg_0 -> TiffField.lambda$getIntArrayValue$4((Number[])numbers, arg_0));
            return result;
        }
        if (numbers instanceof short[]) {
            short[] sArray = (short[])numbers;
            numbers = sArray;
            int[] result = Allocator.intArray(sArray.length);
            Arrays.setAll(result, arg_0 -> TiffField.lambda$getIntArrayValue$5((short[])numbers, arg_0));
            return result;
        }
        if (numbers instanceof int[]) {
            int[] nArray = (int[])numbers;
            numbers = nArray;
            return Arrays.copyOf(nArray, numbers.length);
        }
        if (numbers instanceof long[]) {
            void var2_4;
            long[] lArray = (long[])numbers;
            numbers = lArray;
            int[] iNumbers = new int[lArray.length];
            for (int i = 0; i < iNumbers.length; ++i) {
                iNumbers[i] = (int)numbers[i];
            }
            return var2_4;
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown value: ").append(tiffField).append(" for: ");
        tiffField = this;
        throw new ImagingException(stringBuilder.append(tiffField.tagInfo.getDescription()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final int getIntValue() throws ImagingException {
        void var1_1;
        Object o = this.getValue();
        if (o == null) {
            o = this;
            throw new ImagingException("Missing value: " + ((TiffField)o).tagInfo.getDescription());
        }
        return ((Number)var1_1).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int getIntValueOrArraySum() throws ImagingException {
        Object tiffField = this.getValue();
        if (tiffField instanceof Number) {
            return ((Number)tiffField).intValue();
        }
        if (tiffField instanceof Number[]) {
            Number[] numberArray = (Number[])tiffField;
            int sum = 0;
            Number[] numberArray2 = numberArray;
            int n = numberArray.length;
            for (int i = 0; i < n; ++i) {
                Number number = numberArray2[i];
                sum += number.intValue();
            }
            return sum;
        }
        if (tiffField instanceof short[]) {
            short[] sArray = (short[])tiffField;
            int sum = 0;
            short[] sArray2 = sArray;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                short number = sArray2[i];
                sum += number;
            }
            return sum;
        }
        if (tiffField instanceof int[]) {
            void var2_11;
            int[] nArray = (int[])tiffField;
            int sum = 0;
            int[] nArray2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int number = nArray2[i];
                sum += number;
            }
            return (int)var2_11;
        }
        TiffField tiffField2 = this;
        throw new ImagingException("Unknown value: " + tiffField + " for: " + tiffField2.tagInfo.getDescription());
    }

    /*
     * WARNING - void declaration
     */
    public final long[] getLongArrayValue() throws ImagingException {
        TiffField tiffField;
        Object[] numbers;
        Object o = this.getValue();
        if (o instanceof Number) {
            return new long[]{((Number)o).longValue()};
        }
        if (o instanceof Number[]) {
            numbers = (Number[])o;
            long[] result = Allocator.longArray(numbers.length);
            Arrays.setAll(result, arg_0 -> TiffField.lambda$getLongArrayValue$6((Number[])numbers, arg_0));
            return result;
        }
        if (numbers instanceof short[]) {
            short[] sArray = (short[])numbers;
            numbers = sArray;
            long[] result = Allocator.longArray(sArray.length);
            Arrays.setAll(result, arg_0 -> TiffField.lambda$getLongArrayValue$7((short[])numbers, arg_0));
            return result;
        }
        if (numbers instanceof int[]) {
            void var2_4;
            int[] nArray = (int[])numbers;
            numbers = nArray;
            long[] result = Allocator.longArray(nArray.length);
            Arrays.setAll(result, arg_0 -> TiffField.lambda$getLongArrayValue$8((int[])numbers, arg_0));
            return var2_4;
        }
        if (numbers instanceof long[]) {
            long[] lArray = (long[])numbers;
            numbers = lArray;
            return Arrays.copyOf(lArray, ((void)tiffField).length);
        }
        StringBuilder stringBuilder = new StringBuilder("Unknown value: ").append(tiffField).append(" for: ");
        tiffField = this;
        throw new ImagingException(stringBuilder.append(tiffField.tagInfo.getDescription()).toString());
    }

    public final int getTag() {
        return this.tag;
    }

    private Object getValue() throws ImagingException {
        TiffField tiffField = this;
        return tiffField.tagInfo.getValue(this);
    }

    /*
     * WARNING - void declaration
     */
    private String getValueDescription() {
        try {
            Object object = this.getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                return object.toString();
            }
            if (object instanceof String) {
                return "'" + object.toString().trim() + "'";
            }
            if (object instanceof Date) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);
                return simpleDateFormat.format((Date)object);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                object = new StringBuilder();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(objectArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(object2.toString());
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                object = new StringBuilder();
                for (int i = 0; i < sArray.length; ++i) {
                    short s = sArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(sArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(s);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                object = new StringBuilder();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(nArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(n);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                object = new StringBuilder();
                for (int i = 0; i < lArray.length; ++i) {
                    long l = lArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(lArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(l);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                object = new StringBuilder();
                for (int i = 0; i < dArray.length; ++i) {
                    double d = dArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(dArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(d);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                object = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(byArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(by);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                object = new StringBuilder();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(cArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(c);
                }
                return ((StringBuilder)object).toString();
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                object = new StringBuilder();
                for (int i = 0; i < fArray.length; ++i) {
                    float f = fArray[i];
                    if (i > 50) {
                        ((StringBuilder)object).append("... (").append(fArray.length).append(")");
                        break;
                    }
                    if (i > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append(f);
                }
                return ((StringBuilder)object).toString();
            }
            return "Unknown: " + object.getClass().getName();
        }
        catch (ImagingException e) {
            void var1_2;
            return "Invalid value: " + var1_2.getMessage();
        }
    }

    public String toString() {
        TiffField tiffField = this;
        TiffField tiffField2 = tiffField;
        TiffField tiffField3 = this;
        tiffField2 = tiffField3;
        TiffField tiffField4 = this;
        tiffField2 = tiffField4;
        TiffField tiffField5 = this;
        tiffField2 = tiffField5;
        tiffField2 = this;
        return tiffField.tag + " (0x" + Integer.toHexString(tiffField3.tag) + ": " + tiffField4.tagInfo.name + "): " + this.getValueDescription() + " (" + tiffField5.count + " " + tiffField2.abstractFieldType.getName() + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$getLongArrayValue$8(int[] numbers, int i) {
        void var1_1;
        int[] nArray;
        return 0xFFFFFFFFL & (long)nArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$getLongArrayValue$7(short[] numbers, int i) {
        void var1_1;
        short[] sArray;
        return 0xFFFF & sArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$getLongArrayValue$6(Number[] numbers, int i) {
        void var1_1;
        return numbers[var1_1].longValue();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$getIntArrayValue$5(short[] numbers, int i) {
        void var1_1;
        short[] sArray;
        return 0xFFFF & sArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$getIntArrayValue$4(Number[] numbers, int i) {
        void var1_1;
        return numbers[var1_1].intValue();
    }
}

