/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDirectory;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShort;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoShortOrLong;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoUndefineds;

public final class TiffDirectory
extends AbstractTiffElement
implements Iterable<TiffField> {
    private final List<TiffField> entries;
    private final ByteOrder headerByteOrder;
    private JpegImageData jpegImageData;
    private final long nextDirectoryOffset;
    private AbstractTiffImageData abstractTiffImageData;
    public final int type;

    /*
     * WARNING - void declaration
     */
    public TiffDirectory(int type, List<TiffField> entries, long offset, long nextDirectoryOffset, ByteOrder byteOrder) {
        super((long)var3_3, 2 + entries.size() * 12 + 4);
        void var2_2;
        void var1_1;
        void var3_3;
        this.type = var1_1;
        this.entries = Collections.unmodifiableList(var2_2);
        this.nextDirectoryOffset = nextDirectoryOffset;
        this.headerByteOrder = byteOrder;
    }

    /*
     * WARNING - void declaration
     */
    public final TiffField findField(TagInfo tag) throws ImagingException {
        void var1_1;
        return this.findField((TagInfo)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final TiffField findField(TagInfo tag, boolean failIfMissing) throws ImagingException {
        void var2_2;
        for (TiffField field : this.entries) {
            if (field.getTag() != tag.tag) continue;
            return field;
        }
        if (var2_2 != false) {
            void var1_1;
            throw new ImagingException("Missing expected field: " + var1_1.getDescription());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] getFieldValue$6c63a701(TagInfoUndefineds tag, boolean mustExist2) throws ImagingException {
        void var2_3;
        void var1_1;
        TiffDirectory mustExist2 = this;
        TagInfoUndefineds tagInfoUndefineds = tag;
        TiffField field = mustExist2.findField(tagInfoUndefineds, false);
        if (field == null) {
            return null;
        }
        if (!var1_1.dataTypes.contains(field.getFieldType())) {
            return null;
        }
        return var2_3.getByteArrayValue();
    }

    public final int getFieldValue$611ae69c(TagInfoDirectory tag) throws ImagingException {
        ByteOrder byteOrder;
        TiffDirectory tiffDirectory = this;
        Object object = tag;
        TiffField field = tiffDirectory.findField((TagInfo)object, false);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        ByteOrder byteOrder2 = ((TiffField)((Object)tiffDirectory)).getByteOrder();
        tiffDirectory = byteOrder;
        byteOrder = byteOrder2;
        object = byteOrder;
        return ByteConversions.toInt((byte[])tiffDirectory, 0, (ByteOrder)object);
    }

    public final short getFieldValue(TagInfoShort tag) throws ImagingException {
        ByteOrder byteOrder;
        TiffDirectory tiffDirectory = this;
        TagInfoShort tagInfoShort = tag;
        TiffField field = tiffDirectory.findField(tagInfoShort, false);
        if (field == null) {
            throw new ImagingException("Required field \"" + tag.name + "\" is missing");
        }
        if (!tag.dataTypes.contains(field.getFieldType())) {
            throw new ImagingException("Required field \"" + tag.name + "\" has incorrect type " + field.getFieldType().getName());
        }
        if (field.getCount() != 1L) {
            throw new ImagingException("Field \"" + tag.name + "\" has wrong count " + field.getCount());
        }
        byte[] bytes = field.getByteArrayValue();
        ByteOrder byteOrder2 = ((TiffField)((Object)tiffDirectory)).getByteOrder();
        tiffDirectory = byteOrder;
        byteOrder = byteOrder2;
        return ByteConversions.toShort((byte[])tiffDirectory, byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public final ImageDataElement getJpegRawImageDataElement() throws ImagingException {
        TagInfoLong tagInfoLong = TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT;
        TiffDirectory tiffDirectory = this;
        TiffField jpegInterchangeFormat = tiffDirectory.findField(tagInfoLong, false);
        tagInfoLong = TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH;
        tiffDirectory = this;
        TiffField jpegInterchangeFormatLength = tiffDirectory.findField(tagInfoLong, false);
        if (jpegInterchangeFormat != null && jpegInterchangeFormatLength != null) {
            void var2_3;
            void var1_5;
            int offSet = jpegInterchangeFormat.getIntArrayValue()[0];
            int byteCount = jpegInterchangeFormatLength.getIntArrayValue()[0];
            return new ImageDataElement((long)var1_5, (int)var2_3);
        }
        throw new ImagingException("Couldn't find image data.");
    }

    public final long getNextDirectoryOffset() {
        return this.nextDirectoryOffset;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ImageDataElement> getRawImageDataElements(TiffField offsetsField, TiffField byteCountsField) throws ImagingException {
        void var2_2;
        int[] byteCounts;
        Object offsets = offsetsField.getLongArrayValue();
        if (((Object)offsets).length != (byteCounts = byteCountsField.getIntArrayValue()).length) {
            throw new ImagingException("offsets.length(" + ((Object)offsets).length + ") != byteCounts.length(" + byteCounts.length + ")");
        }
        ArrayList result = Allocator.arrayList(((Object)offsets).length);
        for (int i = 0; i < ((Object)offsets).length; ++i) {
            result.add(new ImageDataElement((long)offsets[i], byteCounts[i]));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSingleFieldValue(TagInfoShortOrLong tag) throws ImagingException {
        TiffDirectory tiffDirectory = this;
        boolean bl = true;
        Object object = tag;
        Object object2 = tiffDirectory;
        TagInfoShortOrLong tagInfoShortOrLong = object;
        object2 = tiffDirectory;
        object2 = tiffDirectory.findField(tagInfoShortOrLong, false);
        if (object2 == null) {
            throw new ImagingException("Required field \"" + ((TagInfoShortOrLong)object).name + "\" is missing");
        }
        if (!((TagInfoShortOrLong)object).dataTypes.contains(((TiffField)object2).getFieldType())) {
            throw new ImagingException("Required field \"" + ((TagInfoShortOrLong)object).name + "\" has incorrect type " + ((TiffField)object2).getFieldType().getName());
        }
        object = ((TiffField)object2).getByteArrayValue();
        int[] result = ((TiffField)object2).getFieldType() == AbstractFieldType.SHORT ? ByteConversions.toUInt16s((byte[])object, ((TiffField)object2).getByteOrder()) : ByteConversions.toInts((byte[])object, ((TiffField)object2).getByteOrder());
        if (result.length != 1) {
            void var1_1;
            throw new ImagingException("Field \"" + var1_1.name + "\" has incorrect length " + result.length);
        }
        return (int)object2[0];
    }

    /*
     * WARNING - void declaration
     */
    public final BufferedImage getTiffImage(ByteOrder byteOrder, TiffImagingParameters params) throws ImagingException, IOException {
        void var2_2;
        void var1_1;
        if (this.abstractTiffImageData == null) {
            return null;
        }
        return new TiffImageParser().getBufferedImage(this, (ByteOrder)var1_1, (TiffImagingParameters)var2_2);
    }

    public final AbstractTiffImageData getTiffImageData() {
        return this.abstractTiffImageData;
    }

    /*
     * WARNING - void declaration
     */
    public final List<ImageDataElement> getTiffRawImageDataElements() throws ImagingException {
        TagInfo tagInfo = TiffTagConstants.TIFF_TAG_TILE_OFFSETS;
        TiffDirectory tiffDirectory = this;
        TiffField tileOffsets = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS;
        tiffDirectory = this;
        TiffField tileByteCounts = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_STRIP_OFFSETS;
        tiffDirectory = this;
        TiffField stripOffsets = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS;
        tiffDirectory = this;
        TiffField stripByteCounts = tiffDirectory.findField(tagInfo, false);
        if (tileOffsets != null && tileByteCounts != null) {
            void var2_4;
            void var1_3;
            return TiffDirectory.getRawImageDataElements((TiffField)var1_3, (TiffField)var2_4);
        }
        if (stripOffsets != null && stripByteCounts != null) {
            void var3_5;
            return TiffDirectory.getRawImageDataElements((TiffField)var3_5, stripByteCounts);
        }
        throw new ImagingException("Couldn't find image data.");
    }

    public final boolean hasJpegImageData() throws ImagingException {
        TiffDirectory tiffDirectory = this;
        TagInfoLong tagInfoLong = TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT;
        return null != tiffDirectory.findField(tagInfoLong, false);
    }

    public final boolean hasTiffImageData() throws ImagingException {
        TiffDirectory tiffDirectory = this;
        TagInfo tagInfo = TiffTagConstants.TIFF_TAG_TILE_OFFSETS;
        if (null != tiffDirectory.findField(tagInfo, false)) {
            return true;
        }
        tiffDirectory = this;
        tagInfo = TiffTagConstants.TIFF_TAG_STRIP_OFFSETS;
        return null != tiffDirectory.findField(tagInfo, false);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean imageDataInStrips() throws ImagingException {
        void var3_5;
        void var2_4;
        void var1_3;
        TagInfo tagInfo = TiffTagConstants.TIFF_TAG_TILE_OFFSETS;
        TiffDirectory tiffDirectory = this;
        TiffField tileOffsets = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_TILE_BYTE_COUNTS;
        tiffDirectory = this;
        TiffField tileByteCounts = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_STRIP_OFFSETS;
        tiffDirectory = this;
        TiffField stripOffsets = tiffDirectory.findField(tagInfo, false);
        tagInfo = TiffTagConstants.TIFF_TAG_STRIP_BYTE_COUNTS;
        tiffDirectory = this;
        TiffField stripByteCounts = tiffDirectory.findField(tagInfo, false);
        if (var1_3 != null && var2_4 != null) {
            return false;
        }
        if (var3_5 != null && stripByteCounts != null) {
            return true;
        }
        throw new ImagingException("Couldn't find image data.");
    }

    @Override
    public final Iterator<TiffField> iterator() {
        return this.entries.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final void setJpegImageData(JpegImageData value) {
        void var1_1;
        this.jpegImageData = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTiffImageData(AbstractTiffImageData rawImageData) {
        void var1_1;
        this.abstractTiffImageData = var1_1;
    }

    public static final class ImageDataElement
    extends AbstractTiffElement {
        /*
         * WARNING - void declaration
         */
        public ImageDataElement(long offset, int length) {
            super((long)var1_1, (int)var3_2);
            void var3_2;
            void var1_1;
        }
    }
}

