/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.IOException;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.rgbe.RgbeImagingParameters;
import org.apache.commons.imaging.formats.rgbe.RgbeInfo;

public final class RgbeImageParser
extends AbstractImageParser<RgbeImagingParameters> {
    @Override
    protected final String[] getAcceptedExtensions() {
        return ImageFormats.RGBE.getExtensions();
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.RGBE};
    }

    /*
     * WARNING - void declaration
     */
    private static BufferedImage getBufferedImage$20f4dffd(ByteSource byteSource) throws ImagingException, IOException {
        BufferedImage bufferedImage;
        RgbeInfo info = new RgbeInfo(byteSource);
        try {
            void var1_1;
            DataBufferFloat buffer = new DataBufferFloat(info.getPixelData(), info.getWidth() * info.getHeight());
            bufferedImage = new BufferedImage(new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, buffer.getDataType()), Raster.createWritableRaster(new BandedSampleModel(buffer.getDataType(), info.getWidth(), info.getHeight(), 3), (DataBuffer)var1_1, new Point()), false, null);
        }
        catch (Throwable throwable) {
            try {
                RgbeInfo rgbeInfo;
                rgbeInfo.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        info.close();
        return bufferedImage;
    }
}

