/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;
import org.apache.commons.imaging.formats.psd.PsdImageContents;
import org.apache.commons.imaging.formats.psd.PsdImageParser;
import org.apache.commons.imaging.formats.psd.dataparsers.DataParser;
import org.apache.commons.imaging.formats.psd.datareaders.DataReader;
import org.apache.commons.imaging.mylzw.BitsToByteInputStream;
import org.apache.commons.imaging.mylzw.MyBitInputStream;

public final class UncompressedDataReader
implements DataReader {
    private final DataParser dataParser;

    /*
     * WARNING - void declaration
     */
    public UncompressedDataReader(DataParser dataParser) {
        void var1_1;
        this.dataParser = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readData$7f865488(InputStream is, BufferedImage bi, PsdImageContents imageContents, PsdImageParser bfp) throws ImagingException, IOException {
        PsdHeaderInfo header = imageContents.header;
        int width = header.columns;
        int height = header.rows;
        int channelCount = this.dataParser.getBasicChannelsCount();
        int depth = header.depth;
        MyBitInputStream mbis = new MyBitInputStream(is, ByteOrder.BIG_ENDIAN, false);
        BitsToByteInputStream bbis = new BitsToByteInputStream(mbis, 8);
        try {
            void var3_3;
            void var2_2;
            int[][][] data = new int[Allocator.check(channelCount)][Allocator.check(height)][Allocator.check(width)];
            for (int channel = 0; channel < channelCount; ++channel) {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int b = bbis.readBits(depth);
                        data[channel][y][x] = (byte)b;
                    }
                }
            }
            this.dataParser.parseData(data, (BufferedImage)var2_2, (PsdImageContents)var3_3);
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        bbis.close();
    }
}

