/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

final class PbmFileInfo
extends AbstractFileInfo {
    private int bitCache;
    private int bitsInCache;

    /*
     * WARNING - void declaration
     */
    PbmFileInfo(int width, int height, boolean rawbits) {
        super((int)var1_1, (int)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(InputStream is) throws IOException {
        void var1_3;
        if (this.bitsInCache <= 0) {
            int bits = is.read();
            if (bits < 0) {
                throw new ImagingException("PBM: Unexpected EOF");
            }
            this.bitCache = 0xFF & bits;
            this.bitsInCache += 8;
        }
        int bit = 1 & this.bitCache >> 7;
        this.bitCache <<= 1;
        --this.bitsInCache;
        if (bit == 0) {
            return -1;
        }
        if (bit == 1) {
            return -16777216;
        }
        throw new ImagingException("PBM: bad bit: " + (int)var1_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(WhiteSpaceReader wsr) throws IOException {
        void var1_2;
        int bit = Integer.parseInt(wsr.readtoWhiteSpace());
        if (bit == 0) {
            return -16777216;
        }
        if (bit == 1) {
            return -1;
        }
        throw new ImagingException("PBM: bad bit: " + (int)var1_2);
    }

    @Override
    public final boolean hasAlpha() {
        return false;
    }

    @Override
    protected final void newline() {
        this.bitCache = 0;
        this.bitsInCache = 0;
    }
}

