/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.pnm.AbstractFileInfo;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

final class PamFileInfo
extends AbstractFileInfo {
    private final int depth;
    private final int maxval;
    private final float scale;
    private final int bytesPerSample;
    private final boolean hasAlpha;
    private final TupleReader tupleReader;

    /*
     * WARNING - void declaration
     */
    PamFileInfo(int width, int height, int depth, int maxval, String tupleType) throws ImagingException {
        super((int)var1_1, n, true);
        void var3_4;
        int n;
        void var1_1;
        this.depth = var3_4;
        this.maxval = maxval;
        if (maxval <= 0) {
            throw new ImagingException("PAM maxVal " + maxval + " is out of range [1;65535]");
        }
        if (maxval <= 255) {
            this.scale = 255.0f;
            this.bytesPerSample = 1;
        } else if (maxval <= 65535) {
            this.scale = 65535.0f;
            this.bytesPerSample = 2;
        } else {
            throw new ImagingException("PAM maxVal " + maxval + " is out of range [1;65535]");
        }
        this.hasAlpha = tupleType.endsWith("_ALPHA");
        switch (tupleType) {
            case "BLACKANDWHITE": 
            case "BLACKANDWHITE_ALPHA": {
                this.tupleReader = new GrayscaleTupleReader(ImageInfo.ColorType.BW);
                return;
            }
            case "GRAYSCALE": 
            case "GRAYSCALE_ALPHA": {
                this.tupleReader = new GrayscaleTupleReader(ImageInfo.ColorType.GRAYSCALE);
                return;
            }
            case "RGB": 
            case "RGB_ALPHA": {
                this.tupleReader = new ColorTupleReader(0);
                return;
            }
        }
        throw new ImagingException("Unknown PAM tupletype '" + tupleType + "'");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getRgb(InputStream is) throws IOException {
        void var1_1;
        return this.tupleReader.getRgb((InputStream)var1_1);
    }

    @Override
    public final int getRgb(WhiteSpaceReader wsr) throws IOException {
        throw new UnsupportedOperationException("PAM files are only ever binary");
    }

    @Override
    public final boolean hasAlpha() {
        return this.hasAlpha;
    }

    private final class GrayscaleTupleReader
    extends TupleReader {
        private final ImageInfo.ColorType colorType;

        /*
         * WARNING - void declaration
         */
        GrayscaleTupleReader(ImageInfo.ColorType colorType) {
            void var2_2;
            super((byte)0);
            this.colorType = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getRgb(InputStream is) throws IOException {
            void var3_3;
            int n = AbstractFileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            int sample = AbstractFileInfo.scaleSample(n, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            int alpha = 255;
            if (PamFileInfo.this.hasAlpha) {
                void var1_1;
                alpha = AbstractFileInfo.readSample((InputStream)var1_1, PamFileInfo.this.bytesPerSample);
                alpha = AbstractFileInfo.scaleSample(alpha, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            }
            return (0xFF & var3_3) << 24 | (0xFF & sample) << 16 | (0xFF & sample) << 8 | (0xFF & n) << 0;
        }
    }

    private static abstract class TupleReader {
        private TupleReader() {
        }

        public abstract int getRgb(InputStream var1) throws IOException;

        /* synthetic */ TupleReader(byte by) {
            this();
        }
    }

    private final class ColorTupleReader
    extends TupleReader {
        private ColorTupleReader() {
            super((byte)0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int getRgb(InputStream is) throws IOException {
            void var3_3;
            void var2_2;
            int red = AbstractFileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            int green = AbstractFileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            int blue = AbstractFileInfo.readSample(is, PamFileInfo.this.bytesPerSample);
            red = AbstractFileInfo.scaleSample(red, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            green = AbstractFileInfo.scaleSample(green, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            blue = AbstractFileInfo.scaleSample(blue, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            int alpha = 255;
            if (PamFileInfo.this.hasAlpha) {
                void var1_1;
                alpha = AbstractFileInfo.readSample((InputStream)var1_1, PamFileInfo.this.bytesPerSample);
                alpha = AbstractFileInfo.scaleSample(alpha, PamFileInfo.this.scale, PamFileInfo.this.maxval);
            }
            return (0xFF & alpha) << 24 | (0xFF & var2_2) << 16 | (0xFF & var3_3) << 8 | (0xFF & blue) << 0;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ColorTupleReader(byte by) {
            this();
            void var1_1;
        }
    }
}

