/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

abstract class AbstractFileInfo {
    final int width;
    final int height;
    final boolean rawBits;

    /*
     * WARNING - void declaration
     */
    static int readSample(InputStream is, int bytesPerSample) throws IOException {
        void var2_2;
        int sample = 0;
        for (int i = 0; i < bytesPerSample; ++i) {
            int nextByte = is.read();
            if (nextByte < 0) {
                throw new ImagingException("PNM: Unexpected EOF");
            }
            sample <<= 8;
            sample |= nextByte;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int scaleSample(int sample, float scale, int max) throws ImagingException {
        void var2_2;
        void var1_1;
        int n;
        if (sample < 0) {
            throw new ImagingException("Negative pixel values are invalid in PNM files");
        }
        if (sample > max) {
            sample = 0;
        }
        return (int)((float)n * var1_1 / (float)var2_2 + 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    AbstractFileInfo(int width, int height, boolean rawBits) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
        this.rawBits = var3_3;
    }

    abstract int getRgb(InputStream var1) throws IOException;

    abstract int getRgb(WhiteSpaceReader var1) throws IOException;

    abstract boolean hasAlpha();

    void newline() {
    }
}

