/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.scanlinefilters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.png.scanlinefilters.ScanlineFilter;

public final class ScanlineFilterPaeth
implements ScanlineFilter {
    private final int bytesPerPixel;

    /*
     * WARNING - void declaration
     */
    public ScanlineFilterPaeth(int bytesPerPixel) {
        void var1_1;
        this.bytesPerPixel = var1_1;
    }

    @Override
    public final void unfilter(byte[] src, byte[] dst, byte[] up) throws ImagingException, IOException {
        for (int i = 0; i < src.length; ++i) {
            int left = 0;
            int prevIndex = i - this.bytesPerPixel;
            if (prevIndex >= 0) {
                left = dst[prevIndex];
            }
            byte above = 0;
            if (up != null) {
                above = up[i];
            }
            byte upperLeft = 0;
            if (prevIndex >= 0 && up != null) {
                upperLeft = up[prevIndex];
            }
            int n = 0xFF & upperLeft;
            int n2 = 0xFF & above;
            left = 0xFF & left;
            int n3 = left + n2 - n;
            int n4 = Math.abs(n3 - left);
            int n5 = Math.abs(n3 - n2);
            n3 = Math.abs(n3 - n);
            int paethPredictor = n4 <= n5 && n4 <= n3 ? left : (n5 <= n3 ? n2 : n);
            dst[i] = (byte)((src[i] + paethPredictor) % 256);
        }
    }
}

