/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

public enum PngColorType {
    GREYSCALE(0, true, false, 1, new int[]{1, 2, 4, 8, 16}),
    TRUE_COLOR(2, false, false, 3, new int[]{8, 16}),
    INDEXED_COLOR(3, false, false, 1, new int[]{1, 2, 4, 8}),
    GREYSCALE_WITH_ALPHA(4, true, true, 2, new int[]{8, 16}),
    TRUE_COLOR_WITH_ALPHA(6, false, true, 4, new int[]{8, 16});

    private final int value;
    private final boolean greyscale;
    private final boolean alpha;
    private final int samplesPerPixel;
    private final int[] allowedBitDepths;

    public static PngColorType getColorType(int value) {
        for (PngColorType type : PngColorType.values()) {
            if (type.value != value) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private PngColorType(int value, boolean greyscale, boolean alpha, int samplesPerPixel, int[] allowedBitDepths) {
        void var3_3;
        this.value = var3_3;
        this.greyscale = greyscale;
        this.alpha = alpha;
        this.samplesPerPixel = samplesPerPixel;
        this.allowedBitDepths = allowedBitDepths;
    }

    final int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    final boolean hasAlpha() {
        return this.alpha;
    }

    final boolean isGreyscale() {
        return this.greyscale;
    }
}

