/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pcx;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.pcx.PcxImagingParameters;
import org.apache.commons.imaging.formats.pcx.RleReader;

public final class PcxImageParser
extends AbstractImageParser<PcxImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.PCX.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.PCX.getExtensions();

    public PcxImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.PCX};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, PcxImagingParameters params2) throws ImagingException, IOException {
        BufferedImage bufferedImage;
        block37: {
            if (params2 == null) {
                params2 = new PcxImagingParameters();
            }
            InputStream is = byteSource.getInputStream();
            try {
                BufferedImage bufferedImage2;
                Object object;
                RleReader rleReader;
                PcxImageParser pcxImageParser;
                boolean bl = ((ImagingParameters)params2).isStrict();
                InputStream inputStream = is;
                params2 = this;
                byte[] byArray = BinaryFunctions.readBytes("PcxHeader", inputStream, 128, "Not a Valid PCX File");
                int n = 0xFF & byArray[0];
                int n2 = 0xFF & byArray[1];
                int n3 = 0xFF & byArray[2];
                int n4 = 0xFF & byArray[3];
                int n5 = ByteConversions.toUInt16(byArray, 4, ((BinaryFileParser)params2).getByteOrder());
                int n6 = ByteConversions.toUInt16(byArray, 6, ((BinaryFileParser)params2).getByteOrder());
                int n7 = ByteConversions.toUInt16(byArray, 8, ((BinaryFileParser)params2).getByteOrder());
                int n8 = ByteConversions.toUInt16(byArray, 10, ((BinaryFileParser)params2).getByteOrder());
                int n9 = ByteConversions.toUInt16(byArray, 12, ((BinaryFileParser)params2).getByteOrder());
                int n10 = ByteConversions.toUInt16(byArray, 14, ((BinaryFileParser)params2).getByteOrder());
                Object object2 = new int[16];
                Arrays.setAll((int[])object2, i -> {
                    void var1_1;
                    byte[] byArray;
                    return 0xFF000000 | (0xFF & byArray[16 + 3 * i]) << 16 | (0xFF & byArray[16 + 3 * i + 1]) << 8 | 0xFF & byArray[16 + 3 * var1_1 + 2];
                });
                int n11 = 0xFF & byArray[64];
                int n12 = 0xFF & byArray[65];
                int n13 = ByteConversions.toUInt16(byArray, 66, ((BinaryFileParser)params2).getByteOrder());
                int n14 = ByteConversions.toUInt16(byArray, 68, ((BinaryFileParser)params2).getByteOrder());
                int n15 = ByteConversions.toUInt16(byArray, 70, ((BinaryFileParser)params2).getByteOrder());
                int params2 = ByteConversions.toUInt16(byArray, 72, ((BinaryFileParser)params2).getByteOrder());
                if (n != 10) {
                    throw new ImagingException("Not a Valid PCX File: manufacturer is " + n);
                }
                if (bl && n13 % 2 != 0) {
                    throw new ImagingException("Not a Valid PCX File: bytesPerLine is odd");
                }
                PcxHeader pcxHeader = new PcxHeader(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, (int[])object2, n11, n12, n13, n14, n15, params2);
                byArray = bufferedImage;
                InputStream inputStream2 = is;
                void var4_12 = pcxImageParser;
                pcxImageParser = this;
                n = var4_12.xMax - var4_12.xMin + 1;
                if (n < 0) {
                    throw new ImagingException("Image width is negative");
                }
                n2 = var4_12.yMax - var4_12.yMin + 1;
                if (n2 < 0) {
                    throw new ImagingException("Image height is negative");
                }
                if (var4_12.nPlanes <= 0 || 4 < var4_12.nPlanes) {
                    throw new ImagingException("Unsupported/invalid image with " + var4_12.nPlanes + " planes");
                }
                if (var4_12.encoding == 0) {
                    rleReader = new RleReader(false);
                } else if (var4_12.encoding == 1) {
                    rleReader = new RleReader(true);
                } else {
                    throw new ImagingException("Unsupported/invalid image encoding " + var4_12.encoding);
                }
                n4 = var4_12.bytesPerLine * var4_12.nPlanes;
                byte[] byArray2 = Allocator.byteArray(n4);
                if ((var4_12.bitsPerPixel == 1 || var4_12.bitsPerPixel == 2 || var4_12.bitsPerPixel == 4 || var4_12.bitsPerPixel == 8) && var4_12.nPlanes == 1) {
                    int[] nArray;
                    n6 = (n * var4_12.bitsPerPixel + 7) / 8;
                    byte[] byArray3 = Allocator.byteArray(n2 * n6);
                    for (n8 = 0; n8 < n2; ++n8) {
                        rleReader.read(inputStream2, byArray2);
                        System.arraycopy(byArray2, 0, byArray3, n8 * n6, n6);
                    }
                    object = new DataBufferByte(byArray3, byArray3.length);
                    if (var4_12.bitsPerPixel == 1) {
                        nArray = new int[]{0, 0xFFFFFF};
                    } else if (var4_12.bitsPerPixel == 8) {
                        nArray = PcxImageParser.read256ColorPalette(inputStream2);
                        if (nArray == null) {
                            nArray = pcxImageParser.read256ColorPaletteFromEndOfFile((ByteSource)byArray);
                        }
                        if (nArray == null) {
                            throw new ImagingException("No 256 color palette found in image that needs it");
                        }
                    } else {
                        nArray = var4_12.colormap;
                    }
                    WritableRaster writableRaster = var4_12.bitsPerPixel == 8 ? Raster.createInterleavedRaster((DataBuffer)object, n, n2, n6, 1, new int[]{0}, null) : Raster.createPackedRaster((DataBuffer)object, n, n2, var4_12.bitsPerPixel, null);
                    object2 = new IndexColorModel(var4_12.bitsPerPixel, 1 << var4_12.bitsPerPixel, nArray, 0, false, -1, 0);
                    bufferedImage2 = new BufferedImage((ColorModel)object2, writableRaster, ((ColorModel)object2).isAlphaPremultiplied(), new Properties());
                } else if (var4_12.bitsPerPixel == 1 && 2 <= var4_12.nPlanes && var4_12.nPlanes <= 4) {
                    IndexColorModel indexColorModel = new IndexColorModel(var4_12.nPlanes, 1 << var4_12.nPlanes, var4_12.colormap, 0, false, -1, 0);
                    BufferedImage bufferedImage3 = new BufferedImage(n, n2, 12, indexColorModel);
                    object = Allocator.byteArray(n);
                    for (n9 = 0; n9 < n2; ++n9) {
                        rleReader.read(inputStream2, byArray2);
                        n10 = 0;
                        Arrays.fill((byte[])object, (byte)0);
                        for (int j = 0; j < var4_12.nPlanes; ++j) {
                            for (n11 = 0; n11 < var4_12.bytesPerLine; ++n11) {
                                n12 = 0xFF & byArray2[n10++];
                                for (n13 = 0; n13 < 8 && 8 * n11 + n13 < ((Object)object).length; ++n13) {
                                    Object object3 = object;
                                    int n16 = 8 * n11 + n13;
                                    object3[n16] = (byte)(object3[n16] | (byte)((n12 >> 7 - n13 & 1) << j));
                                }
                            }
                        }
                        bufferedImage3.getRaster().setDataElements(0, n9, n, 1, object);
                    }
                    bufferedImage2 = bufferedImage3;
                } else if (var4_12.bitsPerPixel == 8 && var4_12.nPlanes == 3) {
                    byte[][] byArrayArray = new byte[3][];
                    n7 = n * n2;
                    byArrayArray[0] = Allocator.byteArray(n7);
                    byArrayArray[1] = Allocator.byteArray(n7);
                    byArrayArray[2] = Allocator.byteArray(n7);
                    for (n8 = 0; n8 < n2; ++n8) {
                        rleReader.read(inputStream2, byArray2);
                        System.arraycopy(byArray2, 0, byArrayArray[0], n8 * n, n);
                        System.arraycopy(byArray2, var4_12.bytesPerLine, byArrayArray[1], n8 * n, n);
                        System.arraycopy(byArray2, 2 * var4_12.bytesPerLine, byArrayArray[2], n8 * n, n);
                    }
                    object = new DataBufferByte(byArrayArray, byArrayArray[0].length);
                    WritableRaster writableRaster = Raster.createBandedRaster((DataBuffer)object, n, n2, n, new int[]{0, 1, 2}, new int[]{0, 0, 0}, null);
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                    bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), new Properties());
                } else {
                    if (!(var4_12.bitsPerPixel == 24 && var4_12.nPlanes == 1 || var4_12.bitsPerPixel == 32 && var4_12.nPlanes == 1)) {
                        throw new ImagingException("Invalid/unsupported image with bitsPerPixel " + var4_12.bitsPerPixel + " and planes " + var4_12.nPlanes);
                    }
                    n6 = 3 * n;
                    byte[] byArray4 = Allocator.byteArray(n6 * n2);
                    for (n8 = 0; n8 < n2; ++n8) {
                        rleReader.read(inputStream2, byArray2);
                        if (var4_12.bitsPerPixel == 24) {
                            System.arraycopy(byArray2, 0, byArray4, n8 * n6, n6);
                            continue;
                        }
                        for (n9 = 0; n9 < n; ++n9) {
                            byArray4[n8 * n6 + 3 * n9] = byArray2[4 * n9];
                            byArray4[n8 * n6 + 3 * n9 + 1] = byArray2[4 * n9 + 1];
                            byArray4[n8 * n6 + 3 * n9 + 2] = byArray2[4 * n9 + 2];
                        }
                    }
                    object = new DataBufferByte(byArray4, byArray4.length);
                    WritableRaster writableRaster = Raster.createInterleavedRaster((DataBuffer)object, n, n2, n6, 3, new int[]{2, 1, 0}, null);
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                    bufferedImage2 = bufferedImage = new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), new Properties());
                }
                if (is == null) break block37;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var3_7;
                        var3_7.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] read256ColorPalette(InputStream stream) throws IOException {
        void var1_1;
        byte[] byArray = BinaryFunctions.readBytes("Palette", stream, 769, "Error reading palette");
        Object paletteBytes = byArray;
        if (byArray[0] != 12) {
            return null;
        }
        int[] palette = new int[256];
        for (int i = 0; i < palette.length; ++i) {
            palette[i] = (0xFF & paletteBytes[1 + 3 * i]) << 16 | (0xFF & paletteBytes[1 + 3 * i + 1]) << 8 | 0xFF & paletteBytes[1 + 3 * i + 2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int[] read256ColorPaletteFromEndOfFile(ByteSource byteSource) throws IOException {
        int[] nArray;
        block5: {
            InputStream stream = byteSource.getInputStream();
            try {
                void var3_3;
                long toSkip = nArray.size() - 769L;
                BinaryFunctions.skipBytes(stream, (int)var3_3);
                nArray = PcxImageParser.read256ColorPalette(stream);
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        void var2_2;
                        var2_2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            stream.close();
        }
        return nArray;
    }

    static final class PcxHeader {
        public final int manufacturer;
        public final int version;
        public final int encoding;
        public final int bitsPerPixel;
        public final int xMin;
        public final int yMin;
        public final int xMax;
        public final int yMax;
        public final int hDpi;
        public final int vDpi;
        public final int[] colormap;
        public final int reserved;
        public final int nPlanes;
        public final int bytesPerLine;
        public final int paletteInfo;
        public final int hScreenSize;
        public final int vScreenSize;

        /*
         * WARNING - void declaration
         */
        PcxHeader(int manufacturer, int version, int encoding, int bitsPerPixel, int xMin, int yMin, int xMax, int yMax, int hDpi, int vDpi, int[] colormap, int reserved, int nPlanes, int bytesPerLine, int paletteInfo, int hScreenSize, int vScreenSize) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.manufacturer = var1_1;
            this.version = var2_2;
            this.encoding = var3_3;
            this.bitsPerPixel = bitsPerPixel;
            this.xMin = xMin;
            this.yMin = yMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.hDpi = hDpi;
            this.vDpi = vDpi;
            this.colormap = colormap;
            this.reserved = reserved;
            this.nPlanes = nPlanes;
            this.bytesPerLine = bytesPerLine;
            this.paletteInfo = paletteInfo;
            this.hScreenSize = hScreenSize;
            this.vScreenSize = vScreenSize;
        }
    }
}

