/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public class SofnSegment
extends AbstractSegment {
    private static final Logger LOGGER = Logger.getLogger(SofnSegment.class.getName());
    public final int width;
    public final int height;
    public final int numberOfComponents;
    public final int precision;
    private final Component[] components;

    /*
     * WARNING - void declaration
     */
    public SofnSegment(int marker, byte[] segmentData) throws IOException, ImagingException {
        this((int)var1_1, segmentData.length, new ByteArrayInputStream((byte[])var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SofnSegment(int marker, int markerLength, InputStream is) throws IOException, ImagingException {
        super(marker, markerLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("SOF0Segment markerLength: " + markerLength);
        }
        this.precision = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
        this.height = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid JPEG File", this.getByteOrder());
        this.width = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid JPEG File", this.getByteOrder());
        this.numberOfComponents = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
        if (this.numberOfComponents < 0) {
            throw new ImagingException("The number of components in a SOF0Segment cannot be less than 0!");
        }
        this.components = (Component[])Allocator.array(this.numberOfComponents, Component[]::new, 32);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            void var2_2;
            byte componentIdentifier = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            byte hvSamplingFactors = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            int horizontalSamplingFactor = hvSamplingFactors >> 4 & 0xF;
            int verticalSamplingFactor = hvSamplingFactors & 0xF;
            byte quantTabDestSelector = BinaryFunctions.readByte$74534d56(is, "Not a Valid JPEG File");
            this.components[i] = new Component((int)var2_2, horizontalSamplingFactor, verticalSamplingFactor, quantTabDestSelector);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Component getComponents(int index) {
        void var1_1;
        return this.components[var1_1];
    }

    @Override
    public final String getDescription() {
        return "SOFN (SOF" + (this.marker - 65472) + ") (" + this.getSegmentType() + ")";
    }

    public static final class Component {
        public final int componentIdentifier;
        public final int horizontalSamplingFactor;
        public final int verticalSamplingFactor;
        public final int quantTabDestSelector;

        /*
         * WARNING - void declaration
         */
        public Component(int componentIdentifier, int horizontalSamplingFactor, int veritcalSamplingFactor, int quantTabDestSelector) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.componentIdentifier = var1_1;
            this.horizontalSamplingFactor = var2_2;
            this.verticalSamplingFactor = var3_3;
            this.quantTabDestSelector = quantTabDestSelector;
        }
    }
}

