/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.gif;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.gif.GenericGifBlock;
import org.apache.commons.imaging.formats.gif.GifBlock;
import org.apache.commons.imaging.formats.gif.GifHeaderInfo;
import org.apache.commons.imaging.formats.gif.GifImageContents;
import org.apache.commons.imaging.formats.gif.GifImageData;
import org.apache.commons.imaging.formats.gif.GifImagingParameters;
import org.apache.commons.imaging.formats.gif.GraphicControlExtension;
import org.apache.commons.imaging.formats.gif.ImageDescriptor;
import org.apache.commons.imaging.mylzw.MyLzwDecompressor;

public class GifImageParser
extends AbstractImageParser<GifImagingParameters> {
    private static final Logger LOGGER = Logger.getLogger(GifImageParser.class.getName());
    private static final String DEFAULT_EXTENSION = ImageFormats.GIF.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.GIF.getExtensions();
    private static final byte[] GIF_HEADER_SIGNATURE = new byte[]{71, 73, 70};
    private static final byte[] XMP_APPLICATION_ID_AND_AUTH_CODE = new byte[]{88, 77, 80, 32, 68, 97, 116, 97, 88, 77, 80};

    public GifImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    private int convertColorTableSize(int tableSize) {
        int n;
        int n2 = n + true;
        n = 2;
        n = 1;
        for (int i = 0; i < n2; ++i) {
            n *= 2;
        }
        return 3 * n;
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends GifBlock> List<T> findAllBlocks(List<GifBlock> blocks, int code) {
        void var2_2;
        Iterator<GifBlock> iterator;
        ArrayList<void> filteredBlocks = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            GifBlock gifBlock = (GifBlock)iterator.next();
            if (gifBlock.blockCode != code) continue;
            filteredBlocks.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static GifBlock findBlock(List<GifBlock> blocks, int code) {
        for (GifBlock gifBlock : blocks) {
            void var2_2;
            if (gifBlock.blockCode != code) continue;
            return var2_2;
        }
        return null;
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.GIF};
    }

    @Override
    public final List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        GifImageContents imageContents = this.readFile(byteSource, false);
        List<GifImageData> list = imageContents.gifHeaderInfo;
        if (list == null) {
            throw new ImagingException("GIF: Couldn't read Header");
        }
        List list2 = imageContents;
        list = this;
        list = GifImageParser.findAllBlocks(((GifImageContents)((Object)list2)).blocks, 44);
        if (list.isEmpty()) {
            throw new ImagingException("GIF: Couldn't read Image Descriptor");
        }
        list2 = GifImageParser.findAllBlocks(((GifImageContents)((Object)list2)).blocks, 8697);
        if (!list2.isEmpty() && list2.size() != list.size()) {
            throw new ImagingException("GIF: Invalid amount of Graphic Control Extensions");
        }
        ArrayList arrayList = Allocator.arrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ImageDescriptor imageDescriptor = (ImageDescriptor)((Object)list.get(i));
            if (imageDescriptor == null) {
                throw new ImagingException(String.format("GIF: Couldn't read Image Descriptor of image number %d", i));
            }
            GraphicControlExtension graphicControlExtension = list2.isEmpty() ? null : (GraphicControlExtension)list2.get(i);
            arrayList.add(new GifImageData(imageDescriptor, graphicControlExtension));
        }
        ArrayList imageData = arrayList;
        ArrayList result = Allocator.arrayList(imageData.size());
        for (GifImageData id : list) {
            result.add(this.getBufferedImage$3e1fb8fd(id, imageContents.globalColorTable));
        }
        return list2;
    }

    private BufferedImage getBufferedImage$3e1fb8fd(GifImageData imageData, byte[] globalColorTable) throws ImagingException {
        int[] colorTable;
        ImageDescriptor id = imageData.descriptor;
        GraphicControlExtension gce = imageData.gce;
        int width = id.imageWidth;
        int height = id.imageHeight;
        boolean hasAlpha = false;
        if (gce != null && gce.transparency) {
            hasAlpha = true;
        }
        ImageBuilder imageBuilder = new ImageBuilder(width, height, hasAlpha);
        if (id.localColorTable != null) {
            colorTable = GifImageParser.getColorTable(id.localColorTable);
        } else if (colorTable != null) {
            colorTable = GifImageParser.getColorTable((byte[])colorTable);
        } else {
            throw new ImagingException("Gif: No Color Table");
        }
        int transparentIndex = -1;
        if (gce != null && hasAlpha) {
            transparentIndex = gce.transparentColorIndex;
        }
        int counter = 0;
        int rowsInPass1 = (height + 7) / 8;
        int rowsInPass2 = (height + 3) / 8;
        int rowsInPass3 = (height + 1) / 4;
        int rowsInPass4 = height / 2;
        for (int row = 0; row < height; ++row) {
            int y;
            if (id.interlaceFlag) {
                int theRow = row;
                if (theRow < rowsInPass1) {
                    y = theRow * 8;
                } else if ((theRow -= rowsInPass1) < rowsInPass2) {
                    y = 4 + theRow * 8;
                } else if ((theRow -= rowsInPass2) < rowsInPass3) {
                    y = 2 + theRow * 4;
                } else {
                    if ((theRow -= rowsInPass3) >= rowsInPass4) {
                        throw new ImagingException("Gif: Strange Row");
                    }
                    y = 1 + theRow * 2;
                }
            } else {
                y = row;
            }
            for (int x = 0; x < width; ++x) {
                int index;
                if (counter >= id.imageData.length) {
                    throw new ImagingException(String.format("Invalid GIF image data length [%d], greater than the image data length [%d]", id.imageData.length, width));
                }
                if ((index = 0xFF & id.imageData[counter++]) >= colorTable.length) {
                    throw new ImagingException(String.format("Invalid GIF color table index [%d], greater than the color table length [%d]", index, colorTable.length));
                }
                int rgb = colorTable[index];
                if (transparentIndex == index) {
                    rgb = 0;
                }
                imageBuilder.setRgb(x, y, rgb);
            }
        }
        return imageBuilder.getBufferedImage();
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getColorTable(byte[] bytes) throws ImagingException {
        void var2_2;
        if (bytes.length % 3 != 0) {
            throw new ImagingException("Bad Color Table Length: " + bytes.length);
        }
        int length = bytes.length / 3;
        int[] result = Allocator.intArray(length);
        for (int i = 0; i < length; ++i) {
            int rgb;
            int red = 0xFF & bytes[i * 3 + 0];
            int green = 0xFF & bytes[i * 3 + 1];
            int blue = 0xFF & bytes[i * 3 + 2];
            result[i] = rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readColorTable(InputStream is, int tableSize) throws IOException {
        void var2_2;
        void var1_1;
        int actualSize = this.convertColorTableSize(tableSize);
        return BinaryFunctions.readBytes("block", (InputStream)var1_1, (int)var2_2, "GIF: corrupt Color Table");
    }

    /*
     * WARNING - void declaration
     */
    private GifImageContents readFile(ByteSource byteSource, boolean stopBeforeImageData) throws ImagingException, IOException {
        void var1_1;
        return this.readFile((ByteSource)var1_1, false, FormatCompliance.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    private GifImageContents readFile(ByteSource byteSource, boolean stopBeforeImageData22, FormatCompliance formatCompliance) throws ImagingException, IOException {
        GifImageContents gifImageContents;
        block41: {
            InputStream is = byteSource.getInputStream();
            try {
                void var3_5;
                int n9;
                int by;
                Object object = formatCompliance;
                Object object2 = is;
                GifImageParser gifImageParser = this;
                byte by3 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                byte by2 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                byte arrayList = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                int n = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                int imageDescriptor = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                int n2 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                if (object != null) {
                    ((FormatCompliance)object).compareBytes("Signature", GIF_HEADER_SIGNATURE, new byte[]{by3, by2, arrayList});
                    ((FormatCompliance)object).compare("version", 56, n);
                    ((FormatCompliance)object).compare("version", new int[]{55, 57}, imageDescriptor);
                    ((FormatCompliance)object).compare("version", 97, n2);
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    BinaryFunctions.logCharQuad("identifier: ", by3 << 16 | by2 << 8 | arrayList << 0);
                    BinaryFunctions.logCharQuad("version: ", n << 16 | imageDescriptor << 8 | n2 << 0);
                }
                int by4 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object2, "Not a Valid GIF File", gifImageParser.getByteOrder());
                int graphicControlExtension = BinaryFunctions.read2Bytes$47efdc82((InputStream)object2, "Not a Valid GIF File", gifImageParser.getByteOrder());
                if (object != null) {
                    ((FormatCompliance)object).checkBounds("Width", 1, Integer.MAX_VALUE, by4);
                    ((FormatCompliance)object).checkBounds("Height", 1, Integer.MAX_VALUE, graphicControlExtension);
                }
                int object6 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                byte by5 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                byte bl4 = BinaryFunctions.readByte$74534d56((InputStream)object2, "Not a Valid GIF File");
                if (LOGGER.isLoggable(Level.FINEST)) {
                    BinaryFunctions.logByteBits("PackedFields bits", (byte)object6);
                }
                int by6 = by = (object6 & 0x80) > 0 ? (int)1 : 0;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("GlobalColorTableFlag: " + (by != 0));
                }
                int n3 = object6 >> 4 & 7;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("ColorResolution: " + n3);
                }
                int by7 = n9 = (object6 & 8) > 0 ? (int)1 : 0;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("SortFlag: " + (n9 != 0));
                }
                int n4 = object6 & 7;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("SizeofGlobalColorTable: " + n4);
                }
                if (object != null && by != 0 && by5 != -1) {
                    ((FormatCompliance)object).checkBounds("Background Color Index", 0, gifImageParser.convertColorTableSize(n4), by5);
                }
                GifHeaderInfo ghi = new GifHeaderInfo(by3, by2, arrayList, (byte)n, (byte)imageDescriptor, (byte)n2, by4, graphicControlExtension, (byte)object6, by5, bl4, by != 0, (byte)n3, n9 != 0, (byte)n4);
                byte[] globalColorTable = null;
                if (ghi.globalColorTableFlag) {
                    globalColorTable = this.readColorTable(is, ghi.sizeOfGlobalColorTable);
                }
                void var10_13 = var3_5;
                boolean bl = stopBeforeImageData22;
                object = is;
                object2 = ghi;
                gifImageParser = this;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                block16: while (true) {
                    n = ((InputStream)object).read();
                    block2 : switch (n) {
                        case -1: {
                            throw new ImagingException("GIF: unexpected end of data");
                        }
                        case 44: {
                            int by8;
                            boolean bl2;
                            void stopBeforeImageData22 = var10_13;
                            n4 = bl ? 1 : 0;
                            Object object8 = object;
                            n3 = n;
                            Object object3 = object2;
                            Object gifImageParser2 = gifImageParser;
                            int n7 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object8, "Not a Valid GIF File", ((BinaryFileParser)gifImageParser2).getByteOrder());
                            n = BinaryFunctions.read2Bytes$47efdc82((InputStream)object8, "Not a Valid GIF File", ((BinaryFileParser)gifImageParser2).getByteOrder());
                            imageDescriptor = BinaryFunctions.read2Bytes$47efdc82((InputStream)object8, "Not a Valid GIF File", ((BinaryFileParser)gifImageParser2).getByteOrder());
                            n2 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object8, "Not a Valid GIF File", ((BinaryFileParser)gifImageParser2).getByteOrder());
                            by4 = BinaryFunctions.readByte$74534d56((InputStream)object8, "Not a Valid GIF File");
                            if (stopBeforeImageData22 != null) {
                                stopBeforeImageData22.checkBounds("Width", 1, ((GifHeaderInfo)object3).logicalScreenWidth, imageDescriptor);
                                stopBeforeImageData22.checkBounds("Height", 1, ((GifHeaderInfo)object3).logicalScreenHeight, n2);
                                stopBeforeImageData22.checkBounds("Left Position", 0, ((GifHeaderInfo)object3).logicalScreenWidth - imageDescriptor, n7);
                                stopBeforeImageData22.checkBounds("Top Position", 0, ((GifHeaderInfo)object3).logicalScreenHeight - n2, n);
                            }
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                BinaryFunctions.logByteBits("PackedFields bits", by4);
                            }
                            boolean bl3 = stopBeforeImageData22 = (by4 >> 7 & 1) > 0;
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("LocalColorTableFlag: " + stopBeforeImageData22);
                            }
                            boolean bl5 = bl2 = (by4 >> 6 & 1) > 0;
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("Interlace Flag: " + bl2);
                            }
                            int n5 = object6 = (by4 >> 5 & 1) > 0 ? 1 : 0;
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("Sort Flag: " + (object6 != 0));
                            }
                            by5 = (byte)(by4 & 7);
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("SizeofLocalColorTable: " + by5);
                            }
                            object3 = null;
                            if (stopBeforeImageData22) {
                                object3 = ((GifImageParser)gifImageParser2).readColorTable((InputStream)object8, by5);
                            }
                            byte[] byArray = null;
                            if (n4 == 0) {
                                n4 = ((InputStream)object8).read();
                                by8 = -1;
                                GenericGifBlock genericGifBlock = ((GifImageParser)gifImageParser2).readGenericGifBlock((InputStream)object8, by8, null);
                                gifImageParser2 = genericGifBlock;
                                gifImageParser2 = genericGifBlock;
                                boolean gifImageParser3 = false;
                                gifImageParser2 = genericGifBlock;
                                object8 = new ByteArrayOutputStream();
                                for (int i = 0; i < ((GenericGifBlock)gifImageParser2).subBlocks.size(); ++i) {
                                    byte[] byArray2 = ((GenericGifBlock)gifImageParser2).subBlocks.get(i);
                                    ((OutputStream)object8).write(byArray2);
                                }
                                gifImageParser2 = ((ByteArrayOutputStream)object8).toByteArray();
                                gifImageParser2 = new ByteArrayInputStream((byte[])gifImageParser2);
                                int object9 = imageDescriptor * n2;
                                MyLzwDecompressor myLzwDecompressor = new MyLzwDecompressor(n4, ByteOrder.LITTLE_ENDIAN, false);
                                byArray = myLzwDecompressor.decompress((InputStream)gifImageParser2, object9);
                            } else {
                                n4 = ((InputStream)object8).read();
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.finest("LZWMinimumCodeSize: " + n4);
                                }
                                by8 = -1;
                                ((GifImageParser)gifImageParser2).readGenericGifBlock((InputStream)object8, by8, null);
                            }
                            ImageDescriptor imageDescriptor2 = new ImageDescriptor(n3, n7, n, imageDescriptor, n2, (byte)by4, stopBeforeImageData22, bl2, object6 != 0, by5, (byte[])object3, byArray);
                            arrayList2.add(imageDescriptor2);
                            continue block16;
                        }
                        case 33: {
                            Object object4;
                            int by8;
                            int n7;
                            n2 = ((InputStream)object).read();
                            by4 = (0xFF & n) << 8 | 0xFF & n2;
                            switch (n2) {
                                case 249: {
                                    Object object5 = object;
                                    by = by4;
                                    GifImageParser gifImageParser4 = gifImageParser;
                                    BinaryFunctions.readByte$74534d56((InputStream)object5, "GIF: corrupt GraphicControlExt");
                                    n9 = BinaryFunctions.readByte$74534d56((InputStream)object5, "GIF: corrupt GraphicControlExt");
                                    n4 = (n9 & 0x1C) >> 2;
                                    boolean stopBeforeImageData22 = (n9 & 1) != 0;
                                    n7 = BinaryFunctions.read2Bytes$47efdc82((InputStream)object5, "GIF: corrupt GraphicControlExt", gifImageParser4.getByteOrder());
                                    n = 0xFF & BinaryFunctions.readByte$74534d56((InputStream)object5, "GIF: corrupt GraphicControlExt");
                                    BinaryFunctions.readByte$74534d56((InputStream)object5, "GIF: corrupt GraphicControlExt");
                                    GraphicControlExtension graphicControlExtension2 = new GraphicControlExtension(by, n9, n4, stopBeforeImageData22, n7, n);
                                    arrayList2.add(graphicControlExtension2);
                                    break block2;
                                }
                                case 1: 
                                case 254: {
                                    by8 = by4;
                                    Object object7 = object;
                                    GifImageParser gifImageParser2 = gifImageParser;
                                    GenericGifBlock genericGifBlock = gifImageParser2.readGenericGifBlock((InputStream)object7, by8, null);
                                    arrayList2.add(genericGifBlock);
                                    break block2;
                                }
                                case 255: {
                                    object4 = GifImageParser.readSubBlock((InputStream)object);
                                    if (var10_13 != null) {
                                        var10_13.addComment("Unknown Application Extension (" + new String((byte[])object4, StandardCharsets.US_ASCII) + ")", by4);
                                    }
                                    if (((byte[])object4).length <= 0) continue block16;
                                    GenericGifBlock genericGifBlock = gifImageParser.readGenericGifBlock((InputStream)object, by4, (byte[])object4);
                                    arrayList2.add(genericGifBlock);
                                    break block2;
                                }
                            }
                            if (var10_13 != null) {
                                var10_13.addComment("Unknown block", by4);
                            }
                            by8 = by4;
                            Object object8 = object;
                            GifImageParser gifImageParser3 = gifImageParser;
                            object4 = gifImageParser3.readGenericGifBlock((InputStream)object8, by8, null);
                            arrayList2.add(object4);
                            continue block16;
                        }
                        case 59: {
                            break block16;
                        }
                        case 0: {
                            continue block16;
                        }
                        default: {
                            throw new ImagingException("GIF: unknown code: " + n);
                        }
                    }
                }
                ArrayList<Object> blocks = arrayList2;
                gifImageContents = new GifImageContents(ghi, globalColorTable, (List<GifBlock>)((Object)gifImageContents));
                if (is == null) break block41;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return gifImageContents;
    }

    /*
     * WARNING - void declaration
     */
    private GenericGifBlock readGenericGifBlock(InputStream is, int code, byte[] first) throws IOException {
        void var2_2;
        byte[] bytes;
        ArrayList<byte[]> subBlocks = new ArrayList<byte[]>();
        if (first != null) {
            subBlocks.add(first);
        }
        while ((bytes = GifImageParser.readSubBlock(is)).length > 0) {
            void var3_3;
            subBlocks.add((byte[])var3_3);
        }
        return new GenericGifBlock((int)var2_2, subBlocks);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] readSubBlock(InputStream is) throws IOException {
        void var1_1;
        InputStream inputStream;
        int blockSize = 0xFF & BinaryFunctions.readByte$74534d56(is, "GIF: corrupt block");
        return BinaryFunctions.readBytes("block", inputStream, (int)var1_1, "GIF: corrupt block");
    }
}

