/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.bmp.AbstractPixelParser;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;
import org.apache.commons.imaging.formats.bmp.BmpImageContents;
import org.apache.commons.imaging.formats.bmp.BmpImagingParameters;
import org.apache.commons.imaging.formats.bmp.PixelParserBitFields;
import org.apache.commons.imaging.formats.bmp.PixelParserRgb;
import org.apache.commons.imaging.formats.bmp.PixelParserRle;

public class BmpImageParser
extends AbstractImageParser<BmpImagingParameters> {
    private static final Logger LOGGER = Logger.getLogger(BmpImageParser.class.getName());
    private static final String DEFAULT_EXTENSION = ImageFormats.BMP.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.BMP.getExtensions();
    private static final byte[] BMP_HEADER_SIGNATURE = new byte[]{66, 77};

    public BmpImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.BMP};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private BufferedImage getBufferedImage(ByteSource byteSource, BmpImagingParameters params) throws ImagingException, IOException {
        BufferedImage bufferedImage;
        block5: {
            InputStream is = byteSource.getInputStream();
            try {
                bufferedImage = this.getBufferedImage$7190f1a6(is);
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public final BufferedImage getBufferedImage$7190f1a6(InputStream inputStream) throws ImagingException, IOException {
        void var2_4;
        void var1_1;
        void var3_5;
        BmpImageContents ic = this.readImageContents(inputStream, FormatCompliance.getDefault());
        BmpHeaderInfo bhi = ic.bhi;
        int width = bhi.width;
        int height = bhi.height;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("width: " + width);
            LOGGER.fine("height: " + height);
            LOGGER.fine("width*height: " + width * height);
            LOGGER.fine("width*height*4: " + width * height * 4);
        }
        AbstractPixelParser abstractPixelParser = ic.abstractPixelParser;
        ImageBuilder imageBuilder = new ImageBuilder((int)var3_5, height, true);
        var1_1.processImage(imageBuilder);
        return var2_4.getBufferedImage();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] getRleBytes(InputStream is, int rleSamplesPerByte) throws IOException {
        void var2_2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean done = false;
        block5: while (!done) {
            int a = 0xFF & BinaryFunctions.readByte$74534d56(is, "BMP: Bad RLE");
            baos.write(a);
            int b = 0xFF & BinaryFunctions.readByte$74534d56(is, "BMP: Bad RLE");
            baos.write(b);
            if (a != 0) continue;
            switch (b) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    done = true;
                    continue block5;
                }
                case 2: {
                    int c = 0xFF & BinaryFunctions.readByte$74534d56(is, "BMP: Bad RLE");
                    baos.write(c);
                    int d = 0xFF & BinaryFunctions.readByte$74534d56(is, "BMP: Bad RLE");
                    baos.write(d);
                    continue block5;
                }
            }
            int size = b / rleSamplesPerByte;
            if (b % rleSamplesPerByte > 0) {
                ++size;
            }
            if (size % 2 != 0) {
                ++size;
            }
            byte[] bytes = BinaryFunctions.readBytes("bytes", is, size, "RLE: Absolute Mode");
            baos.write(bytes);
        }
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private BmpHeaderInfo readBmpHeaderInfo(InputStream is, FormatCompliance formatCompliance) throws ImagingException, IOException {
        void var2_3;
        void var3_4;
        byte identifier1 = BinaryFunctions.readByte$74534d56(is, "Not a Valid BMP File");
        byte identifier2 = BinaryFunctions.readByte$74534d56(is, "Not a Valid BMP File");
        if (formatCompliance != null) {
            formatCompliance.compareBytes("Signature", BMP_HEADER_SIGNATURE, new byte[]{identifier1, identifier2});
        }
        int fileSize = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int reserved = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int bitmapDataOffset = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int bitmapHeaderSize = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int redMask = 0;
        int greenMask = 0;
        int blueMask = 0;
        int alphaMask = 0;
        int colorSpaceType = 0;
        BmpHeaderInfo.ColorSpace colorSpace = new BmpHeaderInfo.ColorSpace();
        new BmpHeaderInfo.ColorSpace().red = new BmpHeaderInfo.ColorSpaceCoordinate();
        colorSpace.green = new BmpHeaderInfo.ColorSpaceCoordinate();
        colorSpace.blue = new BmpHeaderInfo.ColorSpaceCoordinate();
        int gammaRed = 0;
        int gammaGreen = 0;
        int gammaBlue = 0;
        int intent = 0;
        int profileData = 0;
        int profileSize = 0;
        int reservedV5 = 0;
        if (bitmapHeaderSize < 40) {
            throw new ImagingException("Invalid/unsupported BMP file");
        }
        int width = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int height = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int planes = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int bitsPerPixel = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int compression = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int bitmapDataSize = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int hResolution = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int vResolution = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int colorsUsed = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        int colorsImportant = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        if (bitmapHeaderSize >= 52 || compression == 3) {
            redMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            greenMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            blueMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        }
        if (bitmapHeaderSize >= 56) {
            alphaMask = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        }
        if (bitmapHeaderSize >= 108) {
            colorSpaceType = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.red.x = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.red.y = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.red.z = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.green.x = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.green.y = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.green.z = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.blue.x = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.blue.y = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            colorSpace.blue.z = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            gammaRed = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            gammaGreen = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            gammaBlue = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
        }
        if (bitmapHeaderSize >= 124) {
            void var1_1;
            intent = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            profileData = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            profileSize = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid BMP File", this.getByteOrder());
            reservedV5 = BinaryFunctions.read4Bytes$47efdc82((InputStream)var1_1, "Not a Valid BMP File", this.getByteOrder());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("identifier1", identifier1, 1);
            this.debugNumber("identifier2", identifier2, 1);
            this.debugNumber("fileSize", fileSize, 4);
            this.debugNumber("reserved", reserved, 4);
            this.debugNumber("bitmapDataOffset", bitmapDataOffset, 4);
            this.debugNumber("bitmapHeaderSize", bitmapHeaderSize, 4);
            this.debugNumber("width", width, 4);
            this.debugNumber("height", height, 4);
            this.debugNumber("planes", planes, 2);
            this.debugNumber("bitsPerPixel", bitsPerPixel, 2);
            this.debugNumber("compression", compression, 4);
            this.debugNumber("bitmapDataSize", bitmapDataSize, 4);
            this.debugNumber("hResolution", hResolution, 4);
            this.debugNumber("vResolution", vResolution, 4);
            this.debugNumber("colorsUsed", colorsUsed, 4);
            this.debugNumber("colorsImportant", colorsImportant, 4);
            if (bitmapHeaderSize >= 52 || compression == 3) {
                this.debugNumber("redMask", redMask, 4);
                this.debugNumber("greenMask", greenMask, 4);
                this.debugNumber("blueMask", blueMask, 4);
            }
            if (bitmapHeaderSize >= 56) {
                this.debugNumber("alphaMask", alphaMask, 4);
            }
            if (bitmapHeaderSize >= 108) {
                this.debugNumber("colorSpaceType", colorSpaceType, 4);
                this.debugNumber("colorSpace.red.x", colorSpace.red.x, 1);
                this.debugNumber("colorSpace.red.y", colorSpace.red.y, 1);
                this.debugNumber("colorSpace.red.z", colorSpace.red.z, 1);
                this.debugNumber("colorSpace.green.x", colorSpace.green.x, 1);
                this.debugNumber("colorSpace.green.y", colorSpace.green.y, 1);
                this.debugNumber("colorSpace.green.z", colorSpace.green.z, 1);
                this.debugNumber("colorSpace.blue.x", colorSpace.blue.x, 1);
                this.debugNumber("colorSpace.blue.y", colorSpace.blue.y, 1);
                this.debugNumber("colorSpace.blue.z", colorSpace.blue.z, 1);
                this.debugNumber("gammaRed", gammaRed, 4);
                this.debugNumber("gammaGreen", gammaGreen, 4);
                this.debugNumber("gammaBlue", gammaBlue, 4);
            }
            if (bitmapHeaderSize >= 124) {
                this.debugNumber("intent", intent, 4);
                this.debugNumber("profileData", profileData, 4);
                this.debugNumber("profileSize", profileSize, 4);
                this.debugNumber("reservedV5", reservedV5, 4);
            }
        }
        return new BmpHeaderInfo((byte)var3_4, identifier2, (int)var2_3, reserved, bitmapDataOffset, bitmapHeaderSize, width, height, planes, bitsPerPixel, compression, bitmapDataSize, hResolution, vResolution, colorsUsed, colorsImportant, redMask, greenMask, blueMask, alphaMask, colorSpaceType, colorSpace, gammaRed, gammaGreen, gammaBlue, intent, profileData, profileSize, reservedV5);
    }

    /*
     * WARNING - void declaration
     */
    private BmpImageContents readImageContents(InputStream is, FormatCompliance formatCompliance) throws ImagingException, IOException {
        void var3_4;
        void var1_1;
        void var2_2;
        byte[] imageData;
        int extraBytes;
        int paletteLength;
        BmpHeaderInfo bhi = this.readBmpHeaderInfo(is, formatCompliance);
        int colorTableSize = bhi.colorsUsed;
        if (colorTableSize == 0) {
            colorTableSize = 1 << bhi.bitsPerPixel;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("ColorsUsed", bhi.colorsUsed, 4);
            this.debugNumber("BitsPerPixel", bhi.bitsPerPixel, 4);
            this.debugNumber("ColorTableSize", colorTableSize, 4);
            this.debugNumber("bhi.colorsUsed", bhi.colorsUsed, 4);
            this.debugNumber("Compression", bhi.compression, 4);
        }
        int rleSamplesPerByte = 0;
        boolean rle = false;
        switch (bhi.compression) {
            case 0: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Compression: BI_RGB");
                }
                if (bhi.bitsPerPixel <= 8) {
                    paletteLength = 4 * colorTableSize;
                    break;
                }
                paletteLength = 0;
                break;
            }
            case 2: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Compression: BI_RLE4");
                }
                paletteLength = 4 * paletteLength;
                rleSamplesPerByte = 2;
                rle = true;
                break;
            }
            case 1: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Compression: BI_RLE8");
                }
                paletteLength = 4 * paletteLength;
                rleSamplesPerByte = 1;
                rle = true;
                break;
            }
            case 3: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Compression: BI_BITFIELDS");
                }
                if (bhi.bitsPerPixel <= 8) {
                    paletteLength = 4 * paletteLength;
                    break;
                }
                paletteLength = 0;
                break;
            }
            default: {
                throw new ImagingException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        if (paletteLength < 0) {
            throw new ImagingException("BMP: Invalid negative palette length: " + paletteLength);
        }
        byte[] colorTable = null;
        if (paletteLength > 0) {
            colorTable = BinaryFunctions.readBytes("ColorTable", is, paletteLength, "Not a Valid BMP File");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("paletteLength", paletteLength, 4);
            LOGGER.fine("ColorTable: " + (colorTable == null ? "null" : Integer.toString(colorTable.length)));
        }
        int imageLineLength = (bhi.bitsPerPixel * bhi.width + 7) / 8;
        if (LOGGER.isLoggable(Level.FINE)) {
            int pixelCount = bhi.width * bhi.height;
            this.debugNumber("bhi.Width", bhi.width, 4);
            this.debugNumber("bhi.Height", bhi.height, 4);
            this.debugNumber("ImageLineLength", imageLineLength, 4);
            this.debugNumber("PixelCount", pixelCount, 4);
        }
        while (imageLineLength % 4 != 0) {
            ++imageLineLength;
        }
        int headerSize = 14 + bhi.bitmapHeaderSize + (bhi.bitmapHeaderSize == 40 && bhi.compression == 3 ? 12 : 0);
        int expectedDataOffset = headerSize + paletteLength;
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("bhi.BitmapDataOffset", bhi.bitmapDataOffset, 4);
            this.debugNumber("expectedDataOffset", expectedDataOffset, 4);
        }
        if ((extraBytes = bhi.bitmapDataOffset - expectedDataOffset) < 0 || extraBytes > bhi.fileSize) {
            throw new ImagingException("BMP has invalid image data offset: " + bhi.bitmapDataOffset + " (expected: " + expectedDataOffset + ", paletteLength: " + paletteLength + ", headerSize: " + headerSize + ")");
        }
        if (extraBytes > 0) {
            BinaryFunctions.readBytes("BitmapDataOffset", is, extraBytes, "Not a Valid BMP File");
        }
        int imageDataSize = bhi.height * imageLineLength;
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("imageDataSize", imageDataSize, 4);
        }
        imageData = rle ? BmpImageParser.getRleBytes(is, rleSamplesPerByte) : BinaryFunctions.readBytes("ImageData", (InputStream)imageData, imageDataSize, "Not a Valid BMP File");
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugNumber("ImageData.length", imageData.length, 4);
        }
        switch (bhi.compression) {
            case 1: 
            case 2: {
                AbstractPixelParser abstractPixelParser = new PixelParserRle(bhi, colorTable, imageData);
                break;
            }
            case 0: {
                AbstractPixelParser abstractPixelParser = new PixelParserRgb(bhi, colorTable, imageData);
                break;
            }
            case 3: {
                AbstractPixelParser abstractPixelParser = new PixelParserBitFields(bhi, colorTable, imageData);
                break;
            }
            default: {
                throw new ImagingException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        return new BmpImageContents((BmpHeaderInfo)var2_2, colorTable, (byte[])var1_1, (AbstractPixelParser)var3_4);
    }
}

