/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImageFormat;

public class ImageInfo {
    private static final Logger LOGGER = Logger.getLogger(ImageInfo.class.getName());
    private final String formatDetails;
    private final int bitsPerPixel;
    private final List<String> comments;
    private final ImageFormat format;
    private final String formatName;
    private final int height;
    private final String mimeType;
    private final int numberOfImages;
    private final int physicalHeightDpi;
    private final float physicalHeightInch;
    private final int physicalWidthDpi;
    private final float physicalWidthInch;
    private final int width;
    private final boolean progressive;
    private final boolean transparent;
    private final boolean usesPalette;
    private final ColorType colorType;
    private final CompressionAlgorithm compressionAlgorithm;

    /*
     * WARNING - void declaration
     */
    public String toString() {
        try {
            void var1_1;
            void var2_2;
            PrintWriter pw;
            StringWriter sw = new StringWriter();
            PrintWriter printWriter = pw = new PrintWriter(sw);
            ImageInfo imageInfo = this;
            printWriter.println("Format Details: " + imageInfo.formatDetails);
            printWriter.println("Bits Per Pixel: " + imageInfo.bitsPerPixel);
            printWriter.println("Comments: " + imageInfo.comments.size());
            for (int i = 0; i < imageInfo.comments.size(); ++i) {
                String string = imageInfo.comments.get(i);
                printWriter.println("\t" + i + ": '" + string + "'");
            }
            printWriter.println("Format: " + imageInfo.format.getName());
            printWriter.println("Format Name: " + imageInfo.formatName);
            printWriter.println("Compression Algorithm: " + (Object)((Object)imageInfo.compressionAlgorithm));
            printWriter.println("Height: " + imageInfo.height);
            printWriter.println("MimeType: " + imageInfo.mimeType);
            printWriter.println("Number Of Images: " + imageInfo.numberOfImages);
            printWriter.println("Physical Height Dpi: " + imageInfo.physicalHeightDpi);
            printWriter.println("Physical Height Inch: " + imageInfo.physicalHeightInch);
            printWriter.println("Physical Width Dpi: " + imageInfo.physicalWidthDpi);
            printWriter.println("Physical Width Inch: " + imageInfo.physicalWidthInch);
            printWriter.println("Width: " + imageInfo.width);
            printWriter.println("Is Progressive: " + imageInfo.progressive);
            printWriter.println("Is Transparent: " + imageInfo.transparent);
            printWriter.println("Color Type: " + imageInfo.colorType.toString());
            printWriter.println("Uses Palette: " + imageInfo.usesPalette);
            printWriter.flush();
            var2_2.flush();
            return var1_1.toString();
        }
        catch (Exception exception) {
            return "Image Data: Error";
        }
    }

    public static enum ColorType {
        BW("Black and White"),
        GRAYSCALE("Grayscale"),
        RGB("RGB"),
        CMYK("CMYK"),
        YCbCr("YCbCr"),
        YCCK("YCCK"),
        YCC("YCC"),
        OTHER("Other"),
        UNKNOWN("Unknown");

        private final String description;

        /*
         * WARNING - void declaration
         */
        private ColorType(String description) {
            void var3_3;
            this.description = var3_3;
        }

        public final String toString() {
            return this.description;
        }
    }

    public static enum CompressionAlgorithm {
        UNKNOWN("Unknown"),
        NONE("None"),
        LZW("LZW"),
        PACKBITS("PackBits"),
        JPEG_TIFF_OBSOLETE("JPEG Obsolete (TIFF only)"),
        JPEG("JPEG"),
        RLE("RLE: Run-Length Encoding"),
        ADAPTIVE_RLE("Adaptive RLE"),
        PSD("Photoshop"),
        PNG_FILTER("PNG Filter"),
        CCITT_GROUP_3("CCITT Group 3 1-Dimensional Modified Huffman run-length encoding."),
        CCITT_GROUP_4("CCITT Group 4"),
        CCITT_1D("CCITT 1D"),
        DEFLATE("DEFLATE (ZIP)");

        private final String description;

        /*
         * WARNING - void declaration
         */
        private CompressionAlgorithm(String description) {
            void var3_3;
            this.description = var3_3;
        }

        public final String toString() {
            return this.description;
        }
    }
}

