/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0012\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u000e\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010\u00a2\u0006\u0004\b\u000e\u0010\u0013J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ$\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010!\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010 H\u00d6\u0003\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b&\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010\u001dR\u0014\u0010+\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010'"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "", "etag", "", "weak", "<init>", "(Ljava/lang/String;Z)V", "Lio/ktor/http/Headers;", "requestHeaders", "Lio/ktor/http/content/VersionCheckResult;", "check", "(Lio/ktor/http/Headers;)Lio/ktor/http/content/VersionCheckResult;", "other", "match", "(Lio/ktor/http/content/EntityTagVersion;)Z", "", "givenNoneMatchEtags", "noneMatch", "(Ljava/util/List;)Lio/ktor/http/content/VersionCheckResult;", "givenMatchEtags", "Lio/ktor/http/HeadersBuilder;", "builder", "", "appendHeadersTo", "(Lio/ktor/http/HeadersBuilder;)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "copy", "(Ljava/lang/String;Z)Lio/ktor/http/content/EntityTagVersion;", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getEtag", "Z", "getWeak", "normalized", "Companion"})
@SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1#2:262\n1755#3,3:263\n*S KotlinDebug\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion\n*L\n189#1:263,3\n*E\n"})
public final class EntityTagVersion
implements Version {
    public static final Companion Companion = new Companion(null);
    private final String etag;
    private final boolean weak;
    private final String normalized;
    private static final EntityTagVersion STAR = new EntityTagVersion("*", false);

    /*
     * WARNING - void declaration
     */
    public EntityTagVersion(String etag, boolean weak) {
        int n;
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        this.etag = etag;
        this.weak = n;
        this.normalized = Intrinsics.areEqual((Object)this.etag, (Object)"*") ? this.etag : (StringsKt.startsWith$default((String)this.etag, (String)"\"", (boolean)false, (int)2, null) ? this.etag : HeaderValueWithParametersKt.quote(this.etag));
        n = ((CharSequence)this.etag).length();
        for (int index2 = 0; index2 < n; ++index2) {
            void var3_5;
            char ch = this.etag.charAt(index2);
            if (Intrinsics.compare((int)ch, (int)32) > 0 && ch != '\"' || index2 == 0 || index2 == StringsKt.getLastIndex((CharSequence)this.etag)) continue;
            String index2 = "Character '" + (char)var3_5 + "' is not allowed in entity-tag.";
            throw new IllegalArgumentException(index2.toString());
        }
    }

    public final String getEtag() {
        return this.etag;
    }

    public final boolean getWeak() {
        return this.weak;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final VersionCheckResult check(Headers requestHeaders) {
        Object givenMatchEtags;
        void var1_1;
        Object givenNoneMatchEtags;
        VersionCheckResult result;
        String it;
        Intrinsics.checkNotNullParameter((Object)requestHeaders, (String)"requestHeaders");
        Object object = requestHeaders.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        if (object != null && (object = Companion.parse(it = object)) != null && (result = this.noneMatch((List<EntityTagVersion>)(givenNoneMatchEtags = object))) != VersionCheckResult.OK) {
            return result;
        }
        Object object2 = var1_1.get(HttpHeaders.INSTANCE.getIfMatch());
        if (object2 != null && (object2 = Companion.parse(it = object2)) != null && (result = this.match((List<EntityTagVersion>)(givenMatchEtags = object2))) != VersionCheckResult.OK) {
            void var2_2;
            return var2_2;
        }
        return VersionCheckResult.OK;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean match(EntityTagVersion other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)STAR) || Intrinsics.areEqual((Object)other, (Object)STAR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.normalized, (Object)var1_1.normalized);
    }

    public final VersionCheckResult noneMatch(List<EntityTagVersion> givenNoneMatchEtags) {
        boolean bl;
        Intrinsics.checkNotNullParameter(givenNoneMatchEtags, (String)"givenNoneMatchEtags");
        if (givenNoneMatchEtags.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        Iterable $this$any$iv = givenNoneMatchEtags;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                EntityTagVersion it = (EntityTagVersion)t;
                if (!this.match((EntityTagVersion)t)) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        return VersionCheckResult.OK;
    }

    /*
     * WARNING - void declaration
     */
    public final VersionCheckResult match(List<EntityTagVersion> givenMatchEtags) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter(givenMatchEtags, (String)"givenMatchEtags");
        if (givenMatchEtags.isEmpty()) {
            return VersionCheckResult.OK;
        }
        if (givenMatchEtags.contains(STAR)) {
            return VersionCheckResult.OK;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            EntityTagVersion given = (EntityTagVersion)iterator.next();
            if (!this.match((EntityTagVersion)var2_2)) continue;
            return VersionCheckResult.OK;
        }
        return VersionCheckResult.PRECONDITION_FAILED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void appendHeadersTo(HeadersBuilder builder) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        ApplicationResponsePropertiesKt.etag((HeadersBuilder)var1_1, this.normalized);
    }

    public final String component1() {
        return this.etag;
    }

    public final boolean component2() {
        return this.weak;
    }

    /*
     * WARNING - void declaration
     */
    public final EntityTagVersion copy(String etag, boolean weak) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
        return new EntityTagVersion((String)var1_1, (boolean)var2_2);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        if ((n & 2) != 0) {
            bl = entityTagVersion.weak;
        }
        return entityTagVersion.copy(string, bl);
    }

    public final String toString() {
        return "EntityTagVersion(etag=" + this.etag + ", weak=" + this.weak + ')';
    }

    public final int hashCode() {
        int n = this.etag.hashCode();
        n = n * 31 + Boolean.hashCode(this.weak);
        return n;
    }

    public final boolean equals(Object other) {
        EntityTagVersion entityTagVersion;
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityTagVersion)) {
            return false;
        }
        entityTagVersion = entityTagVersion;
        if (!Intrinsics.areEqual((Object)this.etag, (Object)entityTagVersion.etag)) {
            return false;
        }
        return this.weak == entityTagVersion.weak;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lio/ktor/http/content/EntityTagVersion$Companion;", "", "<init>", "()V", "", "headerValue", "", "Lio/ktor/http/content/EntityTagVersion;", "parse", "(Ljava/lang/String;)Ljava/util/List;", "value", "parseSingle", "(Ljava/lang/String;)Lio/ktor/http/content/EntityTagVersion;", "STAR", "Lio/ktor/http/content/EntityTagVersion;", "getSTAR", "()Lio/ktor/http/content/EntityTagVersion;"})
    @SourceDebugExtension(value={"SMAP\nVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1557#2:262\n1628#2,2:263\n1630#2:266\n1#3:265\n*S KotlinDebug\n*F\n+ 1 Versions.kt\nio/ktor/http/content/EntityTagVersion$Companion\n*L\n227#1:262\n227#1:263,2\n227#1:266\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final EntityTagVersion getSTAR() {
            return STAR;
        }

        /*
         * WARNING - void declaration
         */
        public final List<EntityTagVersion> parse(String headerValue) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
            headerValue = HttpHeaderValueParserKt.parseHeaderValue((String)headerValue);
            Iterable $this$map$iv = (Iterable)headerValue;
            Object object = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                void entry;
                Object item$iv$iv = object.next();
                item$iv$iv = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (!(entry.getQuality() == 1.0)) {
                    destination$iv$iv = "entity-tag quality parameter is not allowed: " + entry.getQuality() + '.';
                    throw new IllegalStateException(destination$iv$iv.toString());
                }
                if (!entry.getParams().isEmpty()) {
                    destination$iv$iv = "entity-tag parameters are not allowed: " + entry.getParams() + '.';
                    throw new IllegalStateException(destination$iv$iv.toString());
                }
                collection.add(Companion.parseSingle(var3_3.getValue()));
            }
            return (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final EntityTagVersion parseSingle(String value) {
            void var2_2;
            void var1_1;
            String rawEtag;
            boolean weak;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)value, (Object)"*")) {
                return this.getSTAR();
            }
            if (StringsKt.startsWith$default((String)value, (String)"W/", (boolean)false, (int)2, null)) {
                weak = true;
                rawEtag = StringsKt.drop((String)value, (int)2);
            } else {
                weak = false;
            }
            String etag = StringsKt.startsWith$default((String)rawEtag, (String)"\"", (boolean)false, (int)2, null) ? rawEtag : HeaderValueWithParametersKt.quote(rawEtag);
            return new EntityTagVersion((String)var1_1, (boolean)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

