/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CookieUtilsKt;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.parsing.ParseException;
import io.ktor.utils.io.InternalAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002\u00a2\u0006\u0004\b\u0003\u0010\f\u001a7\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a3\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a3\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u001f\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0013\u0010\u0018\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a#\u0010\u001c\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001e\u001a\u00020\b*\u00020\u00002\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017\u001a\u0013\u0010 \u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!\u001a\u0013\u0010\"\u001a\u00020\u001f*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\"\u0010!\"\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\"\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\"\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)"}, d2={"", "headerValue", "Lio/ktor/http/auth/HttpAuthHeader;", "parseAuthorizationHeader", "(Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "", "parseAuthorizationHeaders", "(Ljava/lang/String;)Ljava/util/List;", "", "startIndex", "", "headers", "(Ljava/lang/String;ILjava/util/List;)I", "header", "index", "nextChallengeIndex", "(Ljava/util/List;Lio/ktor/http/auth/HttpAuthHeader;ILjava/lang/String;)Ljava/lang/Integer;", "", "parameters", "matchParameters", "(Ljava/lang/String;ILjava/util/Map;)I", "matchParameter", "matchToken68", "(Ljava/lang/String;I)I", "unescaped", "(Ljava/lang/String;)Ljava/lang/String;", "", "delimiter", "skipDelimiter", "(Ljava/lang/String;IC)I", "skipSpaces", "", "isToken68", "(C)Z", "isToken", "", "TOKEN_EXTRA", "Ljava/util/Set;", "TOKEN68_EXTRA", "Lkotlin/text/Regex;", "token68Pattern", "Lkotlin/text/Regex;", "escapeRegex"})
public final class HttpAuthHeaderKt {
    private static final Set<Character> TOKEN_EXTRA;
    private static final Set<Character> TOKEN68_EXTRA;
    private static final Regex token68Pattern;
    private static final Regex escapeRegex;

    /*
     * WARNING - void declaration
     */
    public static final HttpAuthHeader parseAuthorizationHeader(String headerValue) {
        void var1_2;
        String string;
        int index;
        Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
        int tokenStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue, 0);
        while (index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index))) {
            ++index;
        }
        String authScheme = StringsKt.substring((String)headerValue, (IntRange)RangesKt.until((int)tokenStartIndex, (int)index));
        index = HttpAuthHeaderKt.skipSpaces(headerValue, index);
        if (StringsKt.isBlank((CharSequence)authScheme)) {
            return null;
        }
        if (headerValue.length() == index) {
            return new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null);
        }
        int token68EndIndex = HttpAuthHeaderKt.matchToken68(headerValue, index);
        String token68 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)headerValue, (IntRange)RangesKt.until((int)index, (int)token68EndIndex)))).toString();
        if (((CharSequence)token68).length() > 0 && token68EndIndex == headerValue.length()) {
            return new HttpAuthHeader.Single(authScheme, token68);
        }
        Map parameters = new LinkedHashMap();
        int n = HttpAuthHeaderKt.matchParameters(string, (int)var1_2, parameters);
        if (n == -1) {
            void var3_6;
            void var2_4;
            return new HttpAuthHeader.Parameterized((String)var2_4, (Map)var3_6, null, 4, null);
        }
        throw new ParseException("Function parseAuthorizationHeader can parse only one header", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @InternalAPI
    public static final List<HttpAuthHeader> parseAuthorizationHeaders(String headerValue) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
        int index = 0;
        List headers = new ArrayList();
        while (index != -1) {
            index = HttpAuthHeaderKt.parseAuthorizationHeader(headerValue, index, headers);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseAuthorizationHeader(String headerValue22, int startIndex, List<HttpAuthHeader> headers) {
        void var0_2;
        void var3_6;
        void var2_4;
        void var1_3;
        String headerValue22;
        int index;
        int schemeStartIndex = index = HttpAuthHeaderKt.skipSpaces(headerValue22, startIndex);
        while (index < headerValue22.length() && HttpAuthHeaderKt.isToken(headerValue22.charAt(index))) {
            ++index;
        }
        String authScheme = StringsKt.substring((String)headerValue22, (IntRange)RangesKt.until((int)schemeStartIndex, (int)index));
        if (StringsKt.isBlank((CharSequence)authScheme)) {
            throw new ParseException("Invalid authScheme value: it should be token, can't be blank", null, 2, null);
        }
        index = HttpAuthHeaderKt.skipSpaces(headerValue22, index);
        Integer n = HttpAuthHeaderKt.nextChallengeIndex(headers, new HttpAuthHeader.Parameterized(authScheme, CollectionsKt.emptyList(), null, 4, null), index, headerValue22);
        if (n != null) {
            int n2 = ((Number)n).intValue();
            return n2;
        }
        int token68EndIndex = HttpAuthHeaderKt.matchToken68(headerValue22, index);
        String token68 = ((Object)StringsKt.trim((CharSequence)StringsKt.substring((String)headerValue22, (IntRange)RangesKt.until((int)index, (int)token68EndIndex)))).toString();
        if (((CharSequence)token68).length() > 0 && (token68EndIndex = HttpAuthHeaderKt.nextChallengeIndex(headers, new HttpAuthHeader.Single(authScheme, token68), token68EndIndex, headerValue22)) != null) {
            int headerValue22 = ((Number)token68EndIndex).intValue();
            return headerValue22;
        }
        Map parameters = new LinkedHashMap();
        int nextIndexChallenge = HttpAuthHeaderKt.matchParameters(headerValue22, (int)var1_3, parameters);
        var2_4.add(new HttpAuthHeader.Parameterized((String)var3_6, parameters, null, 4, null));
        return (int)var0_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Integer nextChallengeIndex(List<HttpAuthHeader> headers, HttpAuthHeader header, int index, String headerValue) {
        if (index == headerValue.length() || headerValue.charAt(index) == ',') {
            void var3_3;
            void var1_1;
            List<HttpAuthHeader> list;
            list.add((HttpAuthHeader)var1_1);
            if (index == headerValue.length()) {
                return -1;
            }
            if (var3_3.charAt(index) == ',') {
                void var2_2;
                return (int)(var2_2 + true);
            }
            throw new IllegalStateException("".toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final int matchParameters(String headerValue, int startIndex, Map<String, String> parameters) {
        void var1_1;
        int index = startIndex;
        while (index > 0 && index < headerValue.length()) {
            void var3_3;
            int nextIndex = HttpAuthHeaderKt.matchParameter(headerValue, index, parameters);
            if (nextIndex == index) {
                return index;
            }
            index = HttpAuthHeaderKt.skipDelimiter(headerValue, (int)var3_3, ',');
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int matchParameter(String headerValue, int startIndex, Map<String, String> parameters) {
        void var1_1;
        void var3_4;
        void var2_2;
        String string;
        int keyStart;
        int index;
        for (index = keyStart = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex); index < headerValue.length() && HttpAuthHeaderKt.isToken(headerValue.charAt(index)); ++index) {
        }
        String key = StringsKt.substring((String)headerValue, (IntRange)RangesKt.until((int)keyStart, (int)index));
        if ((index = HttpAuthHeaderKt.skipSpaces(headerValue, index)) == headerValue.length() || headerValue.charAt(index) != '=') {
            return startIndex;
        }
        ++index;
        boolean quoted = false;
        int valueStart = index;
        if (headerValue.charAt(index) == '\"') {
            quoted = true;
            valueStart = ++index;
            boolean escaped = false;
            while (index < headerValue.length() && (headerValue.charAt(index) != '\"' || escaped)) {
                escaped = !escaped && headerValue.charAt(index) == '\\';
                ++index;
            }
            if (index == headerValue.length()) {
                throw new ParseException("Expected closing quote'\"' in parameter", null, 2, null);
            }
        } else {
            for (index = HttpAuthHeaderKt.skipSpaces(headerValue, index); index < headerValue.length() && headerValue.charAt(index) != ' ' && headerValue.charAt(index) != ','; ++index) {
            }
        }
        String value = StringsKt.substring((String)string, (IntRange)RangesKt.until((int)valueStart, (int)index));
        var2_2.put(var3_4, quoted ? HttpAuthHeaderKt.unescaped(value) : value);
        if (var1_1 != false) {
            ++index;
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private static final int matchToken68(String headerValue, int startIndex) {
        void var1_1;
        String string;
        int index;
        for (index = HttpAuthHeaderKt.skipSpaces(headerValue, startIndex); index < headerValue.length() && HttpAuthHeaderKt.isToken68(headerValue.charAt(index)); ++index) {
        }
        while (index < headerValue.length() && headerValue.charAt(index) == '=') {
            ++index;
        }
        return HttpAuthHeaderKt.skipSpaces(string, (int)var1_1);
    }

    private static final String unescaped(String $this$unescaped) {
        CharSequence charSequence = $this$unescaped;
        Regex regex = escapeRegex;
        Function1 function1 = HttpAuthHeaderKt::unescaped$lambda$2;
        return regex.replace(charSequence, function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final int skipDelimiter(String $this$skipDelimiter, int startIndex, char delimiter) {
        void var1_1;
        String string;
        int index = HttpAuthHeaderKt.skipSpaces($this$skipDelimiter, startIndex);
        if (index == $this$skipDelimiter.length()) {
            return -1;
        }
        if ($this$skipDelimiter.charAt(index) != delimiter) {
            void var2_2;
            throw new ParseException("Expected delimiter " + (char)var2_2 + " at position " + index, null, 2, null);
        }
        ++index;
        return HttpAuthHeaderKt.skipSpaces(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final int skipSpaces(String $this$skipSpaces, int startIndex) {
        void var1_1;
        for (int index = startIndex; index < $this$skipSpaces.length() && $this$skipSpaces.charAt(index) == ' '; ++index) {
        }
        return (int)var1_1;
    }

    private static final boolean isToken68(char $this$isToken68) {
        block4: {
            block3: {
                char c;
                if ('a' <= $this$isToken68 ? $this$isToken68 < '{' : false) break block3;
                boolean bl = 'A' <= $this$isToken68 ? $this$isToken68 < '[' : false;
                if (!bl && !CookieUtilsKt.isDigit($this$isToken68) && !TOKEN68_EXTRA.contains(Character.valueOf(c))) break block4;
            }
            return true;
        }
        return false;
    }

    private static final boolean isToken(char $this$isToken) {
        block4: {
            block3: {
                char c;
                if ('a' <= $this$isToken ? $this$isToken < '{' : false) break block3;
                boolean bl = 'A' <= $this$isToken ? $this$isToken < '[' : false;
                if (!bl && !CookieUtilsKt.isDigit($this$isToken) && !TOKEN_EXTRA.contains(Character.valueOf(c))) break block4;
            }
            return true;
        }
        return false;
    }

    private static final CharSequence unescaped$lambda$2(MatchResult it) {
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.takeLast((String)matchResult.getValue(), (int)1);
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }

    static {
        Object[] objectArray = new Character[15];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Character.valueOf('!');
        objectArray2[1] = Character.valueOf('#');
        objectArray2[2] = Character.valueOf('$');
        objectArray2[3] = Character.valueOf('%');
        objectArray2[4] = Character.valueOf('&');
        objectArray2[5] = Character.valueOf('\'');
        objectArray2[6] = Character.valueOf('*');
        objectArray2[7] = Character.valueOf('+');
        objectArray2[8] = Character.valueOf('-');
        objectArray2[9] = Character.valueOf('.');
        objectArray2[10] = Character.valueOf('^');
        objectArray2[11] = Character.valueOf('_');
        objectArray2[12] = Character.valueOf('`');
        objectArray2[13] = Character.valueOf('|');
        objectArray2[14] = Character.valueOf('~');
        TOKEN_EXTRA = SetsKt.setOf((Object[])objectArray2);
        Character[] characterArray = new Character[6];
        objectArray2 = characterArray;
        characterArray[0] = Character.valueOf('-');
        objectArray2[1] = Character.valueOf('.');
        objectArray2[2] = Character.valueOf('_');
        objectArray2[3] = Character.valueOf('~');
        objectArray2[4] = Character.valueOf('+');
        objectArray2[5] = Character.valueOf('/');
        TOKEN68_EXTRA = SetsKt.setOf((Object[])objectArray2);
        token68Pattern = new Regex("[a-zA-Z0-9\\-._~+/]+=*");
        escapeRegex = new Regex("\\\\.");
    }
}

