/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import io.ktor.util.StringValuesBuilder;
import io.ktor.util.StringValuesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a&\u0010\f\u001a\u00020\u00022\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0012\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0013\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0016\u001a/\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a-\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010!\u001a+\u0010&\u001a\u00020\t*\u00060\"j\u0002`#2\b\u0010$\u001a\u0004\u0018\u00010\u00002\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0004\b&\u0010'\"\u0015\u0010*\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010,\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)\"\u0015\u0010.\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b1\u00100\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u00102\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b1\u00102"}, d2={"", "urlString", "Lio/ktor/http/Url;", "Url", "(Ljava/lang/String;)Lio/ktor/http/Url;", "Lio/ktor/http/URLBuilder;", "builder", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/Url;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "buildUrl", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/http/Url;", "parseUrl", "URLBuilder", "(Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "url", "(Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "takeFrom", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "encodedQuery", "", "trailingQuery", "appendUrlFullPath", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;Z)V", "Lio/ktor/http/ParametersBuilder;", "encodedQueryParameters", "(Ljava/lang/Appendable;Ljava/lang/String;Lio/ktor/http/ParametersBuilder;Z)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUser", "encodedPassword", "appendUserAndPassword", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/String;)V", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "fullPath", "getHostWithPort", "hostWithPort", "getHostWithPortIfSpecified", "hostWithPortIfSpecified", "isAbsolutePath", "(Lio/ktor/http/Url;)Z", "isRelativePath", "(Lio/ktor/http/URLBuilder;)Z"})
@SourceDebugExtension(value={"SMAP\nURLUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLUtils.kt\nio/ktor/http/URLUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1#2:194\n1368#3:195\n1454#3,2:196\n1557#3:198\n1628#3,3:199\n1456#3,3:202\n*S KotlinDebug\n*F\n+ 1 URLUtils.kt\nio/ktor/http/URLUtilsKt\n*L\n146#1:195\n146#1:196,2\n147#1:198\n147#1:199,3\n146#1:202,3\n*E\n"})
public final class URLUtilsKt {
    public static final Url Url(String urlString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        return URLUtilsKt.URLBuilder(string).build();
    }

    public static final Url Url(URLBuilder builder) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), uRLBuilder).build();
    }

    public static final Url buildUrl(Function1<? super URLBuilder, Unit> block) {
        Function1<? super URLBuilder, Unit> function1;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        URLBuilder uRLBuilder = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
        function1.invoke((Object)uRLBuilder);
        return uRLBuilder.build();
    }

    public static final Url parseUrl(String urlString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        try {
            object = URLUtilsKt.URLBuilder((String)object);
            URLBuilder uRLBuilder = object;
            Object object2 = ((CharSequence)((URLBuilder)object).getHost()).length() > 0 ? object : null;
            object = object2 != null ? ((URLBuilder)object2).build() : null;
        }
        catch (URLParserException uRLParserException) {
            object = null;
        }
        return object;
    }

    public static final URLBuilder URLBuilder(String urlString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), string);
    }

    public static final URLBuilder URLBuilder(Url url) {
        Url url2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), url2);
    }

    public static final URLBuilder URLBuilder(URLBuilder builder) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), uRLBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public static final URLBuilder takeFrom(URLBuilder $this$takeFrom, URLBuilder url) {
        URLBuilder uRLBuilder;
        void var1_1;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        $this$takeFrom.setProtocolOrNull(url.getProtocolOrNull());
        $this$takeFrom.setHost(url.getHost());
        $this$takeFrom.setPort(url.getPort());
        $this$takeFrom.setEncodedPathSegments(url.getEncodedPathSegments());
        $this$takeFrom.setEncodedUser(url.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder2 = $this$takeFrom;
        StringValuesKt.appendAll((StringValuesBuilder)parametersBuilder2, (StringValuesBuilder)url.getEncodedParameters());
        uRLBuilder2.setEncodedParameters(parametersBuilder);
        $this$takeFrom.setEncodedFragment(url.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(var1_1.getTrailingQuery());
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public static final URLBuilder takeFrom(URLBuilder $this$takeFrom, Url url) {
        URLBuilder uRLBuilder;
        void var1_1;
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        $this$takeFrom.setProtocolOrNull(url.getProtocolOrNull());
        $this$takeFrom.setHost(url.getHost());
        $this$takeFrom.setPort(url.getPort());
        URLBuilderKt.setEncodedPath($this$takeFrom, url.getEncodedPath());
        $this$takeFrom.setEncodedUser(url.getEncodedUser());
        $this$takeFrom.setEncodedPassword(url.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder2 = $this$takeFrom;
        parametersBuilder2.appendAll(QueryKt.parseQueryString$default(url.getEncodedQuery(), 0, 0, false, 6, null));
        uRLBuilder2.setEncodedParameters(parametersBuilder);
        $this$takeFrom.setEncodedFragment(url.getEncodedFragment());
        $this$takeFrom.setTrailingQuery(var1_1.getTrailingQuery());
        return uRLBuilder;
    }

    public static final String getFullPath(Url $this$fullPath) {
        Url url;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$fullPath, (String)"<this>");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        URLUtilsKt.appendUrlFullPath((Appendable)stringBuilder, $this$fullPath.getEncodedPath(), $this$fullPath.getEncodedQuery(), url.getTrailingQuery());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final String getHostWithPort(Url $this$hostWithPort) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)$this$hostWithPort, (String)"<this>");
        return $this$hostWithPort.getHost() + ':' + url.getPort();
    }

    public static final String getHostWithPortIfSpecified(Url $this$hostWithPortIfSpecified) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)$this$hostWithPortIfSpecified, (String)"<this>");
        int n = $this$hostWithPortIfSpecified.getSpecifiedPort();
        if (n == 0 || n == $this$hostWithPortIfSpecified.getProtocol().getDefaultPort()) {
            return $this$hostWithPortIfSpecified.getHost();
        }
        return URLUtilsKt.getHostWithPort(url);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendUrlFullPath(Appendable $this$appendUrlFullPath, String encodedPath, String encodedQuery, boolean trailingQuery) {
        void var2_2;
        Appendable appendable;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$appendUrlFullPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        Intrinsics.checkNotNullParameter((Object)encodedQuery, (String)"encodedQuery");
        if (!StringsKt.isBlank((CharSequence)encodedPath) && !StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append((CharSequence)var1_1);
        if (((CharSequence)encodedQuery).length() > 0 || var3_3 != false) {
            $this$appendUrlFullPath.append("?");
        }
        appendable.append((CharSequence)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendUrlFullPath(Appendable $this$appendUrlFullPath, String encodedPath, ParametersBuilder encodedQueryParameters, boolean trailingQuery2) {
        Appendable appendable;
        void var2_2;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)$this$appendUrlFullPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encodedPath, (String)"encodedPath");
        Intrinsics.checkNotNullParameter((Object)encodedQueryParameters, (String)"encodedQueryParameters");
        if (!StringsKt.isBlank((CharSequence)((CharSequence)encodedPath)) && !StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            $this$appendUrlFullPath.append('/');
        }
        $this$appendUrlFullPath.append((CharSequence)encodedPath);
        if (!encodedQueryParameters.isEmpty() || trailingQuery2) {
            $this$appendUrlFullPath.append("?");
        }
        encodedPath = encodedQueryParameters.entries();
        Collection destination$iv$iv = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            List list;
            Object trailingQuery2 = iterator.next();
            trailingQuery2 = (Map.Entry)trailingQuery2;
            String key = (String)trailingQuery2.getKey();
            List value = (List)trailingQuery2.getValue();
            if (value.isEmpty()) {
                list = CollectionsKt.listOf((Object)TuplesKt.to((Object)key, null));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = value;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    item$iv$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    collection.add(TuplesKt.to((Object)key, (Object)it));
                }
                list = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)var3_4);
        }
        CollectionsKt.joinTo$default((Iterable)((List)var2_2), (Appendable)appendable, (CharSequence)"&", null, null, (int)0, null, URLUtilsKt::appendUrlFullPath$lambda$6, (int)60, null);
    }

    public static final boolean isAbsolutePath(Url $this$isAbsolutePath) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)$this$isAbsolutePath, (String)"<this>");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(url.getRawSegments()), (Object)"");
    }

    public static final boolean isRelativePath(Url $this$isRelativePath) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)$this$isRelativePath, (String)"<this>");
        return !URLUtilsKt.isAbsolutePath(url);
    }

    public static final boolean isAbsolutePath(URLBuilder $this$isAbsolutePath) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$isAbsolutePath, (String)"<this>");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(uRLBuilder.getPathSegments()), (Object)"");
    }

    public static final boolean isRelativePath(URLBuilder $this$isRelativePath) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$isRelativePath, (String)"<this>");
        return !URLUtilsKt.isAbsolutePath(uRLBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendUserAndPassword(StringBuilder $this$appendUserAndPassword, String encodedUser, String encodedPassword) {
        StringBuilder stringBuilder;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$appendUserAndPassword, (String)"<this>");
        if (encodedUser == null) {
            return;
        }
        $this$appendUserAndPassword.append((String)var1_1);
        if (encodedPassword != null) {
            void var2_2;
            $this$appendUserAndPassword.append(':');
            $this$appendUserAndPassword.append((String)var2_2);
        }
        stringBuilder.append("@");
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence appendUrlFullPath$lambda$6(Pair it) {
        Object object;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String key = (String)it.getFirst();
        if (it.getSecond() == null) {
            return key;
        }
        Object value = String.valueOf(it.getSecond());
        return (String)var1_1 + '=' + (String)object;
    }
}

