/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0015\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010#\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010)R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001a\u0010\u000b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010-\u001a\u0004\b.\u0010/R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u00100R\u0016\u00101\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010&R$\u0010 \u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b \u0010&\u001a\u0004\b3\u0010(R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00107R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010,R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010&\u001a\u0004\b8\u0010(R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u00109R\u0017\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\n\u0004\b\t\u0010:R\u0018\u0010=\u001a\u00020\u0002*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u0082\u0002\u0004\n\u0002\b!"}, d2={"Landroidx/compose/foundation/pager/MeasuredPage;", "Landroidx/compose/foundation/pager/PageInfo;", "", "index", "size", "", "Landroidx/compose/ui/layout/Placeable;", "placeables", "Landroidx/compose/ui/unit/IntOffset;", "visualOffset", "", "key", "Landroidx/compose/foundation/gestures/Orientation;", "orientation", "Landroidx/compose/ui/Alignment$Horizontal;", "horizontalAlignment", "Landroidx/compose/ui/Alignment$Vertical;", "verticalAlignment", "Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "", "reverseLayout", "<init>", "(IILjava/util/List;JLjava/lang/Object;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/unit/LayoutDirection;ZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "delta", "", "applyScrollDelta", "(I)V", "Landroidx/compose/ui/layout/Placeable$PlacementScope;", "scope", "place", "(Landroidx/compose/ui/layout/Placeable$PlacementScope;)V", "offset", "layoutWidth", "layoutHeight", "position", "(III)V", "crossAxisSize", "I", "getCrossAxisSize", "()I", "Landroidx/compose/ui/Alignment$Horizontal;", "getIndex", "isVertical", "Z", "Ljava/lang/Object;", "getKey", "()Ljava/lang/Object;", "Landroidx/compose/ui/unit/LayoutDirection;", "mainAxisLayoutSize", "<set-?>", "getOffset", "", "placeableOffsets", "[I", "Ljava/util/List;", "getSize", "Landroidx/compose/ui/Alignment$Vertical;", "J", "getMainAxisSize", "(Landroidx/compose/ui/layout/Placeable;)I", "mainAxisSize"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMeasuredPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasuredPage.kt\nandroidx/compose/foundation/pager/MeasuredPage\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n127#1:144\n33#2,6:132\n69#2,4:138\n74#2:143\n1#3:142\n*S KotlinDebug\n*F\n+ 1 MeasuredPage.kt\nandroidx/compose/foundation/pager/MeasuredPage\n*L\n98#1:144\n50#1:132,6\n74#1:138,4\n74#1:143\n*E\n"})
public final class MeasuredPage
implements PageInfo {
    private final int index;
    private final int size;
    private final List<Placeable> placeables;
    private final long visualOffset;
    private final Object key;
    private final Alignment.Horizontal horizontalAlignment;
    private final Alignment.Vertical verticalAlignment;
    private final LayoutDirection layoutDirection;
    private final boolean reverseLayout;
    private final boolean isVertical;
    private final int crossAxisSize;
    private final int[] placeableOffsets;
    private int offset;
    private int mainAxisLayoutSize;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private MeasuredPage(int index, int size, List<? extends Placeable> placeables, long visualOffset, Object key, Orientation orientation, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout) {
        void var1_1;
        Intrinsics.checkNotNullParameter(placeables, (String)"placeables");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        this.index = index;
        this.size = size;
        this.placeables = placeables;
        this.visualOffset = visualOffset;
        this.key = key;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.layoutDirection = layoutDirection;
        this.reverseLayout = reverseLayout;
        this.isVertical = orientation == Orientation.Vertical;
        int maxCrossAxis = 0;
        List<Placeable> $this$fastForEach$iv = this.placeables;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Placeable placeable;
            Placeable it = placeable = $this$fastForEach$iv.get(index$iv);
            maxCrossAxis = Math.max(maxCrossAxis, !this.isVertical ? it.getHeight() : it.getWidth());
        }
        this.crossAxisSize = var1_1;
        this.placeableOffsets = new int[this.placeables.size() * 2];
        this.mainAxisLayoutSize = Integer.MIN_VALUE;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    public final int getSize() {
        return this.size;
    }

    public final Object getKey() {
        return this.key;
    }

    public final int getCrossAxisSize() {
        return this.crossAxisSize;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    /*
     * WARNING - void declaration
     */
    public final void position(int offset, int layoutWidth, int layoutHeight) {
        this.offset = offset;
        this.mainAxisLayoutSize = this.isVertical ? layoutHeight : layoutWidth;
        List<Placeable> $this$fastForEachIndexed$iv = this.placeables;
        int n = $this$fastForEachIndexed$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void mainAxisOffset2;
            void placeable;
            Placeable item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int n2 = index$iv;
            int indexInArray = n2 * 2;
            if (this.isVertical) {
                Alignment.Horizontal horizontal = this.horizontalAlignment;
                if (horizontal == null) {
                    String mainAxisOffset2 = "null horizontalAlignment";
                    mainAxisOffset2 = "null horizontalAlignment";
                    throw new IllegalArgumentException(mainAxisOffset2.toString());
                }
                this.placeableOffsets[indexInArray] = horizontal.align(placeable.getWidth(), layoutWidth, this.layoutDirection);
                this.placeableOffsets[indexInArray + 1] = mainAxisOffset2;
                mainAxisOffset2 += placeable.getHeight();
                continue;
            }
            this.placeableOffsets[indexInArray] = mainAxisOffset2;
            Alignment.Vertical vertical = this.verticalAlignment;
            if (vertical == null) {
                String mainAxisOffset2 = "null verticalAlignment";
                mainAxisOffset2 = "null verticalAlignment";
                throw new IllegalArgumentException(mainAxisOffset2.toString());
            }
            this.placeableOffsets[indexInArray + 1] = vertical.align(placeable.getHeight(), layoutHeight);
            mainAxisOffset2 += placeable.getWidth();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void place(Placeable.PlacementScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!(this.mainAxisLayoutSize != Integer.MIN_VALUE)) {
            String string = "position() should be called first";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.placeables.size();
        for (int i = 0; i < n; ++i) {
            void $this$place_u24lambda_u247;
            int index22 = i;
            Placeable placeable = this.placeables.get(index22);
            int n2 = index22;
            MeasuredPage index22 = this;
            long offset = IntOffsetKt.IntOffset((int)index22.placeableOffsets[n2 * 2], (int)index22.placeableOffsets[n2 * 2 + 1]);
            if (this.reverseLayout) {
                int n3;
                int mainAxisOffset;
                int n4;
                void this_$iv;
                index22 = this;
                long $this$copy_u2d4Tuh3kE$iv = offset;
                if (this_$iv.isVertical) {
                    n4 = IntOffset.getX-impl((long)$this$copy_u2d4Tuh3kE$iv);
                } else {
                    mainAxisOffset = IntOffset.getX-impl((long)$this$copy_u2d4Tuh3kE$iv);
                    n4 = this.mainAxisLayoutSize - mainAxisOffset - this.getMainAxisSize(placeable);
                }
                if (this_$iv.isVertical) {
                    mainAxisOffset = IntOffset.getY-impl((long)$this$copy_u2d4Tuh3kE$iv);
                    int n5 = n4;
                    n2 = this.mainAxisLayoutSize - mainAxisOffset - this.getMainAxisSize(placeable);
                    n4 = n5;
                    n3 = n2;
                } else {
                    n3 = IntOffset.getY-impl((long)$this$copy_u2d4Tuh3kE$iv);
                }
                offset = IntOffsetKt.IntOffset((int)n4, (int)n3);
            }
            offset = IntOffset.plus-qkQi6aY((long)offset, (long)this.visualOffset);
            if (this.isVertical) {
                Placeable.PlacementScope.placeWithLayer-aW-9-wM$default((Placeable.PlacementScope)$this$place_u24lambda_u247, (Placeable)placeable, (long)offset, (float)0.0f, null, (int)6, null);
                continue;
            }
            Placeable.PlacementScope.placeRelativeWithLayer-aW-9-wM$default((Placeable.PlacementScope)$this$place_u24lambda_u247, (Placeable)placeable, (long)offset, (float)0.0f, null, (int)6, null);
        }
    }

    public final void applyScrollDelta(int delta) {
        MeasuredPage measuredPage = this;
        measuredPage.offset += delta;
        int n = this.placeableOffsets.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            if ((!this.isVertical || index % 2 != 1) && (this.isVertical || index % 2 != 0)) continue;
            int[] nArray = this.placeableOffsets;
            this.placeableOffsets[index] = nArray[index] + delta;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getMainAxisSize(Placeable $this$mainAxisSize) {
        void var1_1;
        if (this.isVertical) {
            return $this$mainAxisSize.getHeight();
        }
        return var1_1.getWidth();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ MeasuredPage(int index, int size, List placeables, long visualOffset, Object key, Orientation orientation, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, DefaultConstructorMarker $constructor_marker) {
        this((int)var1_1, (int)var2_2, (List<? extends Placeable>)var3_3, visualOffset, key, orientation, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout);
        void var3_3;
        void var2_2;
        void var1_1;
    }
}

